/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.fill.JaxoBlob;
import net.sf.jaxodraw.JaxoTestUtils;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoRotationEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoRotationEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoRotationEditPanel panel = new JaxoRotationEditPanel();
        JSpinner spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "rotation");
        assertNotNull("No rotation spinner found!", spinner);
        SpinnerNumberModel model = (SpinnerNumberModel) spinner.getModel();
        int value = model.getNumber().intValue();
        assertEquals(0, value);

        panel = new JaxoRotationEditPanel(20);
        spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "rotation");
        model = (SpinnerNumberModel) spinner.getModel();
        value = model.getNumber().intValue();
        assertEquals(20, value);

        JaxoBlob blob = new JaxoBlob();
        blob.setLocation(10, 10, 20, 20);
        blob.setRotationAngle(45);

        panel = new JaxoRotationEditPanel(blob.getRotationAngle());
        spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "rotation");
        model = (SpinnerNumberModel) spinner.getModel();
        value = model.getNumber().intValue();
        assertEquals(45, value);

        ChangeListener[] listeners = spinner.getChangeListeners();
        assertEquals(2, listeners.length);
        panel.addEditPanelListener(null);
        listeners = spinner.getChangeListeners();
        assertEquals(2, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(blob));
        listeners = spinner.getChangeListeners();
        assertEquals(3, listeners.length);

        spinner.setValue(new Integer(99));
        assertEquals(99, blob.getRotationAngle());

    }

}
