/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.line.JaxoPLine;
import net.sf.jaxodraw.JaxoTestUtils;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoWiggleEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoWiggleEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoWiggleEditPanel panel = new JaxoWiggleEditPanel();
        JSpinner amp = (JSpinner) JaxoTestUtils.getChildNamed(panel, "amp");
        JSpinner wiggle = (JSpinner) JaxoTestUtils.getChildNamed(panel, "wiggle");
        assertNotNull("No amplitude spinner found!", amp);
        assertNotNull("No wiggle spinner found!", wiggle);
        SpinnerNumberModel modelx = (SpinnerNumberModel) amp.getModel();
        SpinnerNumberModel modely = (SpinnerNumberModel) wiggle.getModel();
        int value = modelx.getNumber().intValue();
        assertEquals(10, value);
        value = modely.getNumber().intValue();
        assertEquals(10, value);

        panel = new JaxoWiggleEditPanel(20, 30);
        amp = (JSpinner) JaxoTestUtils.getChildNamed(panel, "amp");
        wiggle = (JSpinner) JaxoTestUtils.getChildNamed(panel, "wiggle");
        modelx = (SpinnerNumberModel) amp.getModel();
        modely = (SpinnerNumberModel) wiggle.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(20, value);
        value = modely.getNumber().intValue();
        assertEquals(30, value);

        JaxoPLine line = new JaxoPLine();
        line.setLocation(10, 50, 30, 70);
        line.setAmp(15);
        line.setWiggles(25);
        panel = new JaxoWiggleEditPanel(line.getAmp(), line.getWiggles());

        amp = (JSpinner) JaxoTestUtils.getChildNamed(panel, "amp");
        wiggle = (JSpinner) JaxoTestUtils.getChildNamed(panel, "wiggle");
        modelx = (SpinnerNumberModel) amp.getModel();
        modely = (SpinnerNumberModel) wiggle.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(15, value);
        value = modely.getNumber().intValue();
        assertEquals(25, value);

        ChangeListener[] listeners = amp.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = wiggle.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(null);
        listeners = amp.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = wiggle.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(line));
        listeners = amp.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = wiggle.getChangeListeners();
        assertEquals(2, listeners.length);

        amp.setValue(new Integer(50));
        wiggle.setValue(new Integer(10));
        assertEquals(50, line.getAmp());
        assertEquals(10, line.getWiggles());

    }

}
