/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.io.exports;

import java.io.File;

/**
 * Test for JaxoExportImg.
 */
public class JaxoExportImgTest extends AbstractJaxoExportTest {
    private final JaxoExportImg exportPNG = new JaxoExportImg(JaxoExportImg.Format.PNG);
    private final JaxoExportImg exportJPG = new JaxoExportImg(JaxoExportImg.Format.JPG);

    /** Constructor.
     * @param testName The name of this test.
     */
    public JaxoExportImgTest(String testName) {
        super(testName);
    }

    /**
     * Test of getFileExtension method, of class net.sf.jaxodraw.io.export.JaxoExportImg.
     */
    public void testGetFileExtension() {
        String expResult = "png";
        String result = exportPNG.getFileExtension();
        assertEquals(expResult, result);

        expResult = "jpg";
        result = exportJPG.getFileExtension();
        assertEquals(expResult, result);
    }

    /**
     * Test of exportTo method, of class net.sf.jaxodraw.io.export.JaxoExportImg.
     * @throws Exception Exception.
     */
    public void testExportTo() throws Exception {
        File jpg = getOutputFile(getBase(), "jpgExportTest.jpg");

        exportJPG.setGraph(getTestGraph());
        exportJPG.exportTo(jpg.getAbsolutePath());

        assertTrue("No jpg file created!", jpg.exists());
        assertTrue("Empty jpg file created!", jpg.length() > 0);


        File png = getOutputFile(getBase(), "pngExportTest.png");

        exportPNG.setGraph(getTestGraph());
        exportPNG.exportTo(png.getAbsolutePath());

        assertTrue("No png file created!", png.exists());
        assertTrue("Empty png file created!", png.length() > 0);

    }

    /** {@inheritDoc} */
    public JaxoExport getInstance() {
        return new JaxoExportImg(JaxoExportImg.Format.PNG);
    }
}
