/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.io.imports;

import net.sf.jaxodraw.AbstractJaxoBaseTest;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.arc.JaxoArcObject;

/**
 * Test for JaxoAxodraw4J.
 */
public class JaxoAxodraw4JTest extends AbstractJaxoBaseTest {

    /**
     * Constructor. Just calls super().
     *
     * @param testName the name of this test.
     */
    public JaxoAxodraw4JTest(String testName) {
        super(testName);
    }

    /** Tests proper import of clock/anti-clockwise arcs. */
    public void testClockwiseArcs() {
        String all = getResourceFile("io", "arcs_clockwise_test.tex").getAbsolutePath();
        JaxoGraph graph = (new JaxoImportAxodraw()).importGraph(all);
        JaxoList<JaxoObject> arcList = graph.getObjectList();

        assertNotNull("latex import gave Null!", graph);
        assertEquals("wrong number of arcs!", 16, arcList.size());

        JaxoArcObject arc = (JaxoArcObject) arcList.get(0);
        assertEquals(80, arc.getX());
        assertEquals(45, arc.getY());
        assertFalse(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(1);
        assertEquals(180, arc.getX());
        assertEquals(45, arc.getY());
        assertTrue(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(2);
        assertEquals(280, arc.getX());
        assertEquals(45, arc.getY());
        assertFalse(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(3);
        assertEquals(380, arc.getX());
        assertEquals(45, arc.getY());
        assertTrue(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(4);
        assertEquals(80, arc.getX());
        assertEquals(145, arc.getY());
        assertFalse(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(5);
        assertEquals(180, arc.getX());
        assertEquals(145, arc.getY());
        assertTrue(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(6);
        assertEquals(280, arc.getX());
        assertEquals(145, arc.getY());
        assertFalse(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(7);
        assertEquals(380, arc.getX());
        assertEquals(145, arc.getY());
        assertTrue(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(8);
        assertEquals(80, arc.getX());
        assertEquals(245, arc.getY());
        assertFalse(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(9);
        assertEquals(180, arc.getX());
        assertEquals(245, arc.getY());
        assertTrue(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(10);
        assertEquals(280, arc.getX());
        assertEquals(245, arc.getY());
        assertFalse(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(11);
        assertEquals(380, arc.getX());
        assertEquals(245, arc.getY());
        assertTrue(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(12);
        assertEquals(80, arc.getX());
        assertEquals(345, arc.getY());
        assertFalse(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(13);
        assertEquals(180, arc.getX());
        assertEquals(345, arc.getY());
        assertTrue(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(14);
        assertEquals(280, arc.getX());
        assertEquals(345, arc.getY());
        assertFalse(arc.isClockwise());

        arc = (JaxoArcObject) arcList.get(15);
        assertEquals(380, arc.getX());
        assertEquals(345, arc.getY());
        assertTrue(arc.isClockwise());
    }
}
