/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.fill;

import java.awt.Point;
import java.awt.Rectangle;
import net.sf.jaxodraw.object.AbstractJaxoExtendedObjectTest;


/**
 * Base Test for JaxoFillObjects.
 */
public abstract class AbstractJaxoFillObjectTest
    extends AbstractJaxoExtendedObjectTest {

    private JaxoFillObject instance;

    /**
     * Constructor.
     *
     * @param testName The name of this test.
     */
    protected AbstractJaxoFillObjectTest(String testName) {
        super(testName);
    }

    /** JUnit setup: get a new instance of the object. */
    @Override
    protected void setUp() {
        super.setUp();
        this.instance = (JaxoFillObject) getInstance();
    }

      //
     // tests
    //

    /** Tests moveBy. */
    public void testMoveBy() {
        instance.setLocation(100, 100, 200, 200);
        instance.moveBy(23, -45);

        assertEquals("Wrong moveBy x!", 123, instance.getX());
        assertEquals("Wrong moveBy y!", 55, instance.getY());
        assertEquals("Wrong moveBy x2!", 223, instance.getX2());
        assertEquals("Wrong moveBy y2!", 155, instance.getY2());
    }

    /** Tests smallestDistanceTo. */
    public void testSmallestDistanceTo() {
        instance.setLocation(100, 100, 200, 200);

        float dist = instance.smallestDistanceTo(103, 104);
        assertEquals("Wrong distance", dist, 5.f);
        dist = instance.smallestDistanceTo(203, 204);
        assertEquals("Wrong distance", dist, 5.f);
    }

    /** Tests rescaleObject. */
    public void testRescaleObject() {
        instance.setLocation(100, 100, 200, 200);

        instance.rescaleObject(instance.getX(), instance.getY(), 2.f);
        assertEquals("Line x wrongly rescaled!", 200, instance.getRelw());
        assertEquals("Line y wrongly rescaled!", 200, instance.getRelh());
    }

    /** {@inheritDoc} */
    public void testContains() {
        instance.setLocation(100, 100, 200, 200);

        assertTrue(getInstance().contains(175, 175));
        assertFalse(getInstance().contains(205, 205));

        assertTrue(getInstance().contains(175, 175, 5, 5));
        assertFalse(getInstance().contains(205, 205, 3, 3));

        assertTrue(getInstance().contains(new Point(175, 175)));
        assertFalse(getInstance().contains(new Point(205, 205)));

        assertTrue(getInstance().contains(new Rectangle(175, 175, 5, 5)));
        assertFalse(getInstance().contains(new Rectangle(205, 205, 5, 5)));
    }

    /** {@inheritDoc} */
    public void testIntersects() {
        instance.setLocation(100, 100, 200, 200);

        assertTrue(getInstance().intersects(100, 100, 10, 10));
        assertFalse(getInstance().intersects(205, 205, 3, 3));

        assertTrue(getInstance().intersects(new Rectangle(130, 130)));
        assertFalse(getInstance().intersects(new Rectangle(250, 250, 10, 10)));
    }

      //
     // abstract
    //

    /** Tests serialization. */
    public abstract void testSerialization();

}
