/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.line;

import junit.framework.TestCase;

import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.util.JaxoColor;

/**
 * Test for JaxoLineOptionsPanel.
 */
public class JaxoLineOptionsPanelTest extends TestCase {

    /**
     * Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoLineOptionsPanelTest(String testName) {
        super(testName);
    }

    /** Test preparePanel for JaxoFLine. */
    public void testPreparePanelForFLine() {
        initLineAndCheckPanel(new JaxoFLine());
    }

    /** Test preparePanel for JaxoGLine. */
    public void testPreparePanelForGLine() {
        initLineAndCheckPanel(new JaxoGLine());
    }

    /** Test preparePanel for JaxoSLine. */
    public void testPreparePanelForSLine() {
        initLineAndCheckPanel(new JaxoSLine());
    }

    /** Test preparePanel for JaxoPLine. */
    public void testPreparePanelForPLine() {
        initLineAndCheckPanel(new JaxoPLine());
    }

    /** Test preparePanel for JaxoGlLine. */
    public void testPreparePanelForGlLine() {
        initLineAndCheckPanel(new JaxoGlLine());
    }

    /** Test preparePanel for JaxoZigZagLine. */
    public void testPreparePanelForZigZagLine() {
        initLineAndCheckPanel(new JaxoZigZagLine());
    }

    private void initLineAndCheckPanel(JaxoLineObject line) {
        line.setLocation(100, 100);
        line.setRelWAndH(100, 100);
        line.setColor(JaxoColor.GREEN);
        line.setStrokeWidth(1.f);
        line.setDash(1.f);
        line.setPaintArrow(false);
        line.setFlip(false);
        line.setDoubleLine(false);
        line.setDLSeparation(2.f);

        if (line instanceof JaxoWiggleObject) {
            ((JaxoWiggleObject) line).setWiggles(15);
            ((JaxoWiggleObject) line).setAmp(15);
        }

        JaxoObjectEditPanel panel = new JaxoOptionsPanel(line);

        assertNotNull(panel);
        line.prepareEditPanel(panel);
    }

}
