/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.text;

import junit.framework.TestCase;

import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.util.JaxoColor;

/**
 * Test for JaxoTextOptionsPanel.
 */
public class JaxoTextOptionsPanelTest extends TestCase {

    /**
     * Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoTextOptionsPanelTest(String testName) {
        super(testName);
    }

    /** Test preparePanel for JaxoPSText. */
    public void testPreparePanelForPSText() {
        initTextAndCheckPanel(new JaxoPSText());
    }

    /** Test preparePanel for JaxoLatexText. */
    public void testPreparePanelForLatexText() {
        initTextAndCheckPanel(new JaxoLatexText());
    }

    private void initTextAndCheckPanel(JaxoTextObject text) {
        text.setLocation(100, 100);
        text.setColor(JaxoColor.BLACK);
        text.setRotationAngle(0);
        text.setTextString("Feynman");

        if (text instanceof JaxoLatexText) {
            ((JaxoLatexText) text).setAllign(JaxoLatexText.ALIGN_LB);
            ((JaxoLatexText) text).setLatexTextSize(JaxoLatexText.XLARGE);
        }

        JaxoObjectEditPanel panel = new JaxoOptionsPanel(text);

        assertNotNull(panel);
        text.prepareEditPanel(panel);
    }


}
