/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.vertex;

import junit.framework.TestCase;

import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.object.JaxoFillColorObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.util.JaxoColor;

/**
 * Test for JaxoVertexOptionsPanel.
 */
public class JaxoVertexOptionsPanelTest extends TestCase {

    /**
     * Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoVertexOptionsPanelTest(String testName) {
        super(testName);
    }

    /** Test preparePanel for JaxoVertexT1. */
    public void testPreparePanelForVertexT1() {
        initVertexAndCheckPanel(new JaxoVertexT1());
    }

    /** Test preparePanel for JaxoVertexT2. */
    public void testPreparePanelForVertexT2() {
        initVertexAndCheckPanel(new JaxoVertexT2());
    }

    /** Test preparePanel for JaxoVertexT3. */
    public void testPreparePanelForVertexT3() {
        initVertexAndCheckPanel(new JaxoVertexT3());
    }

    /** Test preparePanel for JaxoVertexT4. */
    public void testPreparePanelForVertexT4() {
        initVertexAndCheckPanel(new JaxoVertexT4());
    }

    /** Test preparePanel for JaxoVertexT5. */
    public void testPreparePanelForVertexT5() {
        initVertexAndCheckPanel(new JaxoVertexT5());
    }

    /** Test preparePanel for JaxoVertexT6. */
    public void testPreparePanelForVertexT6() {
        initVertexAndCheckPanel(new JaxoVertexT6());
    }

    private void initVertexAndCheckPanel(JaxoVertex vertex) {
        vertex.setLocation(100, 100);
        vertex.setRelWAndH(100, 100);
        vertex.setColor(JaxoColor.GREEN);
        vertex.setStrokeWidth(1.f);

        if (vertex instanceof JaxoFillColorObject) {
            ((JaxoFillColorObject) vertex).setFillColor(JaxoColor.RED);
        }

        JaxoObjectEditPanel panel = new JaxoOptionsPanel(vertex);

        assertNotNull(panel);
        vertex.prepareEditPanel(panel);
    }

    private void initVertexAndCheckPanel(JaxoVertexT5 vertex) {
        vertex.setLocation(50, 50, 100, 50, 100, 100);
        vertex.setColor(JaxoColor.GREEN);
        vertex.setStrokeWidth(1.f);

        if (vertex instanceof JaxoFillColorObject) {
            ((JaxoFillColorObject) vertex).setFillColor(JaxoColor.RED);
        }

        JaxoObjectEditPanel panel = new JaxoOptionsPanel(vertex);

        assertNotNull(panel);
        vertex.prepareEditPanel(panel);
    }

}
