/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.plugin;

import junit.framework.TestCase;

/**
 * Tests for JaxoPluginExecutionException.
 */
public class JaxoPluginExecutionExceptionTest extends TestCase {

    /**
     * Constructor: just calls super().
     *
     * @param testName The name of this test.
     */
    public JaxoPluginExecutionExceptionTest(String testName) {
        super(testName);
    }

    /**
     * Test constructors, of class JaxoPluginExecutionException.
     */
    public void testConstructors() {
        JaxoPluginExecutionException exc;

        String message = "ouch!";

        exc = new JaxoPluginExecutionException(null);
        assertNull(exc.getSource());
        assertNull(exc.getCause());
        assertNull(exc.getMessage());

        exc = new JaxoPluginExecutionException(message, null);
        assertNull(exc.getSource());
        assertNull(exc.getCause());
        assertEquals(message, exc.getMessage());

        exc = new JaxoPluginExecutionException(message, new Exception(), "");
        assertEquals("", exc.getSource());
        assertNotNull(exc.getCause());
        assertEquals(message, exc.getMessage());
    }
}
