/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.util;

import junit.framework.TestCase;


/** Tests for JaxoConstants. */
public class JaxoConstantsTest extends TestCase {
    /** Constructor: just calls super.
     * @param testName The name of this test.
     */
    public JaxoConstantsTest(String testName) {
        super(testName);
    }

    /**
     * Test of isEditMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsEditMode() {
        assertTrue(JaxoConstants.isEditMode(JaxoConstants.UNGROUP));
        assertTrue(JaxoConstants.isEditMode(JaxoConstants.MOVE));
        assertFalse(JaxoConstants.isEditMode(JaxoConstants.TEXT));
    }

    /**
     * Test of isParticleMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsParticleMode() {
        assertTrue(JaxoConstants.isParticleMode(JaxoConstants.FLINE));
        assertTrue(JaxoConstants.isParticleMode(JaxoConstants.GLARC));
        assertFalse(JaxoConstants.isParticleMode(JaxoConstants.TEXT));
    }

    /**
     * Test of isMiscMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsMiscMode() {
        assertTrue(JaxoConstants.isMiscMode(JaxoConstants.BOX));
        assertTrue(JaxoConstants.isMiscMode(JaxoConstants.LATEX));
        assertFalse(JaxoConstants.isMiscMode(JaxoConstants.COLOR));
    }

    /**
     * Test of isFileMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsFileMode() {
        assertTrue(JaxoConstants.isFileMode(JaxoConstants.NEWG));
        assertTrue(JaxoConstants.isFileMode(JaxoConstants.EXPORT_SELECTION));
        assertFalse(JaxoConstants.isFileMode(JaxoConstants.RECENT_FILE));
    }

    /**
     * Test of isActionMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsActionMode() {
        assertTrue(JaxoConstants.isActionMode(JaxoConstants.UNDO));
        assertTrue(JaxoConstants.isActionMode(
                JaxoConstants.LATEX_PREVIEW_SELECTION));
        assertFalse(JaxoConstants.isActionMode(JaxoConstants.ABOUT));
    }

    /**
     * Test of isGridMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsGridMode() {
        assertTrue(JaxoConstants.isGridMode(JaxoConstants.GRID));
        assertTrue(JaxoConstants.isGridMode(JaxoConstants.HEXAGONAL_GRID));
        assertFalse(JaxoConstants.isGridMode(JaxoConstants.ABOUT));
    }

    /**
     * Test of isVertexMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsVertexMode() {
        assertTrue(JaxoConstants.isVertexMode(JaxoConstants.VERTEXT1));
        assertTrue(JaxoConstants.isVertexMode(JaxoConstants.VERTEXT6));
        assertFalse(JaxoConstants.isVertexMode(JaxoConstants.ABOUT));
    }

    /**
     * Test of isZoomFactorMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsZoomFactorMode() {
        assertTrue(JaxoConstants.isZoomFactorMode(JaxoConstants.ZOOM_FACTOR));
        assertTrue(JaxoConstants.isZoomFactorMode(JaxoConstants.ZOOM_FACTOR_X8));
        assertFalse(JaxoConstants.isZoomFactorMode(JaxoConstants.ABOUT));
    }

    /**
     * Test of isHelpMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsHelpMode() {
        assertTrue(JaxoConstants.isHelpMode(JaxoConstants.ABOUT));
        assertTrue(JaxoConstants.isHelpMode(JaxoConstants.MAC_README));
        assertFalse(JaxoConstants.isHelpMode(JaxoConstants.SELECT));
    }

    /**
     * Test of isLanguageMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsLanguageMode() {
        assertTrue(JaxoConstants.isLanguageMode(JaxoConstants.ENGLISH));
        assertTrue(JaxoConstants.isLanguageMode(JaxoConstants.SPANISH));
        assertFalse(JaxoConstants.isLanguageMode(JaxoConstants.SELECT));
    }

    /**
     * Test of isOptionMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsOptionMode() {
        assertTrue(JaxoConstants.isOptionMode(JaxoConstants.TOOLBAR));
        assertTrue(JaxoConstants.isOptionMode(JaxoConstants.GRID_ONOFF));
        assertFalse(JaxoConstants.isOptionMode(JaxoConstants.SELECT));
    }

    /**
     * Test of isDefaultMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsDefaultMode() {
        assertTrue(JaxoConstants.isDefaultMode(JaxoConstants.DEF_NONE));
        assertTrue(JaxoConstants.isDefaultMode(JaxoConstants.DEF_EDIT));
        assertFalse(JaxoConstants.isDefaultMode(JaxoConstants.SELECT));
    }

    /**
     * Test of isLineMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsLineMode() {
        assertTrue(JaxoConstants.isLineMode(JaxoConstants.FLINE));
        assertFalse(JaxoConstants.isLineMode(JaxoConstants.FLOOP));
    }

    /**
     * Test of isArcMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsArcMode() {
        assertTrue(JaxoConstants.isArcMode(JaxoConstants.FARC));
        assertFalse(JaxoConstants.isArcMode(JaxoConstants.FLOOP));
    }

    /**
     * Test of isLoopMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsLoopMode() {
        assertTrue(JaxoConstants.isLoopMode(JaxoConstants.FLOOP));
        assertFalse(JaxoConstants.isLoopMode(JaxoConstants.FARC));
    }

    /**
     * Test of isBezierMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsBezierMode() {
        assertTrue(JaxoConstants.isBezierMode(JaxoConstants.FBEZ));
        assertFalse(JaxoConstants.isBezierMode(JaxoConstants.FARC));
    }

    /**
     * Test of isNewObjectMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsNewObjectMode() {
        assertTrue(JaxoConstants.isNewObjectMode(JaxoConstants.FBEZ));
        assertTrue(JaxoConstants.isNewObjectMode(JaxoConstants.VERTEX));
        assertTrue(JaxoConstants.isNewObjectMode(JaxoConstants.VERTEXT1));
        assertTrue(JaxoConstants.isNewObjectMode(JaxoConstants.VERTEXT6));
        assertFalse(JaxoConstants.isNewObjectMode(JaxoConstants.EDIT));
    }

    /**
     * Test of isTextMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsTextMode() {
        assertTrue(JaxoConstants.isTextMode(JaxoConstants.TEXT));
        assertTrue(JaxoConstants.isTextMode(JaxoConstants.LATEX));
        assertFalse(JaxoConstants.isTextMode(JaxoConstants.EDIT));
    }

    /**
     * Test of isSelectMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testIsSelectMode() {
        assertTrue(JaxoConstants.isSelectMode(JaxoConstants.EDIT));
        assertTrue(JaxoConstants.isSelectMode(JaxoConstants.COLOR));
        assertFalse(JaxoConstants.isSelectMode(JaxoConstants.FLINE));
    }

    /**
     * Test of getModeAsInt method, of class JaxoDraw.JaxoConstants.
     */
    public void testGetModeAsInt() {
        int expResult = JaxoConstants.GRID;
        String modeString = JaxoConstants.getModeAsString(expResult);
        int result = JaxoConstants.getModeAsInt(modeString);
        assertEquals(expResult, result);
    }

    /**
     * Test of defaultActionToMode method, of class JaxoDraw.JaxoConstants.
     */
    public void testDefaultActionToMode() {
        checkPair(JaxoConstants.STANDBY, JaxoConstants.DEF_NONE);
        checkPair(JaxoConstants.FLINE, JaxoConstants.DEF_FLINE);
        checkPair(JaxoConstants.FLOOP, JaxoConstants.DEF_FLOOP);
        checkPair(JaxoConstants.FARC, JaxoConstants.DEF_FARC);
        checkPair(JaxoConstants.SLINE, JaxoConstants.DEF_SLINE);
        checkPair(JaxoConstants.SLOOP, JaxoConstants.DEF_SLOOP);
        checkPair(JaxoConstants.SARC, JaxoConstants.DEF_SARC);
        checkPair(JaxoConstants.GLINE, JaxoConstants.DEF_GLINE);
        checkPair(JaxoConstants.GLOOP, JaxoConstants.DEF_GLOOP);
        checkPair(JaxoConstants.GARC, JaxoConstants.DEF_GARC);
        checkPair(JaxoConstants.PLINE, JaxoConstants.DEF_PLINE);
        checkPair(JaxoConstants.PLOOP, JaxoConstants.DEF_PLOOP);
        checkPair(JaxoConstants.PARC, JaxoConstants.DEF_PARC);
        checkPair(JaxoConstants.GLLINE, JaxoConstants.DEF_GLLINE);
        checkPair(JaxoConstants.GLLOOP, JaxoConstants.DEF_GLLOOP);
        checkPair(JaxoConstants.GLARC, JaxoConstants.DEF_GLARC);
        checkPair(JaxoConstants.BOX, JaxoConstants.DEF_BOX);
        checkPair(JaxoConstants.BLOB, JaxoConstants.DEF_BLOB);
        checkPair(JaxoConstants.VERTEX, JaxoConstants.DEF_VERTEX);
        checkPair(JaxoConstants.ZIGZAG, JaxoConstants.DEF_ZIGZAG);
        checkPair(JaxoConstants.TEXT, JaxoConstants.DEF_TEXT);
        checkPair(JaxoConstants.LATEX, JaxoConstants.DEF_LATEX);
        checkPair(JaxoConstants.MOVE, JaxoConstants.DEF_MOVE);
        checkPair(JaxoConstants.RESIZE, JaxoConstants.DEF_RESIZE);
        checkPair(JaxoConstants.DUPLICATE, JaxoConstants.DEF_DUPLICATE);
        checkPair(JaxoConstants.COLOR, JaxoConstants.DEF_COLOR);
        checkPair(JaxoConstants.EDIT, JaxoConstants.DEF_EDIT);
        // the following logs a warning!
        checkPair(JaxoConstants.STANDBY, JaxoConstants.OPEN);
    }

    private void checkPair(int expected, int mode) {
        assertEquals(expected, JaxoConstants.defaultActionToMode(mode));
    }

}
