/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.util;

import junit.framework.TestCase;

/**
 * Tests JaxoUtils.
 */
public class JaxoUtilsTest extends TestCase {

    /** Constructor: just calls super.
     * @param testName The name of this test.
     */
    public JaxoUtilsTest(String testName) {
        super(testName);
    }

    /**
     * Test of equal method, of class net.sf.jaxodraw.util.JaxoUtils.
     */
    public void testEqual() {
        assertTrue(JaxoUtils.equal(1.00002f, 1.00005f));
        assertFalse(JaxoUtils.equal(1.02f, 1.05f));
        assertTrue(JaxoUtils.equal(1.02f, 1.05f, 0.1f));
        assertFalse(JaxoUtils.equal(1.2f, 1.5f, 0.1f));
        assertTrue(JaxoUtils.equal(0.002f, 0.005f, 0.1f));
        assertTrue(JaxoUtils.equal(1.00005f, 1.00005f, 0.f));

        try {
            JaxoUtils.equal(1.00005f, 1.00005f, -1.f);
        } catch (IllegalArgumentException e) {
            assertNotNull(e);
        }
    }

    /**
     * Test of zero method, of class net.sf.jaxodraw.util.JaxoUtils.
     */
    public void testZero() {
        assertTrue(JaxoUtils.zero(0.00001d));
        assertFalse(JaxoUtils.zero(0.01d));
    }

    /**
     * Test of toString method, of class net.sf.jaxodraw.util.JaxoUtils.
     */
    public void testToString() {
        Object[] array = null;

        String expResult = "null";
        String result = JaxoUtils.toString(array);
        assertEquals(expResult, result);

        array = new String[] {"1", "2"};
        expResult = "[1,2]";
        result = JaxoUtils.toString(array);
        assertEquals(expResult, result);
    }

    /**
     * Test of equivalent/equals method.
     */
    public void testArrayEquivalence() {
        String[] array1 = new String[] {"chip", "dale"};
        String[] array2 = new String[] {"chip", "dale"};
        String[] array3 = new String[] {"dale", "chip"};
        String[] array4 = new String[] {"chip", "dale", "donald"};

        assertTrue(JaxoUtils.equals(array1, array2));
        assertTrue(JaxoUtils.equivalent(array1, array2));
        assertFalse(JaxoUtils.equals(array1, array3));
        assertTrue(JaxoUtils.equivalent(array1, array3));
        assertFalse(JaxoUtils.equals(array1, array4));
        assertFalse(JaxoUtils.equivalent(array1, array4));
    }
}
