library Connect;

uses Windows, SysUtils, WinSock;

Function PingService(
    Address: PChar;
    Status: PChar;
    Error: PChar;
    Port: WORD;
    UserName: PChar;
    Password: PChar;
    Params: PChar;
    iTimeOutMSec: DWORD): BOOL; stdcall;

Var Socket: TSocket;
    SIN: TSockAddrIn;
Begin
  SIN.SIN_Addr.S_Addr:=Inet_Addr(PChar(Address));

  If SIN.SIN_Addr.S_Addr=INADDR_NONE then
  Begin
    Result:=False;
    StrPCopy(Status, '%Status %Address: incorrect address.');
    Exit;
  End;

  SIN.sin_family:=AF_INET;
  SIN.sin_port:=HToNS(Port);

  Socket:=WinSock.Socket(AF_INET, SOCK_STREAM, IPPROTO_IP);

  If Socket=INVALID_SOCKET then
  Begin
    Result:=False;
    StrPCopy(Status, '%Status %Address: network initialization failed.');
    Exit;
  End;

  Result:=(WinSock.Connect(Socket, SIN, SizeOf(SIN))=0);

  If Result then
    StrPCopy(Status, '%Status %Address: connection established.')
  Else
    StrPCopy(Status, '%Status %Address: connection failed.');

  CloseSocket(Socket);
End;

Procedure GetTitle(Buffer: PChar); stdcall;
Begin
  StrPCopy(Buffer, 'Connect to port');
End;

Procedure GetDescription(Buffer: PChar); stdcall;
Begin
  StrPCopy(Buffer, 'Tests a connection to the specified port.');
End;

Function GetSolveIP: BOOL;
Begin
  Result:=True;
End;

Function GetPortRequired: BOOL; stdcall;
Begin
  Result:=True;
End;

Function GetUserNameRequired: BOOL; stdcall;
Begin
  Result:=False;
End;

Function GetPasswordRequired: BOOL; stdcall;
Begin
  Result:=False;
End;

Function GetParamsRequired: BOOL; stdcall;
Begin
  Result:=False;
End;

exports
  PingService,
  GetTitle,
  GetDescription,
  GetSolveIP,
  GetPortRequired,
  GetUserNameRequired,
  GetPasswordRequired,
  GetParamsRequired;

begin
end.
