-- Mod: Animal Status
-- Author: Oectacan

local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");

animalStatus = {};
animalStatus.version = getXMLString(modDesc, "modDesc.version");
animalStatus.modDirectory = g_currentModDirectory;
hudActive = false;

addModEventListener(animalStatus);

function animalStatus:loadMap()

	print("--- Animal Status v.:" .. self.version .. ", by Oectacan loaded");

end;

function animalStatus:keyEvent(unicode, sym, modifier, isDown)
end;

function animalStatus:mouseEvent(posX, posY, isDown, isUp, button)
end;

function animalStatus:deleteMap()
end;

function animalStatus:update(dt)

	if InputBinding.hasEvent(InputBinding.AS_TRIGER) then
		hudActive =not hudActive;
	end;	

end;

function animalStatus:draw()

	if hudActive == true then

		local posX = 0.01; -- Data X position
		local posX2 = posX + 0.1; -- Data offset X position
		local posY = 0.8; -- Data Y position
		local paddingY = 0.005; -- Padding between blocks
		local fontSize = 0.015; -- Block font size
		local lineDist = fontSize + 0.002;  -- Distancr between lines
		setTextColor(1,1,1,1);
		
		--Chickens info
		if g_currentMission.husbandries.chicken.totalNumAnimals > 1 then
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "鸡 : ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, g_currentMission.husbandries.chicken.totalNumAnimals .. " 只"); posY = posY - lineDist;
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "蛋 : ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.chicken.numActivePickupObjects) .. " 个"); posY = posY - lineDist - paddingY;
		end;

		--Sheeps info
		if g_currentMission.husbandries.sheep.totalNumAnimals > 0 then
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "羊 :");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, g_currentMission.husbandries.sheep.totalNumAnimals .. " 只"); posY = posY - lineDist;
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "生产力: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.sheep.productivity * 100) .. "%"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "洁净度: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.sheep.cleanlinessFactor * 100) .. "%"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "水 : ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.sheep:getFillLevel(FillUtil.FILLTYPE_WATER)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "牧草: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.sheep:getFillLevel(FillUtil.FILLTYPE_GRASS_WINDROW) + g_currentMission.husbandries.sheep:getFillLevel(FillUtil.FILLTYPE_DRYGRASS_WINDROW)) .. " 升"); posY = posY - lineDist;
			if g_currentMission.husbandries.sheep.currentPallet == nil then
				setTextAlignment(RenderText.ALIGN_LEFT);
				renderText(posX, posY, fontSize, "羊毛: ");
				setTextAlignment(RenderText.ALIGN_RIGHT);
				renderText(posX2, posY, fontSize, "n/a"); posY = posY - lineDist - paddingY;
			else
				setTextAlignment(RenderText.ALIGN_LEFT);
				renderText(posX, posY, fontSize, "羊毛: ");
				setTextAlignment(RenderText.ALIGN_RIGHT);
				renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.sheep.currentPallet.fillLevel) .. " 升"); posY = posY - lineDist - paddingY;
			end;
		end;

		--Pigs info
		if g_currentMission.husbandries.pig.totalNumAnimals > 0 then
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "猪 : ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, g_currentMission.husbandries.pig.totalNumAnimals .. " 只"); posY = posY - lineDist;
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "生产力: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig.productivity * 100) .. "%"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "洁净度: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig.cleanlinessFactor * 100) .. "%"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "水 : ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_WATER)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "秸秆: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_STRAW)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "玉米: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_MAIZE)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "麦子: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_WHEAT) + g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_BARLEY)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "油菜: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_RAPE) + g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_SUNFLOWER) + g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_SOYBEAN)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "土豆: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_POTATO) + g_currentMission.husbandries.pig:getFillLevel(FillUtil.FILLTYPE_SUGARBEET)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "液体肥: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig.liquidManureTrigger.fillLevel) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "粪肥: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.pig.manureFillLevel) .. " 升"); posY = posY - lineDist - paddingY;
		end;

		--Cows info
		if g_currentMission.husbandries.cow.totalNumAnimals > 0 then
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "牛: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, g_currentMission.husbandries.cow.totalNumAnimals .. " 只"); posY = posY - lineDist;
			setTextBold(false);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "生产力: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow.productivity * 100) .. "%"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "洁净度: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow.cleanlinessFactor * 100) .. "%"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "水: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow:getFillLevel(FillUtil.FILLTYPE_WATER)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "秸秆: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow:getFillLevel(FillUtil.FILLTYPE_STRAW)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "牧草: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow:getFillLevel(FillUtil.FILLTYPE_GRASS_WINDROW)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "青贮饲料: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow:getFillLevel(FillUtil.FILLTYPE_DRYGRASS_WINDROW) + g_currentMission.husbandries.cow:getFillLevel(FillUtil.FILLTYPE_SILAGE)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "混合饲料: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow:getFillLevel(FillUtil.FILLTYPE_POWERFOOD)) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "液体肥料: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow.liquidManureTrigger.fillLevel) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "粪肥: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow.manureFillLevel) .. " 升"); posY = posY - lineDist;
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderText(posX, posY, fontSize, "牛奶: ");
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(posX2, posY, fontSize, math.floor(g_currentMission.husbandries.cow.fillLevelMilk) .. " 升"); posY = posY - lineDist - paddingY;
		end;
		setTextAlignment(RenderText.ALIGN_LEFT); -- other mods compability

	end;
end;