
  /*---------------------------------------.
  |   .-.                   .  .---..   .  |
  |  (   )                 _|_ |     \ /   |
  |   `-..  .    ._.-.  .-. |  |---   /    |
  |  (   )\  \  / (.-' (.-' |  |     / \   |
  |   `-'  `' `'   `--' `--'`-''    '   '  |
  |              by CeeJay.dk              |
  '---------------------------------------*/
  /*---------------------------------------.
  | : Using ENBSeries by Boris Vorontsov : |
  '---------------------------------------*/

	/*-----------------------.
  | ::     Settings     :: |
  '-----------------------*/

#define USE_ENB_SETTINGS   1 //[0|1|2] 0 = use SweetFX config, 1 = use SFX config to enable effects, 2 = full ENB control (slower)

#include "SweetFX/SweetFX_settings.txt" //load SweetFX settings

#define PARAM_ENABLE(NAME, DESC, MIN, MAX, VAL) \
  int	NAME##Enabled \
  < \
    string UIName=##DESC; \
    string UIWidget="spinner"; \
    int UIMin=##MIN; \
    int UIMax=##MAX; \
  > = {##VAL};

#if (USE_ENB_SETTINGS >= 1)

  #if ((USE_ENB_SETTINGS + USE_ASCII) >= 2)
    #if (USE_ENB_SETTINGS == 1)
      PARAM_ENABLE(Ascii, "ASCII:: enabled", USE_ASCII, USE_ASCII, USE_ASCII)
    #else
      PARAM_ENABLE(Ascii, "ASCII:: enabled", 0, 1, 0)
      #define USE_ASCII             1
    #endif
  int	AsciiSpacing
  <
  	string UIName="ASCII:: spacing";
  	string UIWidget="spinner";
  	int UIMin=0;
  	int UIMax=9;
  > = {1};
  #define Ascii_spacing AsciiSpacing
  int	AsciiFont
  <
  	string UIName="ASCII:: font";
  	string UIWidget="spinner";
  	int UIMin=Ascii_font;
  	int UIMax=Ascii_font;
  > = {Ascii_font};
  //#define Ascii_font AsciiFont
  float3	AsciiFontColor
  <
  	string UIName="ASCII:: font color";
  	string UIWidget="color";
  > = {1.0, 1.0, 1.0};
  #define Ascii_font_color (AsciiFontColor * 255)
  float3	AsciiBackgroundColor
  <
  	string UIName="ASCII:: background color";
  	string UIWidget="color";
  > = {0.0, 0.0, 0.0};
  #define Ascii_background_color (AsciiBackgroundColor * 255)
  int	AsciiSwapColors
  <
  	string UIName="ASCII:: swap colors";
  	string UIWidget="spinner";
  	int UIMin=Ascii_swap_colors;
  	int UIMax=Ascii_swap_colors;
  > = {Ascii_swap_colors};
  //#define Ascii_swap_colors AsciiSwapColors
  int	AsciiInvertBrightness
  <
  	string UIName="ASCII:: invert brightness";
  	string UIWidget="spinner";
  	int UIMin=Ascii_invert_brightness;
  	int UIMax=Ascii_invert_brightness;
  > = {Ascii_invert_brightness};
  //#define Ascii_invert_brightness AsciiInvertBrightness
  int	AsciiFontColorMode
  <
  	string UIName="ASCII:: font color mode";
  	string UIWidget="spinner";
  	int UIMin=Ascii_font_color_mode;
  	int UIMax=Ascii_font_color_mode;
  > = {Ascii_font_color_mode};
  //#define Ascii_font_color_mode AsciiFontColorMode
  #endif

  #if ((USE_ENB_SETTINGS + USE_CARTOON) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Cartoon, "Cartoon:: enabled", USE_CARTOON, USE_CARTOON, USE_CARTOON)
  #else
    PARAM_ENABLE(Cartoon, "Cartoon:: enabled", 0, 1, 0)
    #define USE_CARTOON             1
  #endif
  float	CartoonPower_
  <
  	string UIName="Cartoon:: power";
  	string UIWidget="spinner";
  	float UIMin=0.1;
  	float UIMax=10.0;
  > = {8.0};
  #define CartoonPower CartoonPower_
  float	CartoonEdgeSlope_
  <
  	string UIName="Cartoon:: edge slope";
  	string UIWidget="spinner";
  	float UIMin=0.1;
  	float UIMax=8.0;
  > = {1.0};
  #define CartoonEdgeSlope CartoonEdgeSlope_
  #endif

  #if ((USE_ENB_SETTINGS + USE_EXPLOSION) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Explosion, "Explosion:: enabled", USE_EXPLOSION, USE_EXPLOSION, USE_EXPLOSION)
  #else
    PARAM_ENABLE(Explosion, "Explosion:: enabled", 0, 1, 0)
    #define USE_EXPLOSION             1
  #endif
  float	ExplosionRadius
  <
    string UIName="Explosion:: radius";
    string UIWidget="spinner";
    float UIMin=0.2;
    float UIMax=100.0;
  > = {2.0};
  #define Explosion_Radius ExplosionRadius
  #endif

  #if ((USE_ENB_SETTINGS + USE_CA) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(ChromaticAberration, "Chromatic aberration:: enabled", USE_CA, USE_CA, USE_CA)
  #else
    PARAM_ENABLE(ChromaticAberration, "Chromatic aberration:: enabled", 0, 1, 0)
    #define USE_CA             1
  #endif
  float	ChromaticShiftX
  <
  	string UIName="Chromatic aberration:: shift X";
  	string UIWidget="spinner";
    float UIMin=-100.0;
    float UIMax=100.0;
  > = {2.5};
  float	ChromaticShiftY
  <
  	string UIName="Chromatic aberration:: shift Y";
  	string UIWidget="spinner";
    float UIMin=-100.0;
    float UIMax=100.0;
  > = {-0.5};
  #define Chromatic_shift float2(ChromaticShiftX, ChromaticShiftY)
  float	ChromaticStrenght
  <
  	string UIName="Chromatic Aberration:: strenght";
  	string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=2.0;
  > = {0.3};
  #define Chromatic_strength ChromaticStrenght
  #endif

  #if ((USE_ENB_SETTINGS + USE_BLOOM) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Bloom, "Bloom:: enabled", USE_BLOOM, USE_BLOOM, USE_BLOOM)
  #else
    PARAM_ENABLE(Bloom, "Bloom:: enabled", 0, 1, 0)
    #define USE_BLOOM             1
  #endif
  float	BloomThreshold_
  <
    string UIName="Bloom:: threshold";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=50.0;
  > = {20.25};
  #define BloomThreshold BloomThreshold_
  float	BloomPower_
  <
    string UIName="Bloom:: power";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=8.0;
  > = {0.446};
  #define BloomPower BloomPower_
  float	BloomWidth_
  <
    string UIName="Bloom:: width";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.0142};
  #define BloomWidth BloomWidth_
  #endif

  #if ((USE_ENB_SETTINGS + USE_HDR) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(HDR, "HDR:: enabled", USE_HDR, USE_HDR, USE_HDR)
  #else
    PARAM_ENABLE(HDR, "HDR:: enabled", 0, 1, 0)
    #define USE_HDR             1
  #endif
  float	HDRPower_
  <
    string UIName="HDR:: power";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=8.0;
  > = {1.3};
  #define HDRPower HDRPower_
  float	HDRRadius
  <
    string UIName="HDR:: radius";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=8.0;
  > = {0.87};
  #define radius2 HDRRadius
  #endif

  #if ((USE_ENB_SETTINGS + USE_LUMASHARPEN) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(LumaSharpen, "Luma sharpen:: enabled", USE_LUMASHARPEN, USE_LUMASHARPEN, USE_LUMASHARPEN)
  #else
    PARAM_ENABLE(LumaSharpen, "Luma sharpen:: enabled", 0, 1, 0)
    #define USE_LUMASHARPEN             1
  #endif
  float	LumaSharpenStrength
  <
    string UIName="Luma sharpen:: strength";
    string UIWidget="spinner";
    float UIMin=0.1;
    float UIMax=3.0;
  > = {0.65};
  #define sharp_strength LumaSharpenStrength
  float	LumaSharpenClamp
  <
    string UIName="Luma sharpen:: clamp";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.035};
  #define sharp_clamp LumaSharpenClamp
  int	LumaSharpenPattern
  <
    string UIName="Luma sharpen:: pattern";
    string UIWidget="spinner";
    int UIMin=pattern;
    int UIMax=pattern;
  > = {pattern};
  //#define pattern LumaSharpenPattern
  float	LumaSharpenOffsetBias
  <
    string UIName="Luma sharpen:: offset bias";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=6.0;
  > = {1.0};
  #define offset_bias LumaSharpenOffsetBias
  int	LumaSharpenShowSharpen
  <
    string UIName="Luma sharpen:: show sharpen";
    string UIWidget="spinner";
    int UIMin=show_sharpen;
    int UIMax=show_sharpen;
  > = {show_sharpen};
  //#define show_sharpen LumaSharpenShowSharpen
  #endif

  #if ((USE_ENB_SETTINGS + USE_SHARED) >= 2)
    #define USE_SHARED            1
  #endif

  #if ((USE_ENB_SETTINGS + USE_NOSTALGIA) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Nostalgia, "Nostalgia:: enabled", USE_NOSTALGIA, USE_NOSTALGIA, USE_NOSTALGIA)
  #else
    PARAM_ENABLE(Nostalgia, "Nostalgia:: enabled", 0, 1, 0)
    #define USE_NOSTALGIA             1
  #endif
  #endif

  #if ((USE_ENB_SETTINGS + USE_LEVELS) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Levels, "Levels:: enabled", USE_LEVELS, USE_LEVELS, USE_LEVELS)
  #else
    PARAM_ENABLE(Levels, "Levels:: enabled", 0, 1, 0)
    #define USE_LEVELS             1
  #endif
  int	LevelsBlackPoint
  <
    string UIName="Levels:: black point";
    string UIWidget="spinner";
    int UIMin=Levels_black_point;
    int UIMax=Levels_black_point;
  > = {Levels_black_point};
  //#define Levels_black_point LevelsBlackPoint
  int	LevelsWhitePoint
  <
    string UIName="Levels:: white point";
    string UIWidget="spinner";
    int UIMin=Levels_white_point;
    int UIMax=Levels_white_point;
  > = {Levels_white_point};
  //#define Levels_white_point LevelsWhitePoint
  int	LevelsHighlightClipping
  <
    string UIName="Levels:: highlight clipping";
    string UIWidget="spinner";
    int UIMin=Levels_highlight_clipping;
    int UIMax=Levels_highlight_clipping;
  > = {Levels_highlight_clipping};
  //#define Levels_highlight_clipping LevelsHighlightClipping
  #endif

  #if ((USE_ENB_SETTINGS + USE_TECHNICOLOR) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Technicolor, "Technicolor:: enabled", USE_TECHNICOLOR, USE_TECHNICOLOR, USE_TECHNICOLOR)
  #else
    PARAM_ENABLE(Technicolor, "Technicolor:: enabled", 0, 1, 0)
    #define USE_TECHNICOLOR             1
  #endif
  float	TechnicolorAmount
  <
    string UIName="Technicolor:: amount";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.4};
  #define TechniAmount TechnicolorAmount
  float	TechnicolorPower
  <
    string UIName="Technicolor:: power";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=8.0;
  > = {4.0};
  #define TechniPower TechnicolorPower
  float	TechnicolorRedNegativeAmount
  <
    string UIName="Technicolor:: red negative amount";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.88};
  #define redNegativeAmount TechnicolorRedNegativeAmount
  float	TechnicolorGreenNegativeAmount
  <
    string UIName="Technicolor:: green negative amount";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.88};
  #define greenNegativeAmount TechnicolorGreenNegativeAmount
  float	TechnicolorBlueNegativeAmount
  <
    string UIName="Technicolor:: blue negative amount";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.88};
  #define blueNegativeAmount TechnicolorBlueNegativeAmount
  #endif

  #if ((USE_ENB_SETTINGS + USE_TECHNICOLOR2) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Technicolor2, "Technicolor2:: enabled", USE_TECHNICOLOR2, USE_TECHNICOLOR2, USE_TECHNICOLOR2)
  #else
    PARAM_ENABLE(Technicolor2, "Technicolor2:: enabled", 0, 1, 0)
    #define USE_TECHNICOLOR2             1
  #endif
  float	Technicolor2RedStrength
  <
    string UIName="Technicolor2:: red strength";
    string UIWidget="spinner";
    float UIMin=0.05;
    float UIMax=1.0;
  > = {0.2};
  #define Technicolor2_Red_Strength Technicolor2RedStrength
  float	Technicolor2GreenStrength
  <
    string UIName="Technicolor2:: green strength";
    string UIWidget="spinner";
    float UIMin=0.05;
    float UIMax=1.0;
  > = {0.2};
  #define Technicolor2_Green_Strength Technicolor2GreenStrength
  float	Technicolor2BlueStrength
  <
    string UIName="Technicolor2:: blue strength";
    string UIWidget="spinner";
    float UIMin=0.05;
    float UIMax=1.0;
  > = {0.2};
  #define Technicolor2_Blue_Strength Technicolor2BlueStrength
  float	Technicolor2Brightness
  <
    string UIName="Technicolor2:: brightness";
    string UIWidget="spinner";
    float UIMin=0.5;
    float UIMax=1.5;
  > = {1.0};
  #define Technicolor2_Brightness Technicolor2Brightness
  float	Technicolor2Strength
  <
    string UIName="Technicolor2:: strength";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {1.0};
  #define Technicolor2_Strength Technicolor2Strength
  float	Technicolor2Saturation
  <
    string UIName="Technicolor2:: saturation";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.5;
  > = {0.7};
  #define Technicolor2_Saturation Technicolor2Saturation
  #endif

  #if ((USE_ENB_SETTINGS + USE_DPX) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(CineonDPX, "Cineon DPX:: enabled", USE_DPX, USE_DPX, USE_DPX)
  #else
    PARAM_ENABLE(CineonDPX, "Cineon DPX:: enabled", 0, 1, 0)
    #define USE_DPX             1
  #endif
  float	CineonDPXRed
  <
    string UIName="Cineon DPX:: red";
    string UIWidget="spinner";
    float UIMin=1.0;
    float UIMax=15.0;
  > = {8.0};
  #define Red CineonDPXRed
  float	CineonDPXGreen
  <
    string UIName="Cineon DPX:: green";
    string UIWidget="spinner";
    float UIMin=1.0;
    float UIMax=15.0;
  > = {8.0};
  #define Green CineonDPXGreen
  float	CineonDPXBlue
  <
    string UIName="Cineon DPX:: blue";
    string UIWidget="spinner";
    float UIMin=1.0;
    float UIMax=15.0;
  > = {8.0};
  #define Blue CineonDPXBlue
  float	CineonDPXColorGamma
  <
    string UIName="Cineon DPX:: color gamma";
    string UIWidget="spinner";
    float UIMin=0.1;
    float UIMax=2.5;
  > = {2.5};
  #define ColorGamma CineonDPXColorGamma
  float	CineonDPXSaturation
  <
    string UIName="Cineon DPX:: saturation";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=8.0;
  > = {3.0};
  #define DPXSaturation CineonDPXSaturation
  float	CineonDPXRedC
  <
    string UIName="Cineon DPX:: redC";
    string UIWidget="spinner";
    float UIMin=0.2;
    float UIMax=0.6;
  > = {0.36};
  #define RedC CineonDPXRedC
  float	CineonDPXGreenC
  <
    string UIName="Cineon DPX:: greenC";
    string UIWidget="spinner";
    float UIMin=0.2;
    float UIMax=0.6;
  > = {0.36};
  #define GreenC CineonDPXGreenC
  float	CineonDPXBlueC
  <
    string UIName="Cineon DPX:: blueC";
    string UIWidget="spinner";
    float UIMin=0.2;
    float UIMax=0.6;
  > = {0.34};
  #define BlueC CineonDPXBlueC
  float	CineonDPXBlend
  <
    string UIName="Cineon DPX:: blend";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.25};
  #define Blend CineonDPXBlend
  #endif

  #if ((USE_ENB_SETTINGS + USE_MONOCHROME) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Monochrome, "Monochrome:: enabled", USE_MONOCHROME, USE_MONOCHROME, USE_MONOCHROME)
  #else
    PARAM_ENABLE(Monochrome, "Monochrome:: enabled", 0, 1, 0)
    #define USE_MONOCHROME             1
  #endif
  float3	MonochromeConversionValues
  <
    string UIName="Monochrome:: conversion values";
    string UIWidget="color";
  > = {0.21, 0.72, 0.07};
  #define Monochrome_conversion_values MonochromeConversionValues
  float	MonochromeColorSaturation
  <
    string UIName="Monochrome:: color saturation";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=2.0;
  > = {0.0};
  #define Monochrome_color_saturation MonochromeColorSaturation
  #endif

  #if ((USE_ENB_SETTINGS + USE_COLORMATRIX) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(ColorMatrix, "Color matrix:: enabled", USE_COLORMATRIX, USE_COLORMATRIX, USE_COLORMATRIX)
  #else
    PARAM_ENABLE(ColorMatrix, "Color matrix:: enabled", 0, 1, 0)
    #define USE_COLORMATRIX             1
  #endif
  float3	ColorMatrixRed
  <
    string UIName="Color matrix:: red";
    string UIWidget="color";
  > = {0.817, 0.183, 0.000};
  #define ColorMatrix_Red ColorMatrixRed
  float3	ColorMatrixGreen
  <
    string UIName="Color matrix:: green";
    string UIWidget="color";
  > = {0.333, 0.667, 0.000};
  #define ColorMatrix_Green ColorMatrixGreen
  float3	ColorMatrixBlue
  <
    string UIName="Color matrix:: blue";
    string UIWidget="color";
  > = {0.000, 0.125, 0.875};
  #define ColorMatrix_Blue ColorMatrixBlue
  #endif

  #if ((USE_ENB_SETTINGS + USE_LIFTGAMMAGAIN) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(LiftGammaGain, "Lift gamma gain:: enabled", USE_LIFTGAMMAGAIN, USE_LIFTGAMMAGAIN, USE_LIFTGAMMAGAIN)
  #else
    PARAM_ENABLE(LiftGammaGain, "Lift gamma gain:: enabled", 0, 1, 0)
    #define USE_LIFTGAMMAGAIN             1
  #endif
  float3	LiftGammaGainLift
  <
    string UIName="Lift gamma gain:: lift";
    string UIWidget="color";
  > = {0.5, 0.5, 0.5};
  #define RGB_Lift (LiftGammaGainLift * 2)
  float3	LiftGammaGainGamma
  <
    string UIName="Lift gamma gain:: gamma";
    string UIWidget="color";
  > = {0.5, 0.5, 0.5};
  #define RGB_Gamma (LiftGammaGainGamma * 2)
  float3	LiftGammaGainGain
  <
    string UIName="Lift gamma gain:: gain";
    string UIWidget="color";
  > = {0.5, 0.5, 0.5};
  #define RGB_Gain (LiftGammaGainGain * 2)
  #endif

  #if ((USE_ENB_SETTINGS + USE_TONEMAP) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Tonemap, "Tonemap:: enabled", USE_TONEMAP, USE_TONEMAP, USE_TONEMAP)
  #else
    PARAM_ENABLE(Tonemap, "Tonemap:: enabled", 0, 1, 0)
    #define USE_TONEMAP             1
  #endif
  float	TonemapGamma
  <
    string UIName="Tonemap:: gamma";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=2.0;
  > = {1.0};
  #define Gamma TonemapGamma
  float	TonemapExposure
  <
    string UIName="Tonemap:: exposure";
    string UIWidget="spinner";
    float UIMin=-1.0;
    float UIMax=1.0;
  > = {0.0};
  #define Exposure TonemapExposure
  float	TonemapSaturation
  <
    string UIName="Tonemap:: saturation";
    string UIWidget="spinner";
    float UIMin=-1.0;
    float UIMax=1.0;
  > = {0.0};
  #define Saturation TonemapSaturation
  float	TonemapBleach
  <
    string UIName="Tonemap:: bleach";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.0};
  #define Bleach TonemapBleach
  float	TonemapDefog
  <
    string UIName="Tonemap:: defog";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.0};
  #define Defog TonemapDefog
  float3	TonemapFogColor
  <
    string UIName="Tonemap:: fog color";
    string UIWidget="color";
  > = {0.0, 0.0, 1.0};
  #define FogColor (TonemapFogColor * 2.55)
  #endif

  #undef Vibrance
  #if ((USE_ENB_SETTINGS + USE_VIBRANCE) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Vibrance, "Vibrance:: enabled", USE_VIBRANCE, USE_VIBRANCE, USE_VIBRANCE)
  #else
    PARAM_ENABLE(Vibrance, "Vibrance:: enabled", 0, 1, 0)
    #define USE_VIBRANCE             1
  #endif
  float	VibranceValue
  <
    string UIName="Vibrance:: value";
    string UIWidget="spinner";
    float UIMin=-1.0;
    float UIMax=1.0;
  > = {0.0};
  #define Vibrance VibranceValue
  float3	VibranceBalance
  <
    string UIName="Vibrance:: balance";
    string UIWidget="color";
  > = {0.5, 0.5, 0.5};
  #define Vibrance_RGB_balance ((VibranceBalance - float3(0.5,0.5,0.5)) * 20)
  #endif

  #if ((USE_ENB_SETTINGS + USE_CURVES) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Curves, "Curves:: enabled", USE_CURVES, USE_CURVES, USE_CURVES)
  #else
    PARAM_ENABLE(Curves, "Curves:: enabled", 0, 1, 0)
    #define USE_CURVES             1
  #endif
  int	CurvesMode
  <
    string UIName="Curves:: mode";
    string UIWidget="spinner";
    int UIMin=Curves_mode;
    int UIMax=Curves_mode;
  > = {Curves_mode};
  //#define Curves_mode CurvesMode
  float	CurvesContrast
  <
    string UIName="Curves:: contrast";
    string UIWidget="spinner";
    float UIMin=-1.0;
    float UIMax=1.0;
  > = {0.6};
  #define Curves_contrast CurvesContrast
  int	CurvesFormula
  <
    string UIName="Curves:: formula";
    string UIWidget="spinner";
    int UIMin=Curves_formula;
    int UIMax=Curves_formula;
  > = {Curves_formula};
  //#define Curves_formula CurvesFormula
  #endif

  #if ((USE_ENB_SETTINGS + USE_SEPIA) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Sepia, "Sepia:: enabled", USE_SEPIA, USE_SEPIA, USE_SEPIA)
  #else
    PARAM_ENABLE(Sepia, "Sepia:: enabled", 0, 1, 0)
    #define USE_SEPIA             1
  #endif
  float3	SepiaColorTone
  <
    string UIName="Sepia:: color tone";
    string UIWidget="color";
  > = {0.55, 0.43, 0.35};
  #define ColorTone (SepiaColorTone * 2.55)
  float	SepiaGreyPower
  <
    string UIName="Sepia:: grey power";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.11};
  #define GreyPower SepiaGreyPower
  float	SepiaPower_
  <
    string UIName="Sepia:: power";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.58};
  #define SepiaPower SepiaPower_
  #endif

  #if ((USE_ENB_SETTINGS + USE_VIGNETTE) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Vignette, "Vignette:: enabled", USE_VIGNETTE, USE_VIGNETTE, USE_VIGNETTE)
  #else
    PARAM_ENABLE(Vignette, "Vignette:: enabled", 0, 1, 0)
    #define USE_VIGNETTE             1
  #endif
  int	VignetteType_
  <
    string UIName="Vignette:: type";
    string UIWidget="spinner";
    int UIMin=VignetteType;
    int UIMax=VignetteType;
  > = {VignetteType};
  //#define VignetteType VignetteType_
  float	VignetteRatio_
  <
    string UIName="Vignette:: ratio";
    string UIWidget="spinner";
    float UIMin=0.15;
    float UIMax=6.0;
  > = {1.00};
  #define VignetteRatio VignetteRatio_
  float	VignetteRadius_
  <
    string UIName="Vignette:: radius";
    string UIWidget="spinner";
    float UIMin=-1.0;
    float UIMax=3.0;
  > = {3.00};
  #define VignetteRadius VignetteRadius_
  float	VignetteAmount_
  <
    string UIName="Vignette:: amount";
    string UIWidget="spinner";
    float UIMin=-2.0;
    float UIMax=1.0;
  > = {-0.10};
  #define VignetteAmount VignetteAmount_
  int	VignetteSlope_
  <
    string UIName="Vignette:: slope";
    string UIWidget="spinner";
    int UIMin=2.0;
    int UIMax=16;
  > = {2};
  #define VignetteSlope VignetteSlope_
  float	VignetteCenterX
  <
    string UIName="Vignette:: center X";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.5};
  float	VignetteCenterY
  <
    string UIName="Vignette:: center Y";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.5};
  #define VignetteCenter float2(VignetteCenterX, VignetteCenterY)
  #endif

  #if ((USE_ENB_SETTINGS + USE_FILMGRAIN) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(FilmGrain, "Film grain:: enabled", USE_FILMGRAIN, USE_FILMGRAIN, USE_FILMGRAIN)
  #else
    PARAM_ENABLE(FilmGrain, "Film grain:: enabled", 0, 1, 0)
    #define USE_FILMGRAIN             1
  #endif
  float	FilmGrainIntensity
  <
    string UIName="Film grain:: intensity";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.5};
  #define FilmGrain_intensity FilmGrainIntensity
  float	FilmGrainVariance
  <
    string UIName="Film grain:: variance";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.4};
  #define FilmGrain_variance FilmGrainVariance
  int	FilmGrainSNR
  <
    string UIName="Film grain:: SNR";
    string UIWidget="spinner";
    int UIMin=FilmGrain_SNR;
    int UIMax=FilmGrain_SNR;
  > = {FilmGrain_SNR};
  //#define FilmGrain_SNR FilmGrainSNR
  float	FilmGrainMean
  <
    string UIName="Film grain:: mean";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=1.0;
  > = {0.5};
  #define FilmGrain_mean FilmGrainMean
  #endif

  #if ((USE_ENB_SETTINGS + USE_DITHER) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Dither, "Dither:: enabled", USE_DITHER, USE_DITHER, USE_DITHER)
  #else
    PARAM_ENABLE(Dither, "Dither:: enabled", 0, 1, 0)
    #define USE_DITHER             1
  #endif
  int	DitherMethod
  <
    string UIName="Dither:: method";
    string UIWidget="spinner";
    int UIMin=dither_method;
    int UIMax=dither_method;
  > = {dither_method};
  //#define dither_method DitherMethod
  #endif

  #if ((USE_ENB_SETTINGS + USE_BORDER) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(Border, "Border:: enabled", USE_BORDER, USE_BORDER, USE_BORDER)
  #else
    PARAM_ENABLE(Border, "Border:: enabled", 0, 1, 0)
    #define USE_BORDER             1
  #endif
  float	BorderWidthX
  <
    string UIName="Border:: width X";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=2048.0;
  > = {0.0};
  float	BorderWidthY
  <
    string UIName="Border:: width Y";
    string UIWidget="spinner";
    float UIMin=0.0;
    float UIMax=2048.0;
  > = {100.0};
  #define border_width float2(BorderWidthX, BorderWidthY)
  float	BorderRatio
  <
    string UIName="Border:: ratio";
    string UIWidget="spinner";
    float UIMin=0.1;
    float UIMax=10.0;
  > = {2.35};
  #define border_ratio BorderRatio
  float3	BorderColor
  <
    string UIName="Border:: color";
    string UIWidget="color";
  > = {0.0, 0.0, 0.0};
  #define border_color (BorderColor * 255)
  #endif

  #if ((USE_ENB_SETTINGS + USE_SPLITSCREEN) >= 2)
  #if (USE_ENB_SETTINGS == 1)
    PARAM_ENABLE(SplitScreen, "Split screen:: enabled", USE_SPLITSCREEN, USE_SPLITSCREEN, USE_SPLITSCREEN)
  #else
    PARAM_ENABLE(SplitScreen, "Split screen:: enabled", 0, 1, 0)
    #define USE_SPLITSCREEN             1
  #endif
  int	SplitScreenMode
  <
    string UIName="Split screen:: enabled";
    string UIWidget="spinner";
    int UIMin=splitscreen_mode;
    int UIMax=splitscreen_mode;
  > = {splitscreen_mode};
  //#define splitscreen_mode SplitScreenMode
  #endif
#endif

/*-----------------------.
| ::      Globals     :: |
'-----------------------*/

//#include "SweetFX/Shaders/Globals.h" //define global contants and uniforms
#define px ScreenSize.y
#define py ScreenSize.y*ScreenSize.z
#define pixel float2(ScreenSize.y,ScreenSize.y*ScreenSize.z)
#define screen_size float2(ScreenSize.x,ScreenSize.x*ScreenSize.w)
#define timer Timer.x*16777216

/*-----------------------.
| ::     Effects      :: |
'-----------------------*/

#define colorGammaSampler Sampler0
#define tex2D TextureColor.Sample

#define s0 colorGammaSampler
#define s1 colorLinearSampler
#define myTex2D tex2D

#include "SweetFX/Shaders/Main.h"

float4 SharedPass_(float2 tex, float4 FinalColor)
{
    // Palette
  #if (USE_NOSTALGIA == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (NostalgiaEnabled)
  #endif
    FinalColor = Nostalgia(FinalColor);
  #endif

  // Levels
  #if (USE_LEVELS == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (LevelsEnabled)
  #endif
    FinalColor = LevelsPass(FinalColor);
  #endif

  // Technicolor
  #if (USE_TECHNICOLOR == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (TechnicolorEnabled)
  #endif
    FinalColor = TechnicolorPass(FinalColor);
  #endif

  // Technicolor2
  #if (USE_TECHNICOLOR2 == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (Technicolor2Enabled)
  #endif
    FinalColor.rgb = Technicolor2(FinalColor.rgb);
  #endif

  // DPX
  #if (USE_DPX == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (CineonDPXEnabled)
  #endif
    FinalColor = DPXPass(FinalColor);
  #endif

  // Monochrome
  #if (USE_MONOCHROME == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (MonochromeEnabled)
  #endif
    FinalColor = MonochromePass(FinalColor);
  #endif

  // ColorMatrix
  #if (USE_COLORMATRIX == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (ColorMatrixEnabled)
  #endif
    FinalColor = ColorMatrixPass(FinalColor);
  #endif

  // Lift Gamma Gain
  #if (USE_LIFTGAMMAGAIN == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (LiftGammaGainEnabled)
  #endif
    FinalColor = LiftGammaGainPass(FinalColor);
  #endif

  // Tonemap
  #if (USE_TONEMAP == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (TonemapEnabled)
  #endif
    FinalColor = TonemapPass(FinalColor);
  #endif

  // Vibrance
  #if (USE_VIBRANCE == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (VibranceEnabled)
  #endif
    FinalColor = VibrancePass(FinalColor);
  #endif

  // Curves
  #if (USE_CURVES == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (CurvesEnabled)
  #endif
    FinalColor = CurvesPass(FinalColor);
  #endif

  // Sepia
  #if (USE_SEPIA == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (SepiaEnabled)
  #endif
    FinalColor = SepiaPass(FinalColor);
  #endif

  // Vignette
  #if (USE_VIGNETTE == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (VignetteEnabled)
  #endif
    FinalColor = VignettePass(FinalColor,tex);
  #endif

  // FilmGrain
  #if (USE_FILMGRAIN == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (FilmGrainEnabled)
  #endif
    FinalColor = FilmGrainPass(FinalColor,tex);
  #endif

  // Dither (should go near the end as it only dithers what went before it)
  #if (USE_DITHER == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (DitherEnabled)
  #endif
    FinalColor = DitherPass(FinalColor,tex);
  #endif

  // Border
  #if (USE_BORDER == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (BorderEnabled)
  #endif
    FinalColor = BorderPass(FinalColor,tex);
  #endif

  // Splitscreen
  #if (USE_SPLITSCREEN == 1)
  #if (USE_ENB_SETTINGS == 2)
    if (SplitScreenEnabled)
  #endif
    FinalColor = SplitscreenPass(FinalColor,tex);
  #endif

  // Return FinalColor
  return FinalColor;
}

#if (USE_ENB_SETTINGS == 2)
  int GetPiggyback()
  {
    if(LumaSharpenEnabled) return 1;
    else if(HDREnabled) return 2;
    else if(BloomEnabled) return 3;
    else if(ChromaticAberrationEnabled) return 4;
    else if(ExplosionEnabled) return 5;
    else if(CartoonEnabled) return 6;
    else if(AsciiEnabled) return 7;
    else return 0;
  }

  #define WRAP(NAME, CALL, PIGGY) \
    float3 NAME##Wrap_(float4 position : SV_Position, float2 texcoord : TEXCOORD0) : SV_Target \
    { \
      float3 res; \
      if(NAME##Enabled){ \
        res = CALL; \
        if(GetPiggyback() == PIGGY) res = SharedPass_(texcoord, float4(res.rgbb)).rgb; \
      } \
      else res = TextureColor.Sample(Sampler0, texcoord); \
      return res; \
    } \

  #define color TextureColor.Sample(Sampler0, texcoord)
  WRAP(Ascii, AsciiPass(texcoord), 7);
  WRAP(Cartoon, CartoonPass(color,texcoord), 6);
  WRAP(LumaSharpen, LumaSharpenPass(texcoord), 1);
  WRAP(Explosion, ExplosionPass(color,texcoord), 5);
  WRAP(Bloom, BloomPass(color,texcoord), 3);
  WRAP(HDR, HDRPass(color,texcoord), 2);
  WRAP(ChromaticAberration, ChromaticAberrationPass(color,texcoord), 4);
  #undef color

  void SharedWrap_(in float4 position : SV_Position, in float2 texcoord : TEXCOORD0, out float3 color : SV_Target)
  {
  	color = TextureColor.Sample(Sampler0, texcoord).rgb;

    if(GetPiggyback() == 0) color = SharedPass_(texcoord, color.rgbb).rgb;
  }
#endif

/*-----------------------.
| ::    Techniques    :: |
'-----------------------*/

#define TECHNIQUE_(FUNC) \
  technique11 SweetFX <string UIName="SweetFX";> { \
    pass { \
      SetVertexShader(CompileShader(vs_5_0, VS_PostProcess())); \
      SetPixelShader(CompileShader(ps_5_0, ##FUNC())); \
    } \
  } \

#define TECHNIQUE(FUNC, INDEX) \
  technique11 SweetFX##INDEX { \
    pass { \
      SetVertexShader(CompileShader(vs_5_0, VS_PostProcess())); \
      SetPixelShader(CompileShader(ps_5_0, ##FUNC())); \
    } \
  } \

#if (USE_ENB_SETTINGS == 2)
  TECHNIQUE_(AsciiWrap_)
  TECHNIQUE(CartoonWrap_, 1)
  TECHNIQUE(LumaSharpenWrap_, 2)
  TECHNIQUE(ExplosionWrap_, 3)
  TECHNIQUE(BloomWrap_, 4)
  TECHNIQUE(HDRWrap_, 5)
  TECHNIQUE(ChromaticAberrationWrap_, 6)
  TECHNIQUE(SharedWrap_, 7)
#else
  #define SUM_ASCII USE_ASCII
  #define SUM_CARTOON (USE_ASCII + USE_CARTOON)
  #define SUM_LUMASHARPEN (USE_ASCII + USE_CARTOON + USE_LUMASHARPEN)
  #define SUM_EXPLOSION (USE_ASCII + USE_CARTOON + USE_LUMASHARPEN + USE_EXPLOSION)
  #define SUM_BLOOM (USE_ASCII + USE_CARTOON + USE_LUMASHARPEN + USE_EXPLOSION + USE_BLOOM)
  #define SUM_HDR (USE_ASCII + USE_CARTOON + USE_LUMASHARPEN + USE_EXPLOSION + USE_BLOOM + USE_HDR)
  #define SUM_CA (USE_ASCII + USE_CARTOON + USE_LUMASHARPEN + USE_EXPLOSION + USE_BLOOM + USE_HDR + USE_CA)
  #define SUM_SHARED (USE_ASCII + USE_CARTOON + USE_LUMASHARPEN + USE_EXPLOSION + USE_BLOOM + USE_HDR + USE_CA + USE_SHARED + Shared_Piggyback_No)

  #if (SUM_ASCII == 1)
    TECHNIQUE_(AsciiWrap)
  #elif (SUM_CARTOON == 1)
    TECHNIQUE_(CartoonWrap)
  #elif (SUM_LUMASHARPEN == 1)
    TECHNIQUE_(LumaSharpenWrap)
  #elif (SUM_EXPLOSION == 1)
    TECHNIQUE_(ExplosionWrap)
  #elif (SUM_BLOOM == 1)
    TECHNIQUE_(BloomWrap)
  #elif (SUM_HDR == 1)
    TECHNIQUE_(HDRWrap)
  #elif (SUM_CA == 1)
    TECHNIQUE_(ChromaticAberrationWrap)
  #elif (SUM_SHARED == 2)
    TECHNIQUE_(SharedWrap)
  #endif

  #if (SUM_CARTOON == 2)
    TECHNIQUE(CartoonWrap, 1)
  #elif (SUM_LUMASHARPEN == 2)
    TECHNIQUE(LumaSharpenWrap, 1)
  #elif (SUM_EXPLOSION == 2)
    TECHNIQUE(ExplosionWrap, 1)
  #elif (SUM_BLOOM == 2)
    TECHNIQUE(BloomWrap, 1)
  #elif (SUM_HDR == 2)
    TECHNIQUE(HDRWrap, 1)
  #elif (SUM_CA == 2)
    TECHNIQUE(ChromaticAberrationWrap, 1)
  #elif (SUM_SHARED == 3)
    TECHNIQUE(SharedWrap, 1)
  #endif

  #if (SUM_LUMASHARPEN == 3)
    TECHNIQUE(LumaSharpenWrap, 2)
  #elif (SUM_EXPLOSION == 3)
    TECHNIQUE(ExplosionWrap, 2)
  #elif (SUM_BLOOM == 3)
    TECHNIQUE(BloomWrap, 2)
  #elif (SUM_HDR == 3)
    TECHNIQUE(HDRWrap, 2)
  #elif (SUM_CA == 3)
    TECHNIQUE(ChromaticAberrationWrap, 2)
  #elif (SUM_SHARED == 4)
    TECHNIQUE(SharedWrap, 2)
  #endif

  #if (SUM_EXPLOSION == 4)
    TECHNIQUE(ExplosionWrap, 3)
  #elif (SUM_BLOOM == 4)
    TECHNIQUE(BloomWrap, 3)
  #elif (SUM_HDR == 4)
    TECHNIQUE(HDRWrap, 3)
  #elif (SUM_CA == 4)
    TECHNIQUE(ChromaticAberrationWrap, 3)
  #elif (SUM_SHARED == 5)
    TECHNIQUE(SharedWrap, 3)
  #endif

  #if (SUM_BLOOM == 5)
    TECHNIQUE(BloomWrap, 4)
  #elif (SUM_HDR == 5)
    TECHNIQUE(HDRWrap, 4)
  #elif (SUM_CA == 5)
    TECHNIQUE(ChromaticAberrationWrap, 4)
  #elif (SUM_SHARED == 6)
    TECHNIQUE(SharedWrap, 4)
  #endif

  #if (SUM_HDR == 6)
    TECHNIQUE(HDRWrap, 5)
  #elif (SUM_CA == 6)
    TECHNIQUE(ChromaticAberrationWrap, 5)
  #elif (SUM_SHARED == 7)
    TECHNIQUE(SharedWrap, 5)
  #endif

  #if (SUM_CA == 7)
    TECHNIQUE(ChromaticAberrationWrap, 6)
  #elif (SUM_SHARED == 8)
    TECHNIQUE(SharedWrap, 6)
  #endif

  #if (SUM_SHARED == 9)
    TECHNIQUE(SharedWrap, 7)
  #endif
#endif

#undef tex2D
