<?php

	/*******************************************************************\
	|																	|
	|	房哨（多中介管理运营平台系统）									|
	|																	|
	|	© 2018-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	namespace Erpadmin\Controller;
	use Think\Controller;
	class AdController extends ErpadminbaseController {

		public function adPosition() {
			if (I('is_ajax')) {
				$field = I('field');//排序字段名
				$order = I('order');//排序方式 asc desc
				$limit = I('limit',30,'int');//每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$where = " where a.status = 1";
				$keyword = I('keyword');
				if ($keyword) {
					$where .= " and a.adp_title like '%{$keyword}%'";
				}
				$Model = new \Think\Model;
				$count_sql = "SELECT COUNT(*) FROM __AD_POSITION__ a JOIN __ADMIN_USER__ b ON a.adduid = b.id  {$where}";
				$adp_count_arr = $Model->query($count_sql);
				$adp_count = $adp_count_arr[0]['COUNT(*)'];
				$Page = new \Think\Page($adp_count,$limit);
				$select_sql = "SELECT a.*,b.nickname FROM __AD_POSITION__ a JOIN __ADMIN_USER__ b ON a.adduid = b.id {$where} limit ".$Page->firstRow.",".$Page->listRows;
				$adp_select = $Model->query($select_sql);
				foreach ($adp_select as $key => $value) {
					$adp_select[$key]['addtime_d'] = $value['addtime']? date('Y-m-d H:i',$value['addtime']):'';
				}
				$return = array(
					'code'=>0,
					'msg'=>'',
					'count'=>$adp_count,
					'data'=>$adp_select
				);
				$this->ajaxReturn($return);
			} else {
				$this->display('adPosition');
			}
		}

		public function addAdPosition() {
			if (IS_POST) {
				$add_data['adp_title'] = I('post.title');
				$add_data['adp_sign'] = I('post.sign');
				$add_data['position'] = I('post.position');
				$add_data['adduid'] = $this->userinfo['id'];
				$add_data['addtime'] = time();
				$add_return = M('ad_position')->add($add_data);
				if (!$add_return) {
					$this->error('添加失败!');
				} else {
					$this->success('添加成功!');
				}
			} else {
				$this->display('addAdPosition');
			}
		}

		public function editAdPosition() {
			if (IS_POST) {
				$id = I('post.id',0,'int');
				$edit_data['adp_title'] = I('post.title');
				$edit_data['adp_sign'] = I('post.sign');
				$edit_data['position'] = I('post.position');
				$edit_return = M('ad_position')->where(array('id'=>$id))->save($edit_data);
				if (!$edit_return) {
					$this->error('修改失败!');
				} else {
					$this->success('修改成功!');
				}
			} else {
				$id = I('get.id',0,'int');
				$find_return = M('ad_position')->where(array('id'=>$id))->find();
				$this->assign('data',$find_return);
				$this->display('editAdPosition');
			}
		}

		public function delAdPosition() {
			if (IS_POST) {
				$id = I('post.id',0,'int');
				$set_return = M('ad_position')->where(array('id'=>$id))->setField('status',0);
				if (!$set_return) {
					$this->error('删除失败!');
				} else {
					$this->success('删除成功!');
				}
			}
		}

		public function index() {
			if (I('is_ajax')) {
				$field = I('field');//排序字段名
				$order = I('order');//排序方式 asc desc
				$limit = I('limit',30,'int');//每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$where = " where a.status = 1";
				$keyword = I('keyword');
				if ($keyword) {
					$where .= " and a.ad_title like '%{$keyword}%'";
				}
				$Model = new \Think\Model;
				$count_sql = "SELECT COUNT(*) FROM __AD__ a JOIN __ADMIN_USER__ b ON a.adduid = b.id {$where}";
				$ad_count_arr = $Model->query($count_sql);
				$ad_count = $ad_count_arr[0]['COUNT(*)'];
				$Page = new \Think\Page($ad_count,$limit);
				$select_sql = "SELECT a.*,b.nickname FROM __AD__ a JOIN __ADMIN_USER__ b ON a.adduid = b.id {$where} limit ".$Page->firstRow.",".$Page->listRows;
				$ad_select = $Model->query($select_sql);
				foreach ($ad_select as $key => $value) {
					$ad_select[$key]['addtime_d'] = $value['addtime']? date('Y-m-d H:i',$value['addtime']):'';
					$ad_select[$key]['starttime_d'] = $value['starttime']? date('Y-m-d H:i',$value['starttime']):'';
					$ad_select[$key]['endtime_d'] = $value['endtime']? date('Y-m-d H:i',$value['endtime']):'';
				}
				$return = array(
					'code'=>0,
					'msg'=>'',
					'count'=>$ad_count,
					'data'=>$ad_select
				);
				$this->ajaxReturn($return);
			} else {
				$this->display();
			}
		}

		public function addAd() {
			if (IS_POST) {
				$date = explode(' - ',I('post.date'));
				$start_time = strtotime($date[0]);
				$end_time = strtotime($date[1]);
				$add_data['ad_title'] = I('post.title');
				$add_data['starttime'] = $start_time;
				$add_data['endtime'] = $end_time;
				$add_data['adduid'] = $this->userinfo['id'];
				$add_data['addtime'] = time();
				$add_return = M('ad')->add($add_data);
				if (!$add_return) {
					$this->error('添加失败!');
				} else {
					$this->success('添加成功!');
				}
			} else {
				$this->display('addAd');
			}
		}

		public function upload() {
			if (IS_POST) {
				$config=array(
					'maxSize' => 3292200, // 上传文件最大为50M
					'rootPath' => './', // 文件上传保存的根路径
					'savePath' => './Upload/erpadmin/', // 文件上传的保存路径（相对于根路径）
					'saveName' => array('uniqid',''), // 上传文件的保存规则，支持数组和字符串方式定义
					'autoSub' => true, // 自动使用子目录保存上传文件 默认为true
					'exts' => array('jpg', 'gif', 'png', 'jpeg') //isset($ext_arr[$format])?$ext_arr[$format]:'',
				);
				// 实例化上传
				$upload=new \Think\Upload($config);
				// 调用上传方法
				$info = $upload->upload();
				if(!$info){
					// 返回错误信息
					$error = $upload->getError();
					$this->error($error);
				} else {
					$id = I('id',0,'int');
					$file = $info['file'];
					$find_return = M('ad')->where(array('id'=>$id))->find();
					$img_path = $find_return['img_path'];
					$img_path_new = trim($file['savepath'].$file['savename'],'.');
					$edit_return = M('ad')->where(array('id'=>$id))->setField('img_path',$img_path_new);
					if (!$edit_return) {
						$this->error('上传失败!');
					} else {
						unlink('.'.$img_path);
						$this->success('上传成功!');
					}
				}
			} else {
				$id = I('get.id',0,'int');
				$find_return = M('ad')->where(array('id'=>$id))->find();
				$this->assign('data',$find_return);
				$this->display();
			}
		}

		public function delimg() {
			if (IS_POST) {
				$id = I('post.id',0,'int');
				$find_return = M('ad')->where(array('id'=>$id))->find();
				$img_path = $find_return['img_path'];
				$set_return = M('ad')->where(array('id'=>$id))->setField('img_path','');
				if (!$set_return) {
					$this->error('删除失败!');
				} else {
					unlink('.'.$img_path);
					$this->success('删除成功!');
				}
			}
		}

		public function editAd() {
			if (IS_POST) {
				$id = I('post.id',0,'int'); 
				$date = explode(' - ',I('post.date'));
				$start_time = strtotime($date[0]);
				$end_time = strtotime($date[1]);
				$edit_data['ad_title'] = I('post.title');
				$edit_data['starttime'] = $start_time;
				$edit_data['endtime'] = $end_time;
				$edit_return = M('ad')->where(array('id'=>$id))->save($edit_data);
				if (!$edit_return) {
					$this->error('修改失败!');
				} else {
					$this->success('修改成功!');
				}
			} else {
				$id = I('get.id',0,'int');
				$find_return = M('ad')->where(array('id'=>$id))->find();
				$this->assign('data',$find_return);
				$this->display('editAd');
			}
		}

		public function delAd() {
			if (IS_POST) {
				$id = I('post.id',0,'int');
				$set_return = M('ad')->where(array('id'=>$id))->setField('status',0);
				if (!$set_return) {
					$this->error('删除失败!');
				} else {
					$this->success('删除成功!');
				}
			}
		}

	}