<?php

	/*******************************************************************\
	|																	|
	|	房哨（多中介管理运营平台系统）									|
	|																	|
	|	© 2018-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	namespace Erpadmin\Controller;
	use Think\Controller;
	class MenuController extends ErpadminbaseController {

		public function index(){
			$result = M('Menu')->where()->order(array("listorder" => "ASC"))->select();
			$tree 	= new \Org\Util\Tree();
			$tree->icon = array('&nbsp;&nbsp;&nbsp;│ ', '&nbsp;&nbsp;&nbsp;├─ ', '&nbsp;&nbsp;&nbsp;└─ ');
			$tree->nbsp = '&nbsp;&nbsp;&nbsp;';
			$newmenus=array();
			foreach ($result as $m){
				$newmenus[$m['id']]=$m;
			}
			foreach ($result as $n=> $r) {
				$result[$n]['levels'] = $this->_get_level($r['id'], $newmenus);
				$result[$n]['parentid_node'] = ($r['parentid']) ? ' class="child-of-node-' . $r['parentid'] . '"' : '';
				$result[$n]['style'] = empty($r['parentid']) ? '' : 'display:none;';
				if ($result[$n]['levels']<2) {
					$result[$n]['str_manage'] = '<a class="layui-btn layui-btn-normal layui-btn-xs"  onclick="layer_show(\'添加\',\''.U('add',array('parentid'=>$r['id'])).'\',\'600\',\'400\')" > 添加</a>';
				}
				$result[$n]['str_manage'] .='<a class="layui-btn layui-btn-warm layui-btn-xs"  onclick="layer_show(\'修改\',\''.U('edit',array('id'=>$r['id'])).'\',\'600\',\'400\')" > 修改</a>';
				$result[$n]['status'] = $r['status'] ? "显示" : "隐藏"; 
				if ($r['type']==1) {
					$result[$n]['types'] = '菜单';
				}elseif ($r['type']==2) {
					$result[$n]['types'] = '菜单+节点';
				}elseif ($r['type']==3) {
					$result[$n]['types'] = '外部链接';
				}
			}
			$tree->init($result);
			$str = "<tr id='node-\$id' \$parentid_node style='\$style'>
				<td style='padding-left:20px;'>\$id</td>
				<td>\$spacer\$listorder-\$name</td>
				<td>\$node_id</td>
				<td>\$types</td>
				<td>\$status</td>
				<td>\$str_manage</td>
			</tr>";
			$categorys = $tree->get_tree(0, $str);
			$this->assign("categorys", $categorys);
			$this->display(); 
		}

		/**
			* 获取递归数组深度
			* @param $id
			* @param $array
			* @param $i
		*/

		protected function _get_level($id, $array = array(), $i = 0) {
			if ($array[$id]['parentid']==0 || empty($array[$array[$id]['parentid']]) || $array[$id]['parentid']==$id){
				return  $i;
			}else{
				$i++;
				return $this->_get_level($array[$id]['parentid'],$array,$i);
			}
		}

		public function add(){
			if (IS_POST) {
				$this->error('请联系客服（19965783436）获取正式版功能！');
			}else{
				$tree = new \Org\Util\Tree();
				$parentid = I("get.parentid",0,'intval');
				$result = M('Menu')->where()->order(array("listorder" => "ASC"))->select();
				foreach ($result as $r) {
					$r['selected'] = $r['id'] == $parentid ? 'selected' : '';
					$r['disabled'] = $r['level'] == 3 ? 'disabled' : '';
					$array[] = $r;
				}
				$str = "<option value='\$id' \$selected \$disabled>\$spacer \$name</option>";
				$tree->init($array);
				$select_categorys = $tree->get_tree(0, $str);
				$this->assign("select_categorys", $select_categorys);
				$this->display();
			}
		}

		public function edit(){
			if (IS_POST) {
				$this->error('请联系客服（19965783436）获取正式版功能！');
			}else{
				$tree = new \Org\Util\Tree();
				$id = I("get.id",0,'intval');
				$this->menu = M('Menu')->where(array('id'=>$id))->find();
				$parentid = $this->menu['parentid'];
				$result = M('Menu')->where()->order(array("listorder" => "ASC"))->select();
				foreach ($result as $r) {
					$r['selected'] = $r['id'] == $parentid ? 'selected' : '';
					$r['disabled'] = $r['level'] == 3 ? 'disabled' : '';
					$array[] = $r;
				}
				$str = "<option value='\$id' \$selected \$disabled>\$spacer \$name</option>";
				$tree->init($array);
				$select_categorys = $tree->get_tree(0, $str);
				$this->assign("select_categorys", $select_categorys);
				$this->display();
			}
		}

	}