<?php

	/*******************************************************************\
	|																	|
	|	房哨（多中介管理运营平台系统）									|
	|																	|
	|	© 2018-2023 http://www.kaidandashi.com/ All rights reserved.	|
	|																	|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																	|
	|	QQ号：984784483													|
	|																	|
	\*******************************************************************/

	namespace Erpadmin\Controller;
	use Think\Controller;
	class RegionController extends ErpadminbaseController {

		/**
			* [index 省份列表]
			* @Author L
			* @DateTime 2018-09-25
		*/

		public function index() {
			if (I('is_ajax')) {
				$field = I('field');//排序字段名
				$order = I('order');//排序方式 asc desc
				$limit = I('limit',30,'int');//每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$where['level'] = 1;
				$keyword = I('keyword');
				if ($keyword) {
					$where['name'] = array('like',"%{$keyword}%");
				}
				$region_count = M('region')->where($where)->count();
				$Page = new \Think\Page($region_count,$limit);
				$region_select = M('region')->where($where)->limit($Page->firstRow.",".$Page->listRows)->select();
				$return = array(
					'code'=>0,
					'msg'=>'',
					'count'=>$region_count,
					'data'=>$region_select
				);
				$this->ajaxReturn($return);
			} else {
				$this->display();
			}
		}

		public function addSheng() {
			if (IS_POST) {
				$add_data['name'] = I('name');
				$add_data['level'] = 1;
				$add_data['pid'] = 0;
				$add_return = M('region')->add($add_data);
				if (!$add_return) {
					$this->error('添加失败!');
				} else {
					$this->success('添加成功!');
				}
			} else {
				$this->display('addSheng');
			}
		}

		public function editSheng() {
			if (IS_POST) {
				$id = I('id');
				$save_data['name'] = I('name');
				$save_return = M('region')->where(array('id'=>$id))->save($save_data);
				if (!$save_return) {
					$this->error('修改失败!');
				} else {
					$this->success('修改成功!');
				}
			} else {
				$id = I('id');
				$region_find = M('region')->where(array('id'=>$id))->find();
				$this->name = $region_find['name'];
				$this->display('editSheng');
			}
		}

		public function city() {
			if (I('is_ajax')) {
				$field = I('field');//排序字段名
				$order = I('order');//排序方式 asc desc
				$limit = I('limit',30,'int');//每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$where = " where a.level = 2 ";
				$region = I('region',0,'int');
				if ($region) {
					$where .= " and a.pid = {$region}";
				}
				$keyword = I('keyword');
				if ($keyword) {
					$where .= " and a.name like '%{$keyword}%'";
				}
				$Model = new \Think\Model;
				$count_sql = "SELECT COUNT(*) FROM __REGION__ a JOIN __REGION__ b ON a.pid = b.id {$where}";
				$city_count_arr = $Model->query($count_sql);
				$city_count = $city_count_arr[0]['COUNT(*)'];
				$Page = new \Think\Page($city_count,$limit);
				$select_sql = "SELECT a.*,b.name as pname FROM __REGION__ a JOIN __REGION__ b ON a.pid = b.id {$where} limit ".$Page->firstRow.",".$Page->listRows;
				$city_select = $Model->query($select_sql);
				$return = array(
					'code'=>0,
					'msg'=>'',
					'count'=>$city_count,
					'data'=>$city_select
				);
				$this->ajaxReturn($return);
			} else {
				$map['level'] = 1;
				$this->region_select = M('region')->where($map)->select();
				$this->display();
			}
		}

		public function addCity() {
			if (IS_POST) {
				$add_data['name'] = I('name');
				$add_data['level'] = 2;
				$add_data['pid'] = I('pid');
				$add_return = M('region')->add($add_data);
				if (!$add_return) {
					$this->error('添加失败!');
				} else {
					$this->success('添加成功!');
				}
			} else {
				$this->display('addCity');
			}
		}

		public function editCity() {
			if (IS_POST) {
				$id = I('id');
				$save_data['name'] = I('name');
				$save_return = M('region')->where(array('id'=>$id))->save($save_data);
				if (!$save_return) {
					$this->error('修改失败!');
				} else {
					$this->success('修改成功!');
				}
			} else {
				$id = I('id');
				$region_find = M('region')->where(array('id'=>$id))->find();
				$this->name = $region_find['name'];
				$this->display('editCity');
			}
		}

		public function xingzhengqu() {
			if (I('is_ajax')) {
				$field = I('field');//排序字段名
				$order = I('order');//排序方式 asc desc
				$limit = I('limit',30,'int');//每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$where = " where a.id > 0 and b.level = 2 ";
				$region = I('region',0,'int');
				if ($region) {
					$where .= " and b.pid = {$region}";
				}
				$keyword = I('keyword');
				if ($keyword) {
					$where .= " and a.xzqming like '%{$keyword}%'";
				}
				$Model = new \Think\Model;
				$count_sql = "SELECT COUNT(*) FROM __XINGZHENGQU__ a JOIN __REGION__ b on a.pid = b.id JOIN __REGION__ c ON b.pid = c.id {$where}";
				$city_count_arr = $Model->query($count_sql);
				$city_count = $city_count_arr[0]['COUNT(*)'];
				$Page = new \Think\Page($city_count,$limit);
				$select_sql = "SELECT a.*,b.name as pname,c.name as ppname FROM __XINGZHENGQU__ a JOIN __REGION__ b on a.pid = b.id JOIN __REGION__ c ON b.pid = c.id {$where} limit ".$Page->firstRow.",".$Page->listRows;
				$city_select = $Model->query($select_sql);
				$return = array(
					'code'=>0,
					'msg'=>'',
					'count'=>$city_count,
					'data'=>$city_select
				);
				$this->ajaxReturn($return);
			} else {
				$map['level'] = 1;
				$this->region_select = M('region')->where($map)->select();
				$this->display();
			}
		}

		public function addXingzhengqu() {
			if (IS_POST) {
				$add_data['xzqming'] = I('name');
				$add_data['pid'] = I('pid');
				$add_data['status'] = 1;
				$add_return = M('xingzhengqu')->add($add_data);
				if (!$add_return) {
					$this->error('添加失败!');
				} else {
					$this->success('添加成功!');
				}
			} else {
				$this->display('addXingzhengqu');
			}
		}

		public function editXingzhengqu() {
			if (IS_POST) {
				$id = I('id');
				$save_data['xzqming'] = I('name');
				$save_data['status'] = I('status');
				$save_return = M('xingzhengqu')->where(array('id'=>$id))->save($save_data);
				if (!$save_return) {
					$this->error('修改失败!');
				} else {
					$this->success('修改成功!');
				}
			} else {
				$id = I('id');
				$xingzhengqu_find = M('xingzhengqu')->where(array('id'=>$id))->find();
				$this->data_find = $xingzhengqu_find;
				$this->display('editXingzhengqu');
			}
		}

		public function pianqu() {
			if (I('is_ajax')) {
				$field = I('field');//排序字段名
				$order = I('order');//排序方式 asc desc
				$limit = I('limit',30,'int');//每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$where = " where a.id > 0 and c.level = 2 ";
				$region = I('region',0,'int');
				if ($region) {
					$where .= " and d.id = {$region}";
				}
				$keyword = I('keyword');
				if ($keyword) {
					$where .= " and a.pianqum like '%{$keyword}%'";
				}
				$Model = new \Think\Model;
				$count_sql = "SELECT COUNT(*) FROM __PIANQU__ AS a JOIN __XINGZHENGQU__ b on a.ssxzq = b.id JOIN __REGION__ c on b.pid = c.id JOIN __REGION__ d ON c.pid = d.id {$where} ";
				$city_count_arr = $Model->query($count_sql);
				$city_count = $city_count_arr[0]['COUNT(*)'];
				$Page = new \Think\Page($city_count,$limit);
				$select_sql = "SELECT a.*,b.xzqming,c.name as pname,d.name as ppname FROM __PIANQU__ AS a JOIN __XINGZHENGQU__ b on a.ssxzq = b.id JOIN __REGION__ c on b.pid = c.id JOIN __REGION__ d ON c.pid = d.id {$where} limit ".$Page->firstRow.",".$Page->listRows;
				$city_select = $Model->query($select_sql);
				$return = array(
					'code'=>0,
					'msg'=>'',
					'count'=>$city_count,
					'data'=>$city_select
				);
				$this->ajaxReturn($return);
			} else {
				$map['level'] = 1;
				$this->region_select = M('region')->where($map)->select();
				$this->display();
			}
		}

		public function addPianqu() {
			if (IS_POST) {
				$add_data['pianqum'] = I('name');
				$add_data['ssxzq'] = I('pid');
				$add_data['status'] = 1;
				$add_return = M('pianqu')->add($add_data);
				if (!$add_return) {
					$this->error('添加失败!');
				} else {
					$this->success('添加成功!');
				}
			} else {
				$this->display('addPianqu');
			}
		}

		public function editPianqu() {
			if (IS_POST) {
				$id = I('id');
				$save_data['pianqum'] = I('name');
				$save_data['status'] = I('status');
				$save_return = M('pianqu')->where(array('id'=>$id))->save($save_data);
				if (!$save_return) {
					$this->error('修改失败!');
				} else {
					$this->success('修改成功!');
				}
			} else {
				$id = I('id');
				$painqu_find = M('pianqu')->where(array('id'=>$id))->find();
				$this->data_find = $painqu_find;
				$this->display('editPianqu');
			}
		}

		public function xiaoqu() {
			if (I('is_ajax')) {
				$field = I('field');//排序字段名
				$order = I('order');//排序方式 asc desc
				$limit = I('limit',30,'int');//每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$where = " where a.id > 0 and d.level = 2 ";
				$region = I('region',0,'int');
				if ($region) {
					$where .= " and e.id = {$region}";
				}
				$status = I('status');
				$keyword = I('keyword');
				switch ($status) {
					case 2:
						$where .= " and a.status = 0";
						break;
					case 1:
						$where .= " and a.status = 1";
						break;
					default:
						break;
				}
				if ($keyword) {
					$where .= " and (a.xiaoqum like '%{$keyword}%' or c.xzqming like '%{$keyword}%' or d.name like '%{$keyword}%' or e.name like '%{$keyword}%')";
				}
				$Model = new \Think\Model;
				$count_sql = "SELECT COUNT(*) FROM __XIAOQU__ as a LEFT JOIN __PIANQU__ AS b ON a.sspianqu=b.id JOIN __XINGZHENGQU__ c on a.ssxzq = c.id JOIN __REGION__ d on c.pid = d.id JOIN __REGION__ e ON d.pid = e.id {$where} ";
				$city_count_arr = $Model->query($count_sql);
				$city_count = $city_count_arr[0]['COUNT(*)'];
				$Page = new \Think\Page($city_count,$limit);
				$select_sql = "SELECT a.xiaoqum,a.xiaoqudz,a.status,a.id,b.pianqum,c.xzqming,d.name as pname,e.name as ppname FROM __XIAOQU__ as a LEFT JOIN __PIANQU__ AS b ON a.sspianqu=b.id JOIN __XINGZHENGQU__ c on a.ssxzq = c.id JOIN __REGION__ d on c.pid = d.id JOIN __REGION__ e ON d.pid = e.id {$where} limit ".$Page->firstRow.",".$Page->listRows;
				$city_select = $Model->query($select_sql);
				foreach ($city_select as $key => $value) {
					$city_select[$key]['status_new'] = $value['status'] ? '有效':'未审核';
				}
				$return = array(
					'code'=>0,
					'msg'=>'',
					'count'=>$city_count,
					'data'=>$city_select
				);
				$this->ajaxReturn($return);
			} else {
				$map['level'] = 1;
				$this->region_select = M('region')->where($map)->select();
				$this->display();
			}
		}

		public function addXiaoqu() {
			if (IS_POST) {
				$add_data['xiaoqum'] = I('name');
				$add_data['ssxzq'] = I('pid');
				$add_data['status'] = 1;
				$add_return = M('pianqu')->add($add_data);
				if (!$add_return) {
					$this->error('添加失败!');
				} else {
					$this->success('添加成功!');
				}
			} else {
				$this->display('addXiaoqu');
			}
		}

		public function editXiaoqu() {
			if (IS_POST) {
				$id = I('id');
				$save_data['xiaoqum'] = I('name');
				$save_data['status'] = I('status');
				$save_return = M('xiaoqu')->where(array('id'=>$id))->save($save_data);
				if (!$save_return) {
					$this->error('修改失败!');
				} else {
					$this->success('修改成功!');
				}
			} else {
				$id = I('id');
				$xiaoqu_find = M('xiaoqu')->where(array('id'=>$id))->find();
				$this->xiaoqu_find = $xiaoqu_find;
				$this->display('editXiaoqu');
			}
		}

		public function xiaoquDetails() {
			$id=I('id');
			$whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
			$xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
			$this->pianqu=zym($xiaoqu['sspianqu'],2);
			$this->xingzhengqu=zym($xiaoqu['ssxzq'],1);
			$this->xiaoqu=$xiaoqu;
			$this->xuexiao=zym($xiaoqu['ssxuexiao'],4);
			$this->zdshu=0;
			$this->fjshu=0;
			$this->wuyelx=get_peizhi('wuyelx',$xiaoqu['wuyelx'],3);
			$this->wuyezz=get_peizhi('wuyezz',$xiaoqu['wuyezz'],3);
			$this->xmjibie=get_peizhi('xmjibie',$xiaoqu['xmjibie'],3);
			$this->gongqifs=get_peizhi('gongqifs',$xiaoqu['gongqifs'],3);
			$this->kangzhen=get_peizhi('kangzhen',$xiaoqu['kangzhen'],3);
			$this->ceweizldw=get_peizhi('ceweizldw',$xiaoqu['ceweizldw'],3);
			$this->gongdianlx=get_peizhi('gongdianlx',$xiaoqu['gongdianlx'],3);
			$this->gongshuilx=get_peizhi('gongshuilx',$xiaoqu['gongshuilx'],3);
			$this->spjzleixing=get_peizhi('spjzleixing',$xiaoqu['spjzleixing'],3);
			$Model = new \Think\Model;
			if ($xiaoqu['jiegou']) {
				$condition1="gongsiid = ".session("gongsiid")." and pzming = 'jiegou' and lxid in (".$xiaoqu['jiegou'].")";
				$this->jiegou=$Model->query("select * from __PEIZHI__ where {$condition1}");
			}
			if ($xiaoqu['yongtu']) {
				$condition2="gongsiid = ".session("gongsiid")." and pzming = 'yongtu' and lxid in (".$xiaoqu['yongtu'].")";
				$this->yongtu=$Model->query("select * from __PEIZHI__ where {$condition2}");
			}
			if ($xiaoqu['dianshi']) {
				$condition3="gongsiid = ".session("gongsiid")." and pzming = 'dianshi' and lxid in (".$xiaoqu['dianshi'].")";
				$this->dianshi=$Model->query("select * from __PEIZHI__ where {$condition3}");
			}
			if ($xiaoqu['tongxun']) {
				$condition4="gongsiid = ".session("gongsiid")." and pzming = 'tongxun' and lxid in (".$xiaoqu['tongxun'].")";
				$this->tongxun=$Model->query("select * from __PEIZHI__ where {$condition4}");
			}
			if ($xiaoqu['chanquan']) {
				$condition5="gongsiid = ".session("gongsiid")." and pzming = 'chanquan' and lxid in (".$xiaoqu['chanquan'].")";
				$this->chanquan=$Model->query("select * from __PEIZHI__ where {$condition5}");
			}
			if ($xiaoqu['sqanquan']) {
				$condition6="gongsiid = ".session("gongsiid")." and pzming = 'sqanquan' and lxid in (".$xiaoqu['sqanquan'].")";
				$this->sqanquan=$Model->query("select * from __PEIZHI__ where {$condition6}");
			}
			if ($xiaoqu['cainuanfs']) {
				$condition7="gongsiid = ".session("gongsiid")." and pzming = 'cainuanfs' and lxid in (".$xiaoqu['cainuanfs'].")";
				$this->cainuanfs=$Model->query("select * from __PEIZHI__ where {$condition7}");
			}
			if ($xiaoqu['fwleixing']) {
				$condition8="gongsiid = ".session("gongsiid")." and pzming = 'fwleixing' and lxid in (".$xiaoqu['fwleixing'].")";
				$this->fwleixing=$Model->query("select * from __PEIZHI__ where {$condition8}");
			}
			if ($xiaoqu['wldibanlx']) {
				$condition9="gongsiid = ".session("gongsiid")." and pzming = 'wldibanlx' and lxid in (".$xiaoqu['wldibanlx'].")";
				$this->wldibanlx=$Model->query("select * from __PEIZHI__ where {$condition9}");
			}
			if ($xiaoqu['gongshuifs']) {
				$condition10="gongsiid = ".session("gongsiid")." and pzming = 'gongshuifs' and lxid in (".$xiaoqu['gongshuifs'].")";
				$this->gongshuifs=$Model->query("select * from __PEIZHI__ where {$condition10}");
			}
			$this->display('xiaoquDetails');
		}

		// 修改小区详情
		public function xiugaixiaoqu(){
			$id=I('id');
			$whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
			if (IS_POST) {
				$isMob="/^1[345789]{1}\d{9}$/";
				$isTel="/^([0-9]{3,4}-)?[0-9]{7,8}$/";
				$wuyedh = I('wuyedh');
				if($wuyedh && !preg_match($isMob,$wuyedh) && !preg_match($isTel,$wuyedh)){
					$this->error('电话号码格式有误！');
				}
				if (I('youzheng') && !is_numeric(I('youzheng'))) {
					$this->error('邮编只能为数字！');
				}
				if (I('csjunjia') && !is_numeric(I('csjunjia'))) {
					$this->error('均价只能为数字！');
				}
				if (I('rongjilv') && !is_numeric(I('rongjilv')) && I('rongjilv')<0 && I('rongjilv')>100) {
					$this->error('容积率只能为0-100的数字,！');
				}
				if (I('lvhualv') && !is_numeric(I('lvhualv')) && I('lvhualv')<0 && I('lvhualv')>100) {
					$this->error('绿化率只能为0-100的数字,！');
				}
				if (I('wuyefei') && !is_numeric(I('wuyefei'))) {
					$this->error('物业费只能为数字！');
				}
				$xgxqxq=I('xgxqxq');
				$xgxqzb=I('xgxqzb');
				$xgxqpt1=I('xgxqpt1');
				$xgxqpt2=I('xgxqpt2');
				$xgxqqs1=I('xgxqqs1');
				$xgxqqs2=I('xgxqqs2');
				if ($xgxqxq==1) {
					if (I('chewei')) {
						$data['chewei']=1;
						$data['ceweizldw']=I('ceweizldw');
						$data['dxiatcwsj']=I('dxiatcwsj');
						$data['dxiatcwsl']=I('dxiatcwsl');
						$data['dxiatcwzl']=I('dxiatcwzl');
						$data['dshangtcwsj']=I('dshangtcwsj');
						$data['dshangtcwsl']=I('dshangtcwsl');
						$data['dshangtcwzl']=I('dshangtcwzl');
					} else {
						$data['chewei']=2;
					}
					if (I('dianti')) {
						$data['dianti']=1;
						$data['diantixq']=I('diantixq');
					} else {
						$data['dianti']=2;
					}
					$data['beizhu']=I('beizhu');
					$data['jiedao']=I('jiedao');
					$data['wuyedh']=I('wuyedh');
					$data['wuyedz']=I('wuyedz');
					$data['wuyemc']=I('wuyemc');
					$data['jianjie']=I('jianjie');
					$data['lvhualv']=I('lvhualv');
					$data['wuyefei']=I('wuyefei');
					$data['csjunjia']=I('csjunjia');
					$data['gongqifs']=I('gongqifs');
					$data['rongjilv']=I('rongjilv');
					$data['xiaoqubm']=I('xiaoqubm');
					$data['xiaoqudz']=I('xiaoqudz');
					$data['youzheng']=I('youzheng');
					$data['zhandimj']=I('zhandimj');
					$data['jianzaond']=I('jianzaond');
					$data['jianzhumj']=I('jianzhumj');
					$data['ssxuexiao']=I('ssxuexiao');
					$data['gongdianlx']=I('gongdianlx');
					$data['gongshuilx']=I('gongshuilx');
				} elseif ($xgxqzb==1) {
					$data['ditielx']=I('ditielx');
					$data['jinrongjg']=I('jinrongjg');
					$data['paichusuo']=I('paichusuo');
					$data['ssxuexiao']=I('ssxuexiao');
					$data['zhengfujg']=I('zhengfujg');
					$data['gongjiaolx']=I('gongjiaolx');
					$data['xiuxianyule']=I('xiuxianyule');
					$data['yiliaojigou']=I('yiliaojigou');
					$data['shangchangcs']=I('shangchangcs');
				} elseif ($xgxqpt1==1) {
					if (I('chewei')) {
						$data['chewei']=1;
						$data['ceweizldw']=I('ceweizldw');
						$data['dxiatcwsj']=I('dxiatcwsj');
						$data['dxiatcwsl']=I('dxiatcwsl');
						$data['dxiatcwzl']=I('dxiatcwzl');
						$data['dshangtcwsj']=I('dshangtcwsj');
						$data['dshangtcwsl']=I('dshangtcwsl');
						$data['dshangtcwzl']=I('dshangtcwzl');
					} else {
						$data['chewei']=2;
					}
					if (I('dianti')) {
						$data['dianti']=1;
						$data['diantixq']=I('diantixq');
					} else {
						$data['dianti']=2;
					}
					$ds1=array_keys(I('dianshi'));
					$ds2=implode(',',$ds1);
					$data['dianshi']=$ds2;
					$tx1=array_keys(I('tongxun'));
					$tx2=implode(',',$tx1);
					$data['tongxun']=$tx2;
					$aq1=array_keys(I('sqanquan'));
					$aq2=implode(',',$aq1);
					$data['sqanquan']=$aq2;
					$cn1=array_keys(I('cainuanfs'));
					$cn2=implode(',',$cn1);
					$data['cainuanfs']=$cn2;
					$gs1=array_keys(I('gongshuifs'));
					$gs2=implode(',',$gs1);
					$data['gongshuifs']=$gs2;
					$data['wuyedh']=I('wuyedh');
					$data['wuyedz']=I('wuyedz');
					$data['wuyelx']=I('wuyelx');
					$data['wuyemc']=I('wuyemc');
					$data['wuyezz']=I('wuyezz');
					$data['dianfei']=I('dianfei');
					$data['wuyefei']=I('wuyefei');
					$data['gongqifs']=I('gongqifs');
					$data['cainuanfy']=I('cainuanfy');
					$data['gongdianlx']=I('gongdianlx');
					$data['gongshuilx']=I('gongshuilx');
				} elseif ($xgxqpt2==1) {
					if (I('yjfjzx')) {
						$data['yjfjzx']=1;
					} else {
						$data['yjfjzx']=2;
					}
					if (I('wldiban')) {
						$data['wldiban']=1;
						$db1=array_keys(I('wldibanlx'));
						$db2=implode(',',$db1);
						$data['wldibanlx']=$db2;
						$data['wldibangd']=I('wldibangd');
					} else {
						$data['wldiban']=2;
					}
					if (I('ygcanting')) {
						$data['ygcanting']=1;
						$data['ygcantingjj']=I('ygcantingjj');
					} else {
						$data['ygcanting']=2;
					}
					$data['zyktpp']=I('zyktpp');
					$data['xfsjgyl']=I('xfsjgyl');
					$data['zyktjsf']=I('zyktjsf');
					$data['zyktgzsj']=I('zyktgzsj');
				} elseif ($xgxqqs1==1) {
					$jg1=array_keys(I('jiegou'));
					$jg2=implode(',',$jg1);
					$data['jiegou']=$jg2;
					$yt1=array_keys(I('yongtu'));
					$yt2=implode(',',$yt1);
					$data['yongtu']=$yt2;
					$cq1=array_keys(I('chanquan'));
					$cq2=implode(',',$cq1);
					$data['chanquan']=$cq2;
					$fw1=array_keys(I('fwleixing'));
					$fw2=implode(',',$fw1);
					$data['fwleixing']=$fw2;
					$data['lvhualv']=I('lvhualv');
					$data['csjunjia']=I('csjunjia');
					$data['nianxian']=I('nianxian');
					$data['rongjilv']=I('rongjilv');
					$data['zhandimj']=I('zhandimj');
					$data['jianzaond']=I('jianzaond');
					$data['jianzhumj']=I('jianzhumj');
					$data['ycqdanwei']=I('ycqdanwei');
					$data['kaifashang']=I('kaifashang');
					$data['kpshijian']=strtotime(I('kpshijian'));
					$data['rzshijian']=strtotime(I('rzshijian'));
				} elseif ($xgxqqs2==1) {
					if (I('5a')) {
						$data['5a']=1;
					} else {
						$data['5a']=2;
					}
					if (I('zhuce')) {
						$data['zhuce']=1;
					} else {
						$data['zhuce']=2;
					}
					if (I('youhui')) {
						$data['youhui']=1;
						$data['youhuizc']=I('youhuizc');
					} else {
						$data['youhui']=2;
					}
					$data['bzcjzmj']=I('bzcjzmj');
					$data['wlmzxbz']=I('wlmzxbz');
					$data['xmgaodu']=I('xmgaodu');
					$data['xmjibie']=I('xmjibie');
					$data['kangzhen']=I('kangzhen');
					$data['spjzleixing']=I('spjzleixing');
				} else {
					if (I('chewei')) {
						$data['chewei']=1;
						$data['ceweizldw']=I('ceweizldw');
						$data['dxiatcwsj']=I('dxiatcwsj');
						$data['dxiatcwsl']=I('dxiatcwsl');
						$data['dxiatcwzl']=I('dxiatcwzl');
						$data['dshangtcwsj']=I('dshangtcwsj');
						$data['dshangtcwsl']=I('dshangtcwsl');
						$data['dshangtcwzl']=I('dshangtcwzl');
					} else {
						$data['chewei']=2;
					}
					if (I('dianti')) {
						$data['dianti']=1;
						$data['diantixq']=I('diantixq');
					} else {
						$data['dianti']=2;
					}
					$data['beizhu']=I('beizhu');
					$data['jiedao']=I('jiedao');
					$data['wuyedh']=I('wuyedh');
					$data['wuyedz']=I('wuyedz');
					$data['wuyemc']=I('wuyemc');
					$data['jianjie']=I('jianjie');
					$data['lvhualv']=I('lvhualv');
					$data['wuyefei']=I('wuyefei');
					$data['csjunjia']=I('csjunjia');
					$data['gongqifs']=I('gongqifs');
					$data['rongjilv']=I('rongjilv');
					$data['xiaoqubm']=I('xiaoqubm');
					$data['xiaoqudz']=I('xiaoqudz');
					$data['youzheng']=I('youzheng');
					$data['zhandimj']=I('zhandimj');
					$data['jianzaond']=I('jianzaond');
					$data['jianzhumj']=I('jianzhumj');
					$data['ssxuexiao']=I('ssxuexiao');
					$data['gongdianlx']=I('gongdianlx');
					$data['gongshuilx']=I('gongshuilx');
				}
				$isok=M('xiaoqu')->where(array('id'=>$id))->save($data);
				if ($isok===1){
					$this->success('更新成功！');
				}elseif ($isok===0){
					$this->error('数据无变动！');
				}else{
					$this->error('更新失败！');
				}
			} else {
				$xgxqxq=I('xgxqxq');
				$xgxqzb=I('xgxqzb');
				$xgxqpt1=I('xgxqpt1');
				$xgxqpt2=I('xgxqpt2');
				$xgxqqs1=I('xgxqqs1');
				$xgxqqs2=I('xgxqqs2');
				if ($xgxqxq==1) {
					$this->xuequ=M('xuequ')->select();
					$this->gongqifs=get_peizhi('gongqifs',0,1);
					$this->ceweizldw=get_peizhi('ceweizldw',0,1);
					$this->gongdianlx=get_peizhi('gongdianlx',0,1);
					$this->gongshuilx=get_peizhi('gongshuilx',0,1);
				} elseif ($xgxqzb==1) {
					$this->xuequ=M('xuequ')->select();
				} elseif ($xgxqpt1==1) {
					$this->wuyelx=get_peizhi('wuyelx',0,1);
					$this->wuyezz=get_peizhi('wuyezz',0,1);
					$this->dianshi=get_peizhi('dianshi',0,1);
					$this->tongxun=get_peizhi('tongxun',0,1);
					$this->gongqifs=get_peizhi('gongqifs',0,1);
					$this->sqanquan=get_peizhi('sqanquan',0,1);
					$this->cainuanfs=get_peizhi('cainuanfs',0,1);
					$this->ceweizldw=get_peizhi('ceweizldw',0,1);
					$this->gongdianlx=get_peizhi('gongdianlx',0,1);
					$this->gongshuifs=get_peizhi('gongshuifs',0,1);
					$this->gongshuilx=get_peizhi('gongshuilx',0,1);
					$dianshi1=M('xiaoqu')->where(array('id'=>$id))->getField('dianshi');
					$this->dianshi2=explode(",", $dianshi1);
					$tongxun1=M('xiaoqu')->where(array('id'=>$id))->getField('tongxun');
					$this->tongxun2=explode(",", $tongxun1);
					$sqanquan1=M('xiaoqu')->where(array('id'=>$id))->getField('sqanquan');
					$this->sqanquan2=explode(",", $sqanquan1);
					$cainuanfs1=M('xiaoqu')->where(array('id'=>$id))->getField('cainuanfs');
					$this->cainuanfs2=explode(",", $cainuanfs1);
					$gongshuifs1=M('xiaoqu')->where(array('id'=>$id))->getField('gongshuifs');
					$this->gongshuifs2=explode(",", $gongshuifs1);
				} elseif ($xgxqpt2==1) {
					$this->wldibanlx=get_peizhi('wldibanlx',0,1);
					$wldibanlx1=M('xiaoqu')->where(array('id'=>$id))->getField('wldibanlx');
					$this->wldibanlx2=explode(",", $wldibanlx1);
				} elseif ($xgxqqs1==1) {
					$this->jiegou=get_peizhi('jiegou',0,1);
					$this->yongtu=get_peizhi('yongtu',0,1);
					$this->chanquan=get_peizhi('chanquan',0,1);
					$this->fwleixing=get_peizhi('fwleixing',0,1);
					$jiegou1=M('xiaoqu')->where(array('id'=>$id))->getField('jiegou');
					$this->jiegou2=explode(",", $jiegou1);
					$yongtu1=M('xiaoqu')->where(array('id'=>$id))->getField('yongtu');
					$this->yongtu2=explode(",", $yongtu1);
					$chanquan1=M('xiaoqu')->where(array('id'=>$id))->getField('chanquan');
					$this->chanquan2=explode(",", $chanquan1);
					$fwleixing1=M('xiaoqu')->where(array('id'=>$id))->getField('fwleixing');
					$this->fwleixing2=explode(",", $fwleixing1);
				} elseif ($xgxqqs2==1) {
					$this->xmjibie=get_peizhi('xmjibie',0,1);
					$this->kangzhen=get_peizhi('kangzhen',0,1);
					$this->spjzleixing=get_peizhi('spjzleixing',0,1);
				} else {
					$this->xuequ=M('xuequ')->select();
					$this->gongqifs=get_peizhi('gongqifs',0,1);
					$this->ceweizldw=get_peizhi('ceweizldw',0,1);
					$this->gongdianlx=get_peizhi('gongdianlx',0,1);
					$this->gongshuilx=get_peizhi('gongshuilx',0,1);
				}
				$this->xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
				$this->display();
			}
		}

		// 调整坐标
		public function tzdtzb(){
			$id=I('id');
			$whrid=M('xiaoqu')->where(array('id'=>$id))->getField('whrid');
			if (IS_POST) {
				$data['dituzb']=I('dituzb');
				$isok=M("xiaoqu")->where(array('id'=>$id))->save($data);
				if ($isok===1){
					$this->success('更新成功！');
				}elseif ($isok===0){
					$this->error('数据无变动！');
				}else{
					$this->error('更新失败！');
				}
			} else {
				$this->xiaoqu=M('xiaoqu')->where(array('id'=>$id))->find();
				$this->display();
			}
		}

		/**
			* webuploader 图片上传
		*/

		function scxqtp() {
			$xqid=I('xqid');
			$whrid=M('xiaoqu')->where(array('id'=>$xqid))->getField('whrid');
			if (IS_POST) {
				// 根据自己的业务调整上传路径、允许的格式、文件大小
				$path = "/Upload/xiaoqu/".$xqid;
				ajax_upload_xq($path);
			} else {
				$this->display();
			}
		}

		/**
			* [xq_pic_setfengmian 异步小区图片为封面]
			* @return [json] [description]
		*/

		public function xq_pic_setfengmian(){
			$id=I('xq_pic_id');
			//根据图片id查找小区图片的小区id号xqid
			$xqid = M('xqphoto')->where(array('id'=>$id))->getField('xqid');
			$adduid=M('xqphoto')->where(array('id'=>$id))->getField('uid');
			M('xqphoto')->where(array('xqid'=>$xqid,'fengmian'=>1))->setField(array('fengmian'=>0));
			$r = M('xqphoto')->where(array('id'=>$id))->setField(array('fengmian'=>1));
			if ($r) {
				$this->success('设置成功');
			}else{
				$this->error('设置失败');
			}
		}

		/**
			* [xq_pic_del 异步删除图片]
			* @return [json] [description]
		*/

		public function xq_pic_del(){
			$id=I('xq_pic_id');
			//根据图片id查看当前是否还有当前小区的图片
			$xqid = M('xqphoto')->where(array('id'=>$id))->getField('xqid');
			$adduid=M('xqphoto')->where(array('id'=>$id))->getField('uid');
			$piccount = M('xqphoto')->where(array('xqid'=>$xqid))->count();
			$dp=M('xqphoto');
			if($id){	//删除当前图片
				$plist = $dp->where(array('id'=>$id))->find();
				if ($plist){
					unlink('./Upload/xiaoqu/'.$plist['xqid'].'/'.$plist['image']);
					unlink('./Upload/xiaoqu/'.$plist['xqid'].'/t_'.$plist['image']);
					$dp->where(array('id'=>$id))->delete();
					$data=array('pics'=>$plist);
					//删除最后一个小区图片后给xiaoqu表的tupian字段置 0
					if ($piccount==1) {
						M('xiaoqu')->where(array('id'=>$xqid))->setField('tupian',0);
					}
				}else{
					$data=array('pics'=>$plist);
				}
			}
			//返回值
			header("Content-type: application/json");
			exit(json_encode($data));
		}

		//批量删除小区图片
		public function xq_pic_dels(){
			$ids=I('xq_pic_ids');
			foreach ($ids as $key => $value) {
				$adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
			}
			$xqid = M('xqphoto')->where(array('id'=>$ids[0]))->getField('xqid');
			if(is_array($ids)){
				$where = 'id in('.implode(',',$ids).')';//p($where);die;
				//获取当前图片的小区id
				$dp=M('xqphoto');
				foreach ($ids as $value) {//删除小区图片文件
					$plist = $dp->where(array('id'=>$value))->find();
					unlink('./Upload/xiaoqu/'.$plist['xqid'].'/'.$plist['image']);
					unlink('./Upload/xiaoqu/'.$plist['xqid'].'/t_'.$plist['image']);
				}
				$dp->where($where)->delete();
				//删除最后一个小区图片后给xiaoqu表的tupian字段置 0
				$nopic = M('xqphoto')->where(array('xqid'=>$xqid))->count();
				if ($nopic<=0) {
					M('xiaoqu')->where(array('id'=>$xqid))->setField('tupian',0);
				}
				$this->success('删除成功');
			}else{
				$this->error('删除失败'); 
			}
		}

		//批量下载小区图片
		public function xq_pic_downloads(){
			$ids=I('xq_pic_ids');
			foreach ($ids as $key => $value) {
				$adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
			}
			$where = 'id in('.implode(',',$ids).')';
			$dp=M('xqphoto');
			$plist = $dp->where($where)->field('id,xqid,image')->select();
			$zip = new \ZipArchive; 
			if ($plist) {
				//压缩文件名(临时文件)
				$filename = './Upload/xiaoqu/'.$plist[0]['xqid'].'/'.md5($plist[0]['xqid']).'.zip';
				$downname = I("server.HTTP_HOST").'/Upload/xiaoqu/'.$plist[0]['xqid'].'/'.md5($plist[0]['xqid']).'.zip';
				//p($downname);die;
			}
			//新建zip压缩包
			$zip->open($filename,\ZipArchive::OVERWRITE | \ZipArchive::CREATE);
			//把图片一张一张加进去压缩
			foreach ($plist as $value) {
				$zip->addFile('./Upload/xiaoqu/'.$value['xqid'].'/'.$value['image']);
				$zip->renameName('./Upload/xiaoqu/'.$value['xqid'].'/'.$value['image'],$value['image']);
			}
			//打包zip
			$zip->close();
			//可以直接重定向下载
			//header('Location:'.$downname);
			$this->success($downname);
		}

		//设置图片类型
		public function settupianleixing(){
			if (IS_POST) {
				$ids=explode(",",I('xq_pic_ids'));
				foreach ($ids as $key => $value) {
					$adduid=M('xqphoto')->where(array('id'=>$value))->getField('uid');
				}
				$ids1=I('xq_pic_ids');
				$tpleixing = I('tpleixing');
				if ($tpleixing=="") {
					$this->error("请选择图片类型");
				}
				$where = 'id in('.$ids1.')';
				$dp=M('xqphoto');
				$plist = $dp->where($where)->setField(array('leixing' => $tpleixing ));
				if ($plist) {
					$this->success("设置成功");
				}else{
					$this->error("设置失败");
				}
			} else {
				$this->tpleixing = get_peizhi('xqtplx',0,1);
				$this->display();// 输出模板
			}
		}

	}