
local assets =
{
	Asset("ANIM", "anim/r_shelter.zip"),
}

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("idle")
	inst.AnimState:PushAnimation("idle", true)
end

local function onbuilt(inst)
	inst.components.resurrector.active = true
    ProfileStatsSet("r_shelter_activated", true)
	inst.AnimState:PlayAnimation("idle")
	inst.AnimState:PushAnimation("idle", true)
	inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_activate")
	inst.components.resurrector:OnBuilt()
		--TheWorld:PushEvent("ms_sendlightningstrike", Vector3(inst.Transform:GetWorldPosition()))
end

local function doresurrect(inst, dude)
	inst:AddTag("busy")
	inst.MiniMapEntity:SetEnabled(false)
    if inst.Physics then
		MakeInventoryPhysics(inst) -- collides with world, but not character
    end
    ProfileStatsSet("r_shelter_used", true)

	GetClock():MakeNextDay()
    dude.Transform:SetPosition(inst.Transform:GetWorldPosition())
    dude:Hide()
    TheCamera:SetDistance(12)
	dude.components.hunger:Pause()

    scheduler:ExecuteInTime(3, function()
        dude:Show()


        GetSeasonManager():DoLightningStrike(Vector3(inst.Transform:GetWorldPosition()))
			inst.AnimState:PlayAnimation("trash")
    	local smoke = SpawnPrefab("maxwell_smoke")
    	local but = SpawnPrefab("skeleton")

    	local pos = inst:GetPosition()
    		smoke.Transform:SetPosition(pos.x, pos.y, pos.z)
    		smoke.Transform:SetScale(2,2,2)
    		but.Transform:SetPosition(pos.x, pos.y, pos.z)

		inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_break")


				if dude.components.hunger then
						dude.components.hunger:SetPercent(2/3)
				end

				if dude.components.health then
						dude.components.health:Respawn(TUNING.RESURRECT_HEALTH)
				end

				if dude.components.sanity then
			dude.components.sanity:SetPercent(.5)
				end

				if dude.components.moisture then
					dude.components.moisture.moisture = 0
				end

				if dude.components.temperature then
					dude.components.temperature:SetTemperature(TUNING.STARTING_TEMP)
				end

				dude.components.hunger:Resume()

        dude.sg:GoToState("wakeup")


        dude:DoTaskInTime(3, function(inst)
		            if dude.HUD then
		                dude.HUD:Show()
		            end
		            TheCamera:SetDefault()
		            inst:RemoveTag("busy")
        end)

    end)
end

local function makeused(inst)
	inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

    anim:SetBank("r_shelter")
    anim:SetBuild("r_shelter")
    anim:PlayAnimation("idle", true)

	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "r_shelter.tex" )

    inst:AddTag("shelter")

    inst:AddComponent("inspectable")

    inst:AddComponent("lootdropper")

    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)

	inst:AddComponent("resurrector")

	inst.components.resurrector.doresurrect = doresurrect
	inst:ListenForEvent( "onbuilt", onbuilt)

	inst.components.resurrector.makeusedfn = makeused

	inst.components.inspectable:RecordViews()
--[[
	inst:DoPeriodicTask(1, function(inst)
	if ShelterLight and TheWorld.state.isnight
	then
	inst.Light:Enable(true)
	else
	inst.Light:Enable(false)
	end
end)
]]

    return inst
end

return Prefab( "common/r_shelter", fn, assets),
		MakePlacer( "common/r_shelter_placer", "r_shelter", "r_shelter", "idle" )
