local resolvefilepath = GLOBAL.resolvefilepath
local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local Action = GLOBAL.Action
local TECH = GLOBAL.TECH -- Added local reference to global tech, fixes issues with recipes later on

STRINGS.NAMES.SMALLBLOOD = "Blood Bag"
STRINGS.RECIPE_DESC.SMALLBLOOD = "A tiny amount of blood"
STRINGS.NAMES.SMALLBLOOD_1 = "Chicken Blood"
STRINGS.RECIPE_DESC.SMALLBLOOD_1 = "Be glad you can't catch salmonella."
STRINGS.NAMES.SMALLBLOOD_2 = "Frog Blood"
STRINGS.RECIPE_DESC.SMALLBLOOD_2 = "Favorite of every french vampire."
STRINGS.NAMES.SMALLBLOOD_3 = "Fish Blood"
STRINGS.RECIPE_DESC.SMALLBLOOD_3 = "Rich in Omega3."
STRINGS.NAMES.SMALLBLOOD_4 = "Twice-stolen Blood"
STRINGS.RECIPE_DESC.SMALLBLOOD_4 = "Don't ask where the mosquito got it."
STRINGS.NAMES.LARGEBLOOD = "Large Blood Bag"
STRINGS.RECIPE_DESC.LARGEBLOOD = "A large quantity of blood"
STRINGS.NAMES.HUMANBLOOD = "Human blood bag"
STRINGS.RECIPE_DESC.HUMANBLOOD = "Indescribably good"
STRINGS.NAMES.MONSTERBLOOD = "Monster Blood"
STRINGS.RECIPE_DESC.MONSTERBLOOD = "Foul-looking monster blood"
STRINGS.NAMES.PLANTBLOOD = "Synthetic Blood"
STRINGS.RECIPE_DESC.PLANTBLOOD = "Is this even blood?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SMALLBLOOD = "It is a bag full of blood."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LARGEBLOOD = "A sausage made from intestines and filled with blood."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HUMANBLOOD = "Is that human blood?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MONSTERBLOOD = "I think something is moving in there."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PLANTBLOOD = "It is bag with some... fluid."

STRINGS.RECIPE_DESC.SUMMONFRAN = "I can summon myself!" 
GLOBAL.STRINGS.NAMES.SUMMONFRAN = "Fran's Phantom"
GLOBAL.STRINGS.NAMES.CLONEFRANSPEAR = "Scorpion Spear"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUMMONFRAN = "Is she as hot-headed as the real one?"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CLONEFRANSPEAR = "For a certain magical, yet, abrasive girl."



STRINGS.NAMES.BLOODSWORD = "Lævateinn"
STRINGS.RECIPE_DESC.BLOODSWORD = "Sword of victory."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLOODSWORD = ("Feel my wrath.")

STRINGS.NAMES.ICEFROG = "Icefrog"
STRINGS.RECIPE_DESC.ICEFROG = "Author of DotA."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ICEFROG = ("Aghanim's Scepter.")

STRINGS.NAMES.FRANJOURNAL = "Taboo「Four of a Kind」"
STRINGS.RECIPE_DESC.FRANJOURNAL = "Shall we play together?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FRANJOURNAL = ("Let's play together~!")

STRINGS.CHARACTERS.GENERIC.DESCRIBE.FRAN = ("She is a rather creepy-looking girl.")
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.FRAN = ("She suffers the Renfield syndrome. Probably.")
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.FRAN = ("She is a little monster pretending to be a girl.")
STRINGS.CHARACTERS.WOODIE.DESCRIBE.FRAN = ("She has hungry animal-like eyes.")
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.FRAN = ("Little night-girl almost strong like Wolfgang!")
STRINGS.CHARACTERS.WILLOW.DESCRIBE.FRAN = ("The corpse girl fears fire")
STRINGS.CHARACTERS.WENDY.DESCRIBE.FRAN = ("Hell had no room for her")
STRINGS.CHARACTERS.WX78.DESCRIBE.FRAN = ("IT WANTS TO EAT HUMANS.")


PrefabFiles = {
  "fran",
  "bloodsword",
  "bloodswordx",
  "bloodbags",
  "franjournal",
  "icefrog",
  "fran_none",
  "summonfran",
  "clonefranspear",
}

Assets = {
  Asset( "IMAGE", "images/saveslot_portraits/fran.tex" ),
  Asset( "ATLAS", "images/saveslot_portraits/fran.xml" ),

  Asset( "IMAGE", "images/selectscreen_portraits/fran.tex" ),
  Asset( "ATLAS", "images/selectscreen_portraits/fran.xml" ),

  Asset( "IMAGE", "images/selectscreen_portraits/fran_silho.tex" ),
  Asset( "ATLAS", "images/selectscreen_portraits/fran_silho.xml" ),

  Asset( "IMAGE", "bigportraits/fran.tex" ),
  Asset( "ATLAS", "bigportraits/fran.xml" ),

  Asset( "IMAGE", "images/map_icons/fran.tex" ),
  Asset( "ATLAS", "images/map_icons/fran.xml" ),
  
  Asset( "IMAGE", "images/avatars/avatar_fran.tex" ),
  Asset( "ATLAS", "images/avatars/avatar_fran.xml" ),
  
  Asset( "IMAGE", "images/avatars/avatar_ghost_fran.tex" ),
  Asset( "ATLAS", "images/avatars/avatar_ghost_fran.xml" ),
  
  -- Crafting Tab
  Asset( "IMAGE", "images/hud/FranCraftingTab.tex" ),
  Asset( "ATLAS", "images/hud/FranCraftingTab.xml" ),
    
}



AddComponentPostInit("moisture", function(self)
  local old = self.GetMoistureRate
  self.GetMoistureRate = function(self)
    local oldvalue = old(self)
    local x, y, z = self.inst.Transform:GetWorldPosition()
    local ents = GLOBAL.TheSim:FindEntities(x, y, z, 4, {'sheltercarrier'})
    for k, v in pairs(ents) do 
      if v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS) and 
      v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS).prefab == "umbrella" then
        return 0
      end
      if v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS) and 
      v.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS).prefab == "grass_umbrella" then
        return oldvalue * 0.5
      end
    end
    return oldvalue
  end
end)

local comb_rep = GLOBAL.require "components/combat_replica"
local old_IsAlly = comb_rep.IsAlly
function comb_rep:IsAlly(guy,...)
  if guy:HasTag("summonfran") then
    return true
  end
  return old_IsAlly(self,guy,...)
end



-- Get Mod Settings --
GLOBAL.FranEasy = (GetModConfigData("fran_difficulty")=="easy")
GLOBAL.FranNormal = (GetModConfigData("fran_difficulty")=="normal")
GLOBAL.FranDiet = (GetModConfigData("fran_diet"))
GLOBAL.package.loaded["fran.modenv"] = env


AddModCharacter("fran", "FEMALE")
AddMinimapAtlas("images/map_icons/fran.xml")
AddMinimapAtlas("images/fran.xml")

GLOBAL.STRINGS.CHARACTER_TITLES.fran = "The Younger Sister of the Akuma"
GLOBAL.STRINGS.CHARACTER_NAMES.fran = "Flandre Scarlet"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.fran = ",*Is a vampire\n*Has night vision\n*Bloodthirsty"
GLOBAL.STRINGS.CHARACTER_QUOTES.fran = "\"Shall we play together?\""

GLOBAL.STRINGS.CHARACTERS.FRAN = require "speech_fran"

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "fran")

-- Make blood edible... for fran.
-- Not doing anything currently? perhaps fran is not set to eat blood
GLOBAL.FOODTYPE.BLOOD = "BLOOD"
local bloodItems = {"smallblood","largeblood", "monsterblood", "plantblood"}
local function AddBloodFood(inst)
    inst:AddTag("edible_"..GLOBAL.FOODTYPE.BLOOD)
end
for k,v in pairs(bloodItems) do
    AddPrefabPostInit(v, AddBloodFood)
end

---- New recipe code
--if not GLOBAL.TheNet:IsDedicated() then
--    local OldIsRecipeValid = GLOBAL.IsRecipeValid
--    local function IsRecipeValid(recipe)
--        return OldIsRecipeValid(recipe) and
--            ((GLOBAL.ThePlayer and GLOBAL.ThePlayer:HasTag(recipe.name.."_builder")) or not recipe.tagneeded)
--    end
--    GLOBAL.IsRecipeValid = IsRecipeValid
--end
--local Recipe = GLOBAL.Recipe
--local RECIPETABS = GLOBAL.RECIPETABS
--local TECH = GLOBAL.TECH
--
--
--local recipes =
--  {
--  Recipe("smallblood",
--  {
--  Ingredient("nightmarefuel", 1),
--  Ingredient("redgem", 1),
--  Ingredient("charcoal", 1),
--  Ingredient("nitre", 1),
--  },
--  RECIPETABS.FOOD,
--  TECH.NONE
--  )
--}
--
--local sortkey = -9613
--for k,v in pairs(recipes) do
--    sortkey = sortkey -1
--    v.sortkey = sortkey
--    v.tagneeded = true
--end

-- Change the effectiveness of meat food items attempt 2
 AddComponentPostInit("edible", function(Edible, inst)
 local oldGetHunger = Edible.GetHunger
 function Edible:GetHunger(eater)
    local multiplier = 1
    if eater ~= nil then
        if eater:HasTag("blood_drinker") then
            if self.foodtype == "MEAT" then
                if FranDiet == "semi_carnivore" then
                    multiplier = 0.7
                else
                    multiplier = 1
                end
            elseif self.foodtype == "blood" then
                multiplier = 1
            else
                multiplier = 1
            end
        end
    end
    return multiplier * oldGetHunger(self, eater)
    end
    end
 )

--(display name, sort order (999 end of list), atlas xml file, image, builder tag)
local blood_tab = AddRecipeTab( "VampiricF", 100, "images/hud/FranCraftingTab.xml", "FranCraftingTab.tex", "blood_drinker")
-- Use this as the recipe tab for recipes
-----------------------
---- Vampiric Sword
-----------------------
--(name, ingredients, tab, level, placer, min_spacing, nounlock, numtogive, builder_tag, atlas, image)
-- blood_drinker tag is implied here as the crafting tab needs blood_drinker to show up
local blood_sword = AddRecipe("bloodsword", {Ingredient("nightmarefuel", 6),
    Ingredient("redgem", 1),
    Ingredient("charcoal", 1),
    Ingredient("nitre", 1),}, blood_tab, GLOBAL.TECH.NONE)
blood_sword.atlas = "images/inventoryimages/bloodsword.xml"
blood_sword.image = "bloodsword.tex"

-----------------------
---- Small Blood
-----------------------
local small_blood = {
    AddRecipe("smallblood", {Ingredient("smallmeat", 2)}, blood_tab, GLOBAL.TECH.NONE),
    AddRecipe("smallblood_1", {Ingredient("drumstick", 2)}, blood_tab, GLOBAL.TECH.NONE),
    AddRecipe("smallblood_2", {Ingredient("froglegs", 2)}, blood_tab, GLOBAL.TECH.NONE),
    AddRecipe("smallblood_3", {Ingredient("fish", 2)}, blood_tab, GLOBAL.TECH.NONE),
    AddRecipe("smallblood_4", {Ingredient("mosquitosack", 1)}, blood_tab, GLOBAL.TECH.NONE)
}
--[[
local small_blood = AddRecipe("smallblood", {Ingredient("smallmeat", 2), blood_tab, GLOBAL.TECH.NONE)
small_blood.atlas = "images/inventoryimages/smallblood.xml"
small_blood.image = "smallblood.tex"

local small_blood_1 = AddRecipe("smallblood_1", {Ingredient("drumstick", 2), blood_tab, GLOBAL.TECH.NONE)
small_blood_1.atlas = "images/inventoryimages/smallblood.xml"
small_blood_1.image = "smallblood.tex"


local small_blood_2 = AddRecipe("smallblood_2", {Ingredient("froglegs", 2), blood_tab, GLOBAL.TECH.NONE)
small_blood_2.atlas = "images/inventoryimages/smallblood.xml"
small_blood_2.image = "smallblood.tex"


local small_blood_3 = AddRecipe("smallblood_3", {Ingredient("fish", 2), blood_tab, GLOBAL.TECH.NONE)
small_blood_3.atlas = "images/inventoryimages/smallblood.xml"
small_blood_3.image = "smallblood.tex"


local small_blood_4 = AddRecipe("smallblood_4", {Ingredient("mosquitosack", 1), blood_tab, GLOBAL.TECH.NONE)
small_blood_4.atlas = "images/inventoryimages/smallblood.xml"
small_blood_4.image = "smallblood.tex"
]]
-- Register atlas/images
for k,v in pairs(small_blood) do
    v.atlas = "images/inventoryimages/smallblood.xml"
    v.image = "smallblood.tex"
end

-----------------------
---- Large Blood
-----------------------
local large_blood = AddRecipe("largeblood", {Ingredient("meat", 2)}, blood_tab, GLOBAL.TECH.NONE)
large_blood.atlas = "images/inventoryimages/largeblood.xml"
large_blood.image = "largeblood.tex"

-----------------------
---- Human Blood
-----------------------
local human_blood = AddRecipe("humanblood", {Ingredient("humanmeat", 1)}, blood_tab, GLOBAL.TECH.NONE)
human_blood.atlas = "images/inventoryimages/largeblood.xml"
human_blood.image = "largeblood.tex"

-----------------------
---- Monster Blood
-----------------------
local monster_blood = AddRecipe("monsterblood", {Ingredient("monstermeat", 2)}, blood_tab, GLOBAL.TECH.NONE)
monster_blood.atlas = "images/inventoryimages/monsterblood.xml"
monster_blood.image = "monsterblood.tex"

-----------------------
---- Plant Blood
-----------------------
local plant_blood = AddRecipe("plantblood", {Ingredient("plantmeat", 1)}, blood_tab, GLOBAL.TECH.NONE)
plant_blood.atlas = "images/inventoryimages/plantblood.xml"
plant_blood.image = "plantblood.tex"


local monster_blood = AddRecipe("franjournal", {
    Ingredient("papyrus", 2),
    Ingredient("petals_evil", 4),
    Ingredient("petals", 4),
    Ingredient("butterflywings", 1),
}, blood_tab, GLOBAL.TECH.NONE)
monster_blood.atlas = "images/inventoryimages/franjournal.xml"
monster_blood.image = "franjournal.tex"
