require "tuning"
local assets =
{	
  Asset( "ANIM", "anim/smallblood.zip" ),
  Asset( "ANIM", "anim/plantblood.zip" ),
  Asset( "ANIM", "anim/monsterblood.zip" ),
  Asset( "ANIM", "anim/largeblood.zip" ),
  Asset ("ATLAS", "images/inventoryimages/smallblood.xml"),
  Asset ("ATLAS", "images/inventoryimages/largeblood.xml"),
  Asset ("ATLAS", "images/inventoryimages/monsterblood.xml"),
  Asset ("ATLAS", "images/inventoryimages/plantblood.xml"),
  
}

local prefabs = {
    "smallblood",
    "largeblood",
    "monsterblood",
    "plantblood",
    "humanblood",
    "smallblood_1",
    "smallblood_2",
    "smallblood_3",
    "smallblood_4",
    "spoiled_food",
}
--------------------------
-- Normal blood recipes --
--------------------------
local function common(bank, build, anim, tag)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
        
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank(bank)
    inst.AnimState:SetBuild(build)
    inst.AnimState:PlayAnimation(anim)

    inst:AddTag("blood")
    if tag ~= nil then
        inst:AddTag(tag)
    end

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("edible")
    inst.components.edible.ismeat = true -- what is this 
    inst.components.edible.foodtype = FOODTYPE.BLOOD

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = build
    inst:AddComponent("stackable")

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    MakeHauntableLaunchAndPerish(inst)
    inst:ListenForEvent("spawnedfromhaunt", function(inst, data)
        Launch(inst, data.haunter, TUNING.LAUNCH_SPEED_SMALL)
    end)

    return inst
end

-- small bloodbag
local function smallblood()
  local inst = common("deerclops_eyeball", "smallblood", "idle")

    if not TheWorld.ismastersim then
        return inst
    end
    
    inst.components.edible.healthvalue = TUNING.HEALING_MEDSMALL * 2
    inst.components.edible.hungervalue = TUNING.CALORIES_SMALL * 2.5
    inst.components.edible.sanityvalue = TUNING.SANITY_TINY * 1
    inst.components.inventoryitem.atlasname = "images/inventoryimages/smallblood.xml"

    inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)

    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    return inst
end

-- large bloodbag
local function largeblood()
  local inst = common("deerclops_eyeball", "largeblood", "idle")

    if not TheWorld.ismastersim then
        return inst
    end
    
    inst.components.edible.healthvalue = TUNING.HEALING_MED * 2
    inst.components.edible.hungervalue = TUNING.CALORIES_MED * 2.5
    inst.components.edible.sanityvalue = TUNING.SANITY_SMALL * 1
    inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)
    inst.components.inventoryitem.atlasname = "images/inventoryimages/largeblood.xml"

    return inst
end

-- Human bloodbag
local function humanblood()
  local inst = common("deerclops_eyeball", "largeblood", "idle")

    if not TheWorld.ismastersim then
        return inst
    end
    
    inst.components.edible.healthvalue = TUNING.HEALING_MED * 4
    inst.components.edible.hungervalue = TUNING.CALORIES_MED * 4
    inst.components.edible.sanityvalue = TUNING.SANITY_SMALL * 3
    inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)
    inst.components.inventoryitem.atlasname = "images/inventoryimages/largeblood.xml"

    return inst
end

-- monster bloodbag
local function monsterblood()
  local inst = common("deerclops_eyeball", "monsterblood", "idle")

    if not TheWorld.ismastersim then
        return inst
    end
    
    inst.components.edible.healthvalue = TUNING.HEALING_TINY * 1
    inst.components.edible.hungervalue = TUNING.CALORIES_MEDSMALL * 1.5
    inst.components.edible.sanityvalue = -TUNING.SANITY_TINY * 1
    inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)
    inst.components.inventoryitem.atlasname = "images/inventoryimages/monsterblood.xml"

    return inst
end

-- plant bloodbag
local function plantblood()
  local inst = common("deerclops_eyeball", "plantblood", "idle")

    if not TheWorld.ismastersim then
        return inst
    end
    
    inst.components.edible.healthvalue = TUNING.HEALING_MEDLARGE * 1
    inst.components.edible.hungervalue = TUNING.CALORIES_MED * 1.25
    inst.components.edible.sanityvalue = -TUNING.SANITY_MED
    inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)
    inst.components.inventoryitem.atlasname = "images/inventoryimages/plantblood.xml"

    return inst
end

--------------------------
-- Transforming Recipes --
--------------------------

local function transforming(bank, build, anim, tag)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
        
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank(bank)
    inst.AnimState:SetBuild(build)
    inst.AnimState:PlayAnimation(anim)
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = build
end

local function smallblood_1()
  local inst = common("deerclops_eyeball", "smallblood", "idle")
    if not TheWorld.ismastersim then
        return inst
    end
    inst.components.perishable:SetPerishTime(5)
    inst.components.perishable.onperishreplacement = "smallblood"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/smallblood.xml"

    return inst
end
local function smallblood_2()
  local inst = common("deerclops_eyeball", "smallblood", "idle")
    if not TheWorld.ismastersim then
        return inst
    end
    inst.components.perishable:SetPerishTime(5)
    inst.components.perishable.onperishreplacement = "smallblood"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/smallblood.xml"

    return inst
end
local function smallblood_3()
  local inst = common("deerclops_eyeball", "smallblood", "idle")
    if not TheWorld.ismastersim then
        return inst
    end
    inst.components.perishable:SetPerishTime(5)
    inst.components.perishable.onperishreplacement = "smallblood"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/smallblood.xml"

    return inst
end
local function smallblood_4()
  local inst = common("deerclops_eyeball", "smallblood", "idle")
    if not TheWorld.ismastersim then
        return inst
    end
    inst.components.perishable:SetPerishTime(5)
    inst.components.perishable.onperishreplacement = "smallblood"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/smallblood.xml"

    return inst
end



return  Prefab("common/inventory/smallblood", smallblood, assets),
        Prefab("common/inventory/largeblood", largeblood, assets),
        Prefab("common/inventory/monsterblood", monsterblood, assets),
        Prefab("common/inventory/plantblood", plantblood, assets),
        Prefab("common/inventory/humanblood", humanblood, assets),
        Prefab("common/inventory/smallblood_1", smallblood_1, assets),
        Prefab("common/inventory/smallblood_2", smallblood_2, assets),
        Prefab("common/inventory/smallblood_3", smallblood_3, assets),
        Prefab("common/inventory/smallblood_4", smallblood_4, assets)