
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/fran.zip" ),
        Asset( "ANIM", "anim/ghost_fran_build.zip" ),
    		Asset( "ANIM", "anim/fran_fed.zip" ),
    		Asset( "ANIM", "anim/fran_starved.zip" ),
    		Asset( "ANIM", "anim/fran_sunlight.zip" ),
    		Asset( "ANIM", "anim/fran_nightmare.zip" ),
    		
}

local prefabs = {}
local commentMoonlight = 1
local randomValue = 0
-- Get Mod Settings --

-- Level Up System --
-- XP Chart:
-- Pig/Bunnyman = 100 XP
-- Player = 500 XP
local level = 0
local levelUpComment = true

-- Attributes --
local baseHealth = 100
local baseStomache = 150
local baseDmgMult = 1
local walkSpeed = 1
local currentLevel = 0

-- level up system

local function onExperienceGain(inst)
    if inst.experience >= 66600 and level < 10 then
        -- Level 6 (easter egg level!) (666 pigs)
        level = 10
        inst.components.hunger:SetMax(300)
        baseDmgMult = 2.5
        walkSpeed = 1.25
        baseHealth = 400
        if levelUpComment == true then
            inst.components.talker:Say("I have become a True Vampire!")
        end
        
    elseif inst.experience >= 10000 and level < 9 then
        -- Level 5 (100 pigs)
        level = 9
        baseHealth = 200
        inst.components.hunger:SetMax(250)
        walkSpeed = 1.1
        baseDmgMult = 1.5
        if levelUpComment == true then
            inst.components.talker:Say("My power is still growing... Alucard would be proud.")
        end
            
    elseif inst.experience >= 6600 and level < 8 then
        -- Level 5 (66 pigs)
        level = 8
        baseHealth = 190
        inst.components.hunger:SetMax(240)
        walkSpeed = 1.09
        baseDmgMult = 1.45
        if levelUpComment == true then
            inst.components.talker:Say("I'm... becoming a monster.")
        end
        
    elseif inst.experience >= 4000 and level < 7 then
        -- Level 4 (40x pigs)
        level = 7
        baseHealth = 180
        inst.components.hunger:SetMax(230)
        walkSpeed = 1.08
        baseDmgMult = 1.4
        if levelUpComment == true then
            inst.components.talker:Say("Am I losing the last of my humanity?")
        end
        
    elseif inst.experience >= 3200 and level < 6 then
        -- Level 2 (32x pigs)
        level = 6
        baseHealth = 170
        inst.components.hunger:SetMax(220)
        walkSpeed = 1.07
        baseDmgMult = 1.35
        if levelUpComment == true then
            inst.components.talker:Say("I feel warm. Almost burning with power.")
        end
        
    elseif inst.experience >= 2400 and level < 5 then
        -- Level 3 (24 pigs)
        level = 5
        baseHealth = 160
        inst.components.hunger:SetMax(210)
        walkSpeed = 1.06
        baseDmgMult = 1.3
        if levelUpComment == true then
            inst.components.talker:Say("Ah... I can feel dark power within.")
        end
        
    elseif inst.experience >= 1400 and level < 4 then
        -- Level 2 (16 pigs)
        level = 4
        baseHealth = 150
        inst.components.hunger:SetMax(200)
        walkSpeed = 1.05
        baseDmgMult = 1.25
        if levelUpComment == true then
            inst.components.talker:Say("I feel lighter and more... powerful.")
        end
        
    elseif inst.experience >= 800 and level < 3 then
        -- Level 2 (8x pigs)
        level = 3
        baseHealth = 140
        inst.components.hunger:SetMax(190)
        walkSpeed = 1.04
        baseDmgMult = 1.2
        if levelUpComment == true then
            inst.components.talker:Say("I feel... stronger.")
        end
        
    elseif inst.experience >= 400 and level < 2 then
        -- Level 2 (4x pigs)
        level = 2
        baseHealth = 130
        inst.components.hunger:SetMax(180)
        walkSpeed = 1.03
        baseDmgMult = 1.15
        if levelUpComment == true then
            inst.components.talker:Say("I can feel a bit of my power returning to me.")
        end
        
    elseif inst.experience >= 1 and level < 1 then
        -- Level 1 (1x pig)
        level = 1
        baseHealth = 120
        inst.components.hunger:SetMax(170)
        walkSpeed = 1.02
        baseDmgMult = 1.1
        if levelUpComment == true then
            inst.components.talker:Say("The blood... I can feel its power.")
        end
    end
    
end


local function bloodcrazy(inst)
    inst.components.hunger:DoDelta(TUNING.CALORIES_MED*10)
    inst.components.health:DoDelta(TUNING.HEALING_SUPERHUGE)
    inst.components.sanity:DoDelta(TUNING.SANITY_HUGE*-1)
end
local function entitydeathfn(inst, data)
    if data.cause == inst.prefab then
        if data.inst.prefab == "pigman" or data.inst.prefab == "pigguard" or data.inst.prefab == "bunnyman" then
            print("killed humanoid")
            inst.experience = inst.experience + 100
            inst.components.hunger:DoDelta(TUNING.CALORIES_MED)
            inst.components.health:DoDelta(TUNING.HEALING_MED)
            randomValue = math.random(25)
            if randomValue == 0 then
                inst.components.talker:Say("Ah... sorry.")
            elseif randomValue == 1 then
                inst.components.talker:Say("It tastes suspiciously... human.")
            elseif randomValue == 2 then
                inst.components.talker:Say("Should I feel bad about that?")
            elseif randomValue == 3 then
                inst.components.talker:Say("Delicious!")
            elseif randomValue == 4 then
                inst.components.talker:Say("They don't count as people, right?")
            elseif randomValue == 5 then
                inst.components.talker:Say("Oh wow! this tastes awesome!")
            elseif randomValue == 6 then
                inst.components.talker:Say("Ah... it's nice...")
            elseif randomValue == 7 then
                inst.components.talker:Say("They tastes nice...")
            elseif randomValue == 8 then
                inst.components.talker:Say("They are just pigs, so...")
            elseif randomValue == 9 then
                inst.components.talker:Say("I would never do this to humans. I think.")
            elseif randomValue == 10 then
                inst.components.talker:Say("Hahaha! A feast this is a great... feast!!")
                bloodcrazy(inst)
            elseif randomValue == 11 then
                if FranEasy then
                    inst.components.talker:Say("I was going to rampage, but the mod config is set to Easy.")
                else
                    inst.components.talker:Say("Oh, **** the hell, yes!")
                end
                
                bloodcrazy(inst)
            
            end
        elseif data.inst.prefab == "krampus"then
            print("killed Krampus himself!")
            inst.experience = inst.experience + 250
            inst.components.hunger:DoDelta(TUNING.CALORIES_MEDSMALL)
            inst.components.health:DoDelta(TUNING.HEALING_MED)
            inst.components.talker:Say("This blood... is powerful.")
        elseif data.inst.prefab == "merm" or data.inst.prefab == "monkey"  then
            print("killed monster humanoid")
            inst.experience = inst.experience + 50
            inst.components.hunger:DoDelta(TUNING.CALORIES_MEDSMALL)
            inst.components.health:DoDelta(TUNING.HEALING_MEDSMALL)
        elseif data.inst.prefab == "rabbit" or data.inst.prefab == "penguin" or data.inst.prefab == "frog" then
            print("killed critter")
            inst.experience = inst.experience + 10
            inst.components.hunger:DoDelta(TUNING.CALORIES_SMALL)
            inst.components.health:DoDelta(TUNING.HEALING_TINY)
        elseif data.inst.prefab == "perd" then
            inst.experience = inst.experience + 25
            inst.components.hunger:DoDelta(TUNING.CALORIES_MED)
            inst.components.health:DoDelta(TUNING.HEALING_MED)
        elseif data.inst.prefab == "beefalo" or data.inst.prefab == "koalefant_summer" or  data.inst.prefab == "koalefant_winter"  then
            inst.experience = inst.experience + 50
            inst.components.hunger:DoDelta(TUNING.CALORIES_MED)
            inst.components.health:DoDelta(TUNING.HEALING_SMALL)
        elseif data.inst.prefab == "babybeefalo" or data.inst.prefab == "mossling"  or data.inst.prefab == "catcoon" then
            inst.experience = inst.experience + 20
            inst.components.hunger:DoDelta(TUNING.CALORIES_MEDSMALL)
            inst.components.health:DoDelta(TUNING.HEALING_MEDSMALL)
        
        --killed human player --
        elseif data.inst.HasTag ~= nil then
            if data.inst:HasTag("player") then
                print("killed player")
                inst.experience = inst.experience + 250
                inst.components.hunger:DoDelta(TUNING.CALORIES_HUGE)
                inst.components.health:DoDelta(TUNING.HEALING_HUGE)
                inst.components.sanity:DoDelta(TUNING.SANITY_LARGE*-1)
                randomValue = math.random(2)
                if randomValue == 0 then
                    inst.components.talker:Say("I... had to.")
                elseif randomValue == 1 then
                    inst.components.talker:Say("It was... beyond my control.")
                elseif randomValue == 2 then
                    inst.components.talker:Say("That wasn't...")
                end
            end
        end
        print(inst.experience)
        onExperienceGain(inst)
    end
end


local tempCaveVar = false --Replace this once caves are out

--startregen parameters: first parameter = tick size. second parameter = tick frequency

-- stat/apperance differences night/day hungry/starved
local function updatestats(inst)
  if inst.sg:HasStateTag("nomorph") or
          inst:HasTag("playerghost") or
          inst.components.health:IsDead() then
          return
  end
	local health_percent = inst.components.health:GetPercent()
    if TheWorld.state.isday then
		if inst.strength == "mighty" then
		      -- HP 100 - 200
    			inst.components.health.maxhealth = 0.8 * baseHealth -0
    			inst.components.health:StopRegen()
    			inst.components.combat.damagemultiplier = 0.85 * baseDmgMult
    			inst.components.hunger:SetRate(2*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = 0
    			inst.components.temperature.inherentinsulation = 30*6
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.0 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.0 * walkSpeed)
    			inst.AnimState:SetBuild("fran")
    			commentMoonlight = 1
  		elseif inst.strength == "normal" then
  		    -- HP 80 - 180
          inst.components.health.maxhealth = 0.8 * baseHealth - 10
          inst.components.health:StopRegen()
          inst.components.combat.damagemultiplier = 0.6 * baseDmgMult
          inst.components.hunger:SetRate(0.8*TUNING.WILSON_HUNGER_RATE)	
          inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL*-1
          inst.components.temperature.inherentinsulation = 30*4
          inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.9 * walkSpeed)
          inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.9 * walkSpeed)
          inst.AnimState:SetBuild("fran_sunlight")
          commentMoonlight = 1
  		elseif inst.strength == "wimpy" then
  		    -- HP 60 - 150
    			inst.components.health.maxhealth = 0.65 * baseHealth - 0
    			inst.components.health:StopRegen()
    			inst.components.combat.damagemultiplier = 0.4 * baseDmgMult
    			inst.components.hunger:SetRate(0.7*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_MED*-1
    			inst.components.temperature.inherentinsulation = 30*2
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.8 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.8 * walkSpeed)
    			inst.AnimState:SetBuild("fran_starved")
    			commentMoonlight = 1
  			
  		end		
  		inst.components.health:SetPercent(health_percent)
  		inst.Light:Enable(false)
		
	elseif TheWorld.state.isdusk then
  		if inst.strength == "mighty" then
  		    -- HP 200 - 300
    			inst.components.health.maxhealth = 1.00 * baseHealth + 100
    			inst.components.health:StartRegen(1 * baseHealth / 100, 5, false) 			--regeneration speed 1hp/ 3sec
    			inst.components.combat.damagemultiplier = 1.20 * baseDmgMult
    			inst.components.hunger:SetRate(1.5*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
    			inst.components.temperature.inherentinsulation = 30*6
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1 * walkSpeed)
    			inst.AnimState:SetBuild("fran_fed")
  		elseif inst.strength == "normal" then
  		    -- HP 150 - 250
    			inst.components.health.maxhealth = 	1.00 * baseHealth + 50
    			inst.components.health:StopRegen()
    			inst.components.combat.damagemultiplier = 1 * baseDmgMult
    			inst.components.hunger:SetRate(0.8*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = 0
    			inst.components.temperature.inherentinsulation = 30*4
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.0 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.0 * walkSpeed)
    			inst.AnimState:SetBuild("fran")
  		elseif inst.strength == "wimpy" then
  		    -- HP 70 - 150
    			inst.components.health.maxhealth = 0.70 * baseHealth - 00
    			inst.components.health:StopRegen()
    			inst.components.combat.damagemultiplier = 0.75 * baseDmgMult
    			inst.components.hunger:SetRate(0.7*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL*-1
    			inst.components.temperature.inherentinsulation = 30*2
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.9 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.9 * walkSpeed)
    			inst.AnimState:SetBuild("fran_starved")
  			
  		end
  		inst.components.health:SetPercent(health_percent)
  		inst.Light:Enable(false)
		
	elseif TheWorld.state.isnight then
  		if TheWorld.state.isfullmoon then
  		    -- HP 666 - 1332
    			inst.components.health.maxhealth = 495 + (6.3400 * (baseHealth-100))
    			inst.components.health:StartRegen(3 * baseHealth / 100 , 0.5, false) 			--regeneration speed 2-4hp/ 1sec
    			inst.components.combat.damagemultiplier = 1.5 * baseDmgMult
    			inst.components.hunger:SetRate(-5*TUNING.WILSON_HUNGER_RATE)
    			inst.components.sanity.dapperness = TUNING.DAPPERNESS_HUGE*-5
    			inst.components.temperature.inherentinsulation = 30*20
    			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.8 * walkSpeed)
    			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.8 * walkSpeed)
    			inst.AnimState:SetBuild("fran_nightmare")
    			
    			if commentMoonlight == 1 then
      				inst.components.talker:Say("It's full moon. I don't feel right...")
      				commentMoonlight = 0
  			end
  			
  		  elseif inst.strength == "mighty" then
  		      -- HP 250 - 400
      			inst.components.health.maxhealth = 1.5 * baseHealth + 100
      			inst.components.health:StartRegen(1 * baseHealth / 100, 2, false) 			--regeneration speed 1hp/ 2sec
      			inst.components.combat.damagemultiplier = 1.33 * baseDmgMult
      			inst.components.hunger:SetRate(1*TUNING.WILSON_HUNGER_RATE)
      			inst.components.sanity.dapperness = TUNING.DAPPERNESS_HUGE
      			inst.components.temperature.inherentinsulation = 30*6
      			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.4 * walkSpeed)
      			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.4 * walkSpeed)
      			inst.AnimState:SetBuild("fran_fed")
    		elseif inst.strength == "normal" then
    		    -- HP 200 - 350
      			inst.components.health.maxhealth = 1.5 * baseHealth + 50
      			inst.components.health:StartRegen(1 * baseHealth / 100, 3, false) 			--regeneration speed 1hp/ 3sec
      			inst.components.combat.damagemultiplier = 1 * baseDmgMult
      			inst.components.hunger:SetRate(0.8*TUNING.WILSON_HUNGER_RATE)
      			inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
      			inst.components.temperature.inherentinsulation = 30*4
      			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2 * walkSpeed)
      			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2 * walkSpeed)
      			inst.AnimState:SetBuild("fran_fed")
    		elseif inst.strength == "wimpy" then
    		    -- HP 100 - 200
      			inst.components.health.maxhealth = 1 * baseHealth + 0
      			inst.components.health:StopRegen()
      			inst.components.combat.damagemultiplier = 0.8 * baseDmgMult
      			inst.components.hunger:SetRate(0.7*TUNING.WILSON_HUNGER_RATE)
      			inst.components.sanity.dapperness = 0
      			inst.components.temperature.inherentinsulation = 30*2
      			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.0 * walkSpeed)
      			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.0 * walkSpeed)
      			inst.AnimState:SetBuild("fran_starved")
    		end
    		inst.components.health:SetPercent(health_percent)
    		inst.Light:Enable(true)
        inst.Light:SetRadius(10)
        inst.Light:SetFalloff(0.75)
        inst.Light:SetIntensity(.6)
        inst.Light:SetColour(235/255,12/255,12/255)
    end
    if tempCaveVar == true then
        inst.Light:Enable(true)
    end
    
    
	

end

-- hunger speech
local function onhungerchange(inst, data)

	if inst.strength == "mighty" then
		if inst.components.hunger.current < baseStomache * 0.7 then
			
			inst.strength = "normal"
			inst.components.talker:Say("The hunger has returned...")

		end
	elseif inst.strength == "wimpy" then
		if inst.components.hunger.current > baseStomache * 0.4 then

			inst.strength = "normal"
			inst.components.talker:Say("I need more!")

		end
	else
		if inst.components.hunger.current > baseStomache * 0.7 then
			inst.strength = "mighty"
			inst.components.talker:Say("I feel alive!")


		elseif inst.components.hunger.current < baseStomache * 0.4 then
			inst.strength = "wimpy"
			inst.components.talker:Say("Bloody hell... feels like I'm slowly fading away.")

		end
	end
	
	
	updatestats(inst)
end

-- Save experience points to file
local function onsave(inst, data)
    data.experience = inst.experience
end

local function onpreload(inst, data)
    if data ~= nil and data.experience ~= nil then
        inst.experience = data.experience
        local health_percent = inst.components.health:GetPercent()
        local hunger_percent = inst.components.hunger:GetPercent()
        levelUpComment = false
        onExperienceGain(inst)
        levelUpComment = true
        inst.components.health:SetPercent(health_percent)
        inst.components.hunger:SetPercent(hunger_percent)
    end
end



local function onbecameghost(inst)
    if inst._wasnomorph ~= nil then
        inst.strength = "normal"
        inst._wasnomorph = nil
        inst.talksoundoverride = nil
        inst.hurtsoundoverride = nil
        inst:RemoveEventCallback("hungerdelta", onhungerchange)
        inst:RemoveEventCallback("newstate", onnewstate)
        if FranNormal then
            randomValue = math.random(2)
            if randomValue == 1 then
                inst.components.talker:Say("Could have been worse. At least I didn't die on \"Easy\".")
            end
        end
    end
end

local function onbecamehuman(inst)
    if inst._wasnomorph == nil then
        inst.strength = "normal"
        inst._wasnomorph = inst.sg:HasStateTag("nomorph")
        inst.talksoundoverride = nil
        inst.hurtsoundoverride = nil
        inst:ListenForEvent("hungerdelta", onhungerchange)
        inst:ListenForEvent("newstate", onnewstate)
        onhungerchange(inst, nil, true)
    end
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

local start_inv =
{
	-- Put vampire attack 'item' here
    "redgem",
    "bloodsword",
    "nightmarefuel",
    "nightmarefuel",
    "nightmarefuel",
    "nightmarefuel",
    "franjournal",
--    "ruinshat",
}

local common_postinit = function(inst)
      -- choose which sounds this character will play
    inst.soundsname = "willow"
  
    -- a minimap icon must be specified
    inst.MiniMapEntity:SetIcon( "fran.tex" )
    
    --Tag
    inst:AddTag("blood_drinker")
    inst:AddTag("franV")
    inst:AddTag("nocturnal")
    inst:AddTag("smallblood_builder") -- Not needed?
    inst:AddTag("fran_builder")
    
end

local function master_postinit(inst)
    inst:AddComponent("reader")

    inst.experience = 0
    if FranEasy then
        inst.experience = 1000
        onExperienceGain(inst)
    end
    
    -- default hunger level
    inst.strength = "normal"
    inst.components.hunger.current = 125
    inst.components.hunger:SetMax(150)
    
    -- Emit light at night / Night vision
    -- WARNING doesn't work at day in caves!
    local light = inst.entity:AddLight()
    inst.Light:Enable(false)
    inst.Light:SetRadius(10)
    inst.Light:SetFalloff(0.75)
    inst.Light:SetIntensity(.6)
    inst.Light:SetColour(235/255,12/255,12/255)
    
    -- Stats varies day/night
    inst:ListenForEvent( "dusktime", function() updatestats(inst) end , TheWorld)  --change back to GetWorld() if it doesn't work
    inst:ListenForEvent( "daytime", function() updatestats(inst) end , TheWorld)
    inst:ListenForEvent( "nighttime", function() updatestats(inst) end , TheWorld)
    updatestats(inst)
    
    -- Sanity Changes
    inst.components.sanity.night_drain_mult = 0.5
    inst.components.sanity.neg_aura_mult = 1.1
    inst.components.sanity:SetMax(TUNING.WILLOW_SANITY)
    
    --Update hunger status
    inst:ListenForEvent("hungerdelta", onhungerchange)
    
    --  	--temp test
    --    inst:ListenForEvent("hungerdelta", onExperienceGain)
    inst:ListenForEvent("entity_death", function(world, data) entitydeathfn(inst, data) end, TheWorld)
    
    --------------------
    -- Set Fran Diet --
    --------------------

-- Something in here is not working, foodgroup is being set to default
-- print(FranDiet) -- returns "Blood" due to default in modinfo being "Blood", fixed.
-- Was always failing all conditions, perhaps a catch all would be in order
    local eater = inst.components.eater
    if FranDiet == "omnivore" then
        if TUNING.LIGHTNING_GOAT_DAMAGE then
            eater:SetDiet({FOODGROUP.OMNI, FOODTYPE.BLOOD})
        else
            inst.components.eater.foodprefs = {FOODGROUP.OMNI, FOODTYPE.BLOOD}
        end
    elseif FranDiet == "semi_carnivore" or FranDiet == "carnivore" then
        if TUNING.LIGHTNING_GOAT_DAMAGE then
            eater:SetDiet({FOODTYPE.BLOOD, FOODTYPE.MEAT})
        else
            inst.components.eater.foodprefs = {FOODTYPE.BLOOD, FOODTYPE.MEAT}
        end
    elseif FranDiet == "blood" then
        if TUNING.LIGHTNING_GOAT_DAMAGE then
            eater:SetDiet({FOODTYPE.BLOOD})
        else
            inst.components.eater.foodprefs = {FOODTYPE.BLOOD} --Change back to BLOOD once the correct way to do foodpref now is figured out.
        end
    print(inst.components.eater.foodprefs)
--------------------------------------------------------------------------------
    --else -- Catch all in case of failure set OMNI + BLOOD
	--inst.components.eater.foodprefs = {FOODTYPE.OMNI,FOODTYPE.BLOOD}
--------------------------------------------------------------------------------
    end
    inst.components.eater.strongstomach = true
    -- Diet done
    
    inst.OnSave = onsave
    inst.OnPreLoad = onpreload
    
    return inst
	
end

return MakePlayerCharacter("fran", prefabs, assets, common_postinit, master_postinit, start_inv)
