local assets =
{
    Asset("ANIM", "anim/book_fran.zip"),
    Asset("IMAGE", "images/inventoryimages/franjournal.tex"),
    Asset("ATLAS", "images/inventoryimages/franjournal.xml"),
}

local prefabs =
{
    "summonfran",
    "fran_book_fx",
}

local function doeffects(inst, pos)
    SpawnPrefab("statue_transition").Transform:SetPosition(pos:Get())
    SpawnPrefab("statue_transition_2").Transform:SetPosition(pos:Get())
end

local function canread(inst)
    return inst.components.sanity:GetMaxWithPenalty() >= TUNING.SHADOWWAXWELL_SANITY_PENALTY
end

local function onread(inst, reader, ignorecosts)

    --Ok you had everything. Make the image.
    local theta = math.random() * 2 * PI
    local pt = inst:GetPosition()
    local radius = math.random(3, 6)
    local offset = FindWalkableOffset(pt, theta, radius, 12, true)
    if offset then
        local image = SpawnPrefab("summonfran")
        local pos = pt + offset
        image.Transform:SetPosition(pos:Get())
        doeffects(inst, pos)
        image.components.follower:SetLeader(reader)
        local image = SpawnPrefab("summonfran")
        local pos = pt + offset
        image.Transform:SetPosition(pos:Get())
        doeffects(inst, pos)
        image.components.follower:SetLeader(reader)
        local image = SpawnPrefab("summonfran")
        local pos = pt + offset
        image.Transform:SetPosition(pos:Get())
        doeffects(inst, pos)
        image.components.follower:SetLeader(reader)
        if not ignorecosts then reader.components.health:DoDelta(-66) end
        if not ignorecosts then reader.components.hunger:DoDelta(-66) end
        if not ignorecosts then reader.components.sanity:DoDelta(-66) end
        if not ignorecosts then reader.components.sanity:RecalculatePenalty() end
        inst.SoundEmitter:PlaySound("dontstarve/maxwell/shadowmax_appear")
        return true
    end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("book_maxwell")
    inst.AnimState:SetBuild("book_fran")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "franjournal"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/franjournal.xml"

    -----------------------------------
    inst:AddComponent("inspectable")
    inst:AddComponent("book")
    inst.components.book.onread = onread

    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)

    MakeHauntableLaunch(inst)
    AddHauntableCustomReaction(inst, function(inst, haunter)
        if math.random() <= TUNING.HAUNT_CHANCE_OCCASIONAL then
            inst.components.book.onread(inst, haunter, true)
            inst.components.hauntable.hauntvalue = TUNING.HAUNT_MEDIUM
            return true
        end
        return false
    end, true, false, true)

    return inst
end

return Prefab("franjournal", fn, assets, prefabs)