/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J,\u0010\n\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lnet/minecraft/entity/FireproofItemLogic;", "", "()V", "customOnEntityUpdate", "", "entity", "Lnet/minecraft/entity/item/EntityItem;", "floatInLava", "update", "updatePortal", "customEntityMove", "type", "Lnet/minecraft/entity/MoverType;", "motionX", "", "motionY", "motionZ", "future-mc"})
public final class FireproofItemLogic {
    @NotNull
    public static final FireproofItemLogic INSTANCE;

    public final void update(@NotNull EntityItem entity) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        ItemStack itemStack = entity.func_92059_d();
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"entity.item");
        if (itemStack.func_190926_b()) {
            entity.func_70106_y();
        } else {
            double d5;
            double d4;
            double d3;
            double d6;
            boolean flag;
            if (!entity.field_70170_p.field_72995_K) {
                entity.func_70052_a(6, entity.func_184202_aL());
            }
            entity.func_70066_B();
            this.customOnEntityUpdate(entity);
            if (entity.field_145804_b > 0 && entity.field_145804_b != Short.MAX_VALUE) {
                EntityItem entityItem = entity;
                entityItem.field_145804_b += -1;
                int cfr_ignored_0 = entityItem.field_145804_b;
            }
            entity.field_70169_q = entity.field_70165_t;
            entity.field_70167_r = entity.field_70163_u;
            entity.field_70166_s = entity.field_70161_v;
            double d0 = entity.field_70159_w;
            double d1 = entity.field_70181_x;
            double d2 = entity.field_70179_y;
            if (entity.func_70055_a(Material.field_151587_i)) {
                this.floatInLava(entity);
            } else if (!entity.func_189652_ae()) {
                entity.field_70181_x -= (double)0.04f;
            }
            entity.field_70145_X = entity.field_70170_p.field_72995_K ? false : entity.func_145771_j(entity.field_70165_t, (entity.func_174813_aQ().field_72338_b + entity.func_174813_aQ().field_72337_e) / 2.0, entity.field_70161_v);
            this.customEntityMove(entity, MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            boolean bl = flag = (int)entity.field_70169_q != (int)entity.field_70165_t || (int)entity.field_70167_r != (int)entity.field_70163_u || (int)entity.field_70166_s != (int)entity.field_70161_v;
            if ((flag || entity.field_70173_aa % 25 == 0) && !entity.field_70170_p.field_72995_K) {
                entity.func_85054_d();
            }
            float f = 0.98f;
            if (entity.field_70122_E) {
                IBlockState underState;
                double d = entity.field_70165_t;
                boolean bl2 = false;
                double d7 = Math.floor(d);
                d = entity.func_174813_aQ().field_72338_b;
                bl2 = false;
                double d8 = Math.floor(d) - 1.0;
                d = entity.field_70161_v;
                bl2 = false;
                BlockPos underPos = new BlockPos(d7, d8, Math.floor(d));
                IBlockState iBlockState = underState = entity.field_70170_p.func_180495_p(underPos);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"underState");
                f = iBlockState.func_177230_c().getSlipperiness(underState, (IBlockAccess)entity.field_70170_p, underPos, (Entity)entity) * 0.98f;
            }
            entity.field_70159_w *= (double)f;
            entity.field_70181_x *= (double)0.98f;
            entity.field_70179_y *= (double)f;
            if (entity.field_70122_E) {
                entity.field_70181_x *= -0.5;
            }
            if (entity.field_70292_b != Short.MIN_VALUE) {
                EntityItem entityItem = entity;
                ++entityItem.field_70292_b;
                int cfr_ignored_1 = entityItem.field_70292_b;
            }
            entity.func_70072_I();
            if (!entity.field_70170_p.field_72995_K && (d6 = (d3 = entity.field_70159_w - d0) * d3 + (d4 = entity.field_70181_x - d1) * d4 + (d5 = entity.field_70179_y - d2) * d5) > 0.01) {
                entity.field_70160_al = true;
            }
            ItemStack item = entity.func_92059_d();
            if (!entity.field_70170_p.field_72995_K && entity.field_70292_b >= entity.lifespan) {
                int hook = ForgeEventFactory.onItemExpire((EntityItem)entity, (ItemStack)item);
                if (hook < 0) {
                    entity.func_70106_y();
                } else {
                    entity.lifespan += hook;
                }
            }
            ItemStack itemStack2 = item;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"item");
            if (itemStack2.func_190926_b()) {
                entity.func_70106_y();
            }
        }
    }

    private final void floatInLava(EntityItem entity) {
        entity.field_70159_w *= 0.95;
        entity.field_70181_x = entity.field_70181_x + (entity.field_70181_x < 0.06 ? 5.0E-4 : 0.0);
        entity.field_70179_y *= 0.95;
    }

    private final void customOnEntityUpdate(EntityItem entity) {
        entity.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        if (entity.func_184218_aH()) {
            Entity entity2 = entity.func_184187_bx();
            if (entity2 == null) {
                Intrinsics.throwNpe();
            }
            if (entity2.field_70128_L) {
                entity.func_184210_p();
            }
        }
        if (entity.field_184245_j > 0) {
            EntityItem entityItem = entity;
            entityItem.field_184245_j += -1;
            int cfr_ignored_0 = entityItem.field_184245_j;
        }
        entity.field_70141_P = entity.field_70140_Q;
        entity.field_70169_q = entity.field_70165_t;
        entity.field_70167_r = entity.field_70163_u;
        entity.field_70166_s = entity.field_70161_v;
        entity.field_70127_C = entity.field_70125_A;
        entity.field_70126_B = entity.field_70177_z;
        this.updatePortal(entity);
        entity.func_174830_Y();
        entity.func_70072_I();
        if (entity.field_70163_u < -64.0 && !Loader.isModLoaded((String)"cubicchunks")) {
            entity.func_70076_C();
        }
        entity.field_70148_d = false;
        entity.field_70170_p.field_72984_F.func_76319_b();
    }

    private final void updatePortal(EntityItem entity) {
        if (entity.field_70170_p instanceof WorldServer) {
            if (entity.field_71087_bX) {
                World world = entity.field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"entity.world");
                MinecraftServer server = world.func_73046_m();
                int i2 = entity.func_82145_z();
                MinecraftServer minecraftServer = server;
                if (minecraftServer == null) {
                    Intrinsics.throwNpe();
                }
                if (minecraftServer.func_71255_r() && !entity.func_184218_aH()) {
                    int n = entity.field_82153_h;
                    entity.field_82153_h = n + 1;
                    if (n >= i2) {
                        entity.field_70170_p.field_72984_F.func_76320_a("portal");
                        entity.field_82153_h = i2;
                        entity.field_71088_bW = entity.func_82147_ab();
                        WorldProvider worldProvider = entity.field_70170_p.field_73011_w;
                        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"entity.world.provider");
                        DimensionType dimensionType = worldProvider.func_186058_p();
                        Intrinsics.checkExpressionValueIsNotNull((Object)dimensionType, (String)"entity.world.provider.dimensionType");
                        int j = dimensionType.func_186068_a() == -1 ? 0 : -1;
                        entity.func_184204_a(j);
                        entity.field_71087_bX = false;
                    }
                }
            } else {
                if (entity.field_82153_h > 0) {
                    entity.field_82153_h -= 4;
                }
                if (entity.field_82153_h < 0) {
                    entity.field_82153_h = 0;
                }
            }
            entity.func_184173_H();
            entity.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    private final void customEntityMove(EntityItem $this$customEntityMove, MoverType type, double motionX, double motionY, double motionZ) {
        double x = motionX;
        double y = motionY;
        double z = motionZ;
        if ($this$customEntityMove.field_70145_X) {
            $this$customEntityMove.func_174826_a($this$customEntityMove.func_174813_aQ().func_72317_d(motionX, motionY, motionZ));
            $this$customEntityMove.func_174829_m();
        } else {
            IBlockState iblockstate;
            boolean flag;
            if (type == MoverType.PISTON) {
                boolean bl;
                World world = $this$customEntityMove.field_70170_p;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                long i2 = world.func_82737_E();
                if (i2 != $this$customEntityMove.field_191506_aJ) {
                    Arrays.fill($this$customEntityMove.field_191505_aI, 0.0);
                    $this$customEntityMove.field_191506_aJ = i2;
                }
                if (x != 0.0) {
                    int j = EnumFacing.Axis.X.ordinal();
                    double d0 = MathHelper.func_151237_a((double)(x + $this$customEntityMove.field_191505_aI[j]), (double)-0.51, (double)0.51);
                    x = d0 - $this$customEntityMove.field_191505_aI[j];
                    $this$customEntityMove.field_191505_aI[j] = d0;
                    bl = false;
                    if (Math.abs(x) <= (double)1.0E-5f) {
                        return;
                    }
                } else if (y != 0.0) {
                    int l4 = EnumFacing.Axis.Y.ordinal();
                    double d12 = MathHelper.func_151237_a((double)(y + $this$customEntityMove.field_191505_aI[l4]), (double)-0.51, (double)0.51);
                    y = d12 - $this$customEntityMove.field_191505_aI[l4];
                    $this$customEntityMove.field_191505_aI[l4] = d12;
                    bl = false;
                    if (Math.abs(y) <= (double)1.0E-5f) {
                        return;
                    }
                } else {
                    if (z == 0.0) {
                        return;
                    }
                    int i5 = EnumFacing.Axis.Z.ordinal();
                    double d13 = MathHelper.func_151237_a((double)(z + $this$customEntityMove.field_191505_aI[i5]), (double)-0.51, (double)0.51);
                    z = d13 - $this$customEntityMove.field_191505_aI[i5];
                    $this$customEntityMove.field_191505_aI[i5] = d13;
                    bl = false;
                    if (Math.abs(z) <= (double)1.0E-5f) {
                        return;
                    }
                }
            }
            $this$customEntityMove.field_70170_p.field_72984_F.func_76320_a("move");
            if ($this$customEntityMove.field_70134_J) {
                $this$customEntityMove.field_70134_J = false;
                x *= 0.25;
                y *= (double)0.05f;
                z *= 0.25;
                $this$customEntityMove.field_70159_w = 0.0;
                $this$customEntityMove.field_70181_x = 0.0;
                $this$customEntityMove.field_70179_y = 0.0;
            }
            double d2 = x;
            double d3 = y;
            double d4 = z;
            if ((type == MoverType.SELF || type == MoverType.PLAYER) && $this$customEntityMove.field_70122_E && $this$customEntityMove.func_70093_af() && $this$customEntityMove instanceof EntityPlayer) {
                while (x != 0.0 && $this$customEntityMove.field_70170_p.func_184144_a((Entity)$this$customEntityMove, $this$customEntityMove.func_174813_aQ().func_72317_d(x, (double)(-$this$customEntityMove.field_70138_W), 0.0)).isEmpty()) {
                    x = x < 0.05 && x >= -0.05 ? 0.0 : (x > 0.0 ? (x -= 0.05) : (x += 0.05));
                    d2 = x;
                }
                while (z != 0.0 && $this$customEntityMove.field_70170_p.func_184144_a((Entity)$this$customEntityMove, $this$customEntityMove.func_174813_aQ().func_72317_d(0.0, (double)(-$this$customEntityMove.field_70138_W), z)).isEmpty()) {
                    z = z < 0.05 && z >= -0.05 ? 0.0 : (z > 0.0 ? (z -= 0.05) : (z += 0.05));
                    d4 = z;
                }
                while (x != 0.0 && z != 0.0 && $this$customEntityMove.field_70170_p.func_184144_a((Entity)$this$customEntityMove, $this$customEntityMove.func_174813_aQ().func_72317_d(x, (double)(-$this$customEntityMove.field_70138_W), z)).isEmpty()) {
                    x = x < 0.05 && x >= -0.05 ? 0.0 : (x > 0.0 ? (x -= 0.05) : (x += 0.05));
                    d2 = x;
                    z = z < 0.05 && z >= -0.05 ? 0.0 : (z > 0.0 ? (z -= 0.05) : (z += 0.05));
                    d4 = z;
                }
            }
            List list1 = $this$customEntityMove.field_70170_p.func_184144_a((Entity)$this$customEntityMove, $this$customEntityMove.func_174813_aQ().func_72321_a(x, y, z));
            AxisAlignedBB axisalignedbb = $this$customEntityMove.func_174813_aQ();
            if (y != 0.0) {
                int l = list1.size();
                for (int k = 0; k < l; ++k) {
                    y = ((AxisAlignedBB)list1.get(k)).func_72323_b($this$customEntityMove.func_174813_aQ(), y);
                }
                $this$customEntityMove.func_174826_a($this$customEntityMove.func_174813_aQ().func_72317_d(0.0, y, 0.0));
            }
            if (x != 0.0) {
                int l5 = list1.size();
                for (int j5 = 0; j5 < l5; ++j5) {
                    x = ((AxisAlignedBB)list1.get(j5)).func_72316_a($this$customEntityMove.func_174813_aQ(), x);
                }
                if (x != 0.0) {
                    $this$customEntityMove.func_174826_a($this$customEntityMove.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
                }
            }
            if (z != 0.0) {
                int i6 = list1.size();
                for (int k5 = 0; k5 < i6; ++k5) {
                    z = ((AxisAlignedBB)list1.get(k5)).func_72322_c($this$customEntityMove.func_174813_aQ(), z);
                }
                if (z != 0.0) {
                    $this$customEntityMove.func_174826_a($this$customEntityMove.func_174813_aQ().func_72317_d(0.0, 0.0, z));
                }
            }
            boolean bl = flag = $this$customEntityMove.field_70122_E || d3 != y && d3 < 0.0;
            if ($this$customEntityMove.field_70138_W > 0.0f && flag && (d2 != x || d4 != z)) {
                double d14 = x;
                double d6 = y;
                double d7 = z;
                AxisAlignedBB axisalignedbb1 = $this$customEntityMove.func_174813_aQ();
                $this$customEntityMove.func_174826_a(axisalignedbb);
                y = $this$customEntityMove.field_70138_W;
                List list2 = $this$customEntityMove.field_70170_p.func_184144_a((Entity)$this$customEntityMove, $this$customEntityMove.func_174813_aQ().func_72321_a(d2, y, d4));
                AxisAlignedBB axisalignedbb2 = $this$customEntityMove.func_174813_aQ();
                AxisAlignedBB axisalignedbb3 = axisalignedbb2.func_72321_a(d2, 0.0, d4);
                double d8 = y;
                int k1 = list2.size();
                for (int j1 = 0; j1 < k1; ++j1) {
                    d8 = ((AxisAlignedBB)list2.get(j1)).func_72323_b(axisalignedbb3, d8);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, d8, 0.0);
                double d18 = d2;
                int i2 = list2.size();
                for (int l1 = 0; l1 < i2; ++l1) {
                    d18 = ((AxisAlignedBB)list2.get(l1)).func_72316_a(axisalignedbb2, d18);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(d18, 0.0, 0.0);
                double d19 = d4;
                int k2 = list2.size();
                for (int j2 = 0; j2 < k2; ++j2) {
                    d19 = ((AxisAlignedBB)list2.get(j2)).func_72322_c(axisalignedbb2, d19);
                }
                axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, 0.0, d19);
                AxisAlignedBB axisalignedbb4 = $this$customEntityMove.func_174813_aQ();
                double d20 = y;
                int i3 = list2.size();
                for (int l2 = 0; l2 < i3; ++l2) {
                    d20 = ((AxisAlignedBB)list2.get(l2)).func_72323_b(axisalignedbb4, d20);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, d20, 0.0);
                double d21 = d2;
                int k3 = list2.size();
                for (int j3 = 0; j3 < k3; ++j3) {
                    d21 = ((AxisAlignedBB)list2.get(j3)).func_72316_a(axisalignedbb4, d21);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(d21, 0.0, 0.0);
                double d22 = d4;
                int i4 = list2.size();
                for (int l3 = 0; l3 < i4; ++l3) {
                    d22 = ((AxisAlignedBB)list2.get(l3)).func_72322_c(axisalignedbb4, d22);
                }
                axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, 0.0, d22);
                double d23 = d18 * d18 + d19 * d19;
                double d9 = d21 * d21 + d22 * d22;
                if (d23 > d9) {
                    x = d18;
                    z = d19;
                    y = -d8;
                    $this$customEntityMove.func_174826_a(axisalignedbb2);
                } else {
                    x = d21;
                    z = d22;
                    y = -d20;
                    $this$customEntityMove.func_174826_a(axisalignedbb4);
                }
                int k4 = list2.size();
                for (int j4 = 0; j4 < k4; ++j4) {
                    y = ((AxisAlignedBB)list2.get(j4)).func_72323_b($this$customEntityMove.func_174813_aQ(), y);
                }
                $this$customEntityMove.func_174826_a($this$customEntityMove.func_174813_aQ().func_72317_d(0.0, y, 0.0));
                if (d14 * d14 + d7 * d7 >= x * x + z * z) {
                    x = d14;
                    y = d6;
                    z = d7;
                    $this$customEntityMove.func_174826_a(axisalignedbb1);
                }
            }
            $this$customEntityMove.field_70170_p.field_72984_F.func_76319_b();
            $this$customEntityMove.field_70170_p.field_72984_F.func_76320_a("rest");
            $this$customEntityMove.func_174829_m();
            $this$customEntityMove.field_70123_F = d2 != x || d4 != z;
            $this$customEntityMove.field_70124_G = d3 != y;
            $this$customEntityMove.field_70122_E = $this$customEntityMove.field_70124_G && d3 < 0.0;
            $this$customEntityMove.field_70132_H = $this$customEntityMove.field_70123_F || $this$customEntityMove.field_70124_G;
            int j6 = MathHelper.func_76128_c((double)$this$customEntityMove.field_70165_t);
            int i1 = MathHelper.func_76128_c((double)($this$customEntityMove.field_70163_u - (double)0.2f));
            int k6 = MathHelper.func_76128_c((double)$this$customEntityMove.field_70161_v);
            BlockPos blockpos = new BlockPos(j6, i1, k6);
            IBlockState iBlockState = iblockstate = $this$customEntityMove.field_70170_p.func_180495_p(blockpos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"iblockstate");
            if (iBlockState.func_185904_a() == Material.field_151579_a) {
                IBlockState iblockstate1;
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iBlockState2 = iblockstate1 = $this$customEntityMove.field_70170_p.func_180495_p(blockpos1);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"iblockstate1");
                Block block1 = iBlockState2.func_177230_c();
                if (block1 instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate) {
                    iblockstate = iblockstate1;
                    BlockPos blockPos = blockpos1;
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"blockpos1");
                    blockpos = blockPos;
                }
            }
            $this$customEntityMove.func_184231_a(y, $this$customEntityMove.field_70122_E, iblockstate, blockpos);
            if (d2 != x) {
                $this$customEntityMove.field_70159_w = 0.0;
            }
            if (d4 != z) {
                $this$customEntityMove.field_70179_y = 0.0;
            }
            Block block = iblockstate.func_177230_c();
            if (d3 != y) {
                block.func_176216_a($this$customEntityMove.field_70170_p, (Entity)$this$customEntityMove);
            }
            try {
                $this$customEntityMove.func_145775_I();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
                $this$customEntityMove.func_85029_a(crashreportcategory);
                throw (Throwable)new ReportedException(crashreport);
            }
            boolean flag1 = $this$customEntityMove.func_70026_G();
            if (flag1 && $this$customEntityMove.func_70027_ad()) {
                $this$customEntityMove.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + ($this$customEntityMove.field_70146_Z.nextFloat() - $this$customEntityMove.field_70146_Z.nextFloat()) * 0.4f);
            }
            $this$customEntityMove.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    private FireproofItemLogic() {
    }

    static {
        FireproofItemLogic fireproofItemLogic;
        INSTANCE = fireproofItemLogic = new FireproofItemLogic();
    }
}

