/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world.gen.feature;

import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import org.jetbrains.annotations.NotNull;
import sun.reflect.Reflection;
import thedarkcolour.core.util.ExtensionsKt;
import thedarkcolour.core.util.UtilKt;
import thedarkcolour.futuremc.block.buzzybees.BeeHiveBlock;
import thedarkcolour.futuremc.config.FConfig;
import thedarkcolour.futuremc.entity.bee.EntityBee;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.tile.BeeHiveTile;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J(\u0010#\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0007J.\u0010$\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0018\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010&\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010'\u001a\u00020\u001dR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lthedarkcolour/futuremc/world/gen/feature/BeeNestGenerator;", "", "()V", "BEE_NEST", "Lnet/minecraft/block/state/IBlockState;", "kotlin.jvm.PlatformType", "getBEE_NEST", "()Lnet/minecraft/block/state/IBlockState;", "BIOMES_AND_CHANCES", "Lit/unimi/dsi/fastutil/objects/Object2DoubleMap;", "Lnet/minecraft/util/ResourceLocation;", "getBIOMES_AND_CHANCES", "()Lit/unimi/dsi/fastutil/objects/Object2DoubleMap;", "VALID_OFFSETS", "", "Lnet/minecraft/util/EnumFacing;", "getVALID_OFFSETS", "()[Lnet/minecraft/util/EnumFacing;", "[Lnet/minecraft/util/EnumFacing;", "cannotGenerate", "", "worldIn", "Lnet/minecraft/world/World;", "rand", "Ljava/util/Random;", "pos", "Lnet/minecraft/util/math/BlockPos;", "fastCannotGenerate", "generateBeeNestsForBigTrees", "", "position", "height", "", "tree", "Lnet/minecraft/world/gen/feature/WorldGenAbstractTree;", "generateBeeNestsForSmallTrees", "generateBeeNestsForSwampTrees", "hasNoFlowersNearby", "placeBeeHive", "refresh", "future-mc"})
public final class BeeNestGenerator {
    private static final IBlockState BEE_NEST;
    @NotNull
    private static final EnumFacing[] VALID_OFFSETS;
    @NotNull
    private static final Object2DoubleMap<ResourceLocation> BIOMES_AND_CHANCES;
    @NotNull
    public static final BeeNestGenerator INSTANCE;

    public final IBlockState getBEE_NEST() {
        return BEE_NEST;
    }

    @NotNull
    public final EnumFacing[] getVALID_OFFSETS() {
        return VALID_OFFSETS;
    }

    @NotNull
    public final Object2DoubleMap<ResourceLocation> getBIOMES_AND_CHANCES() {
        return BIOMES_AND_CHANCES;
    }

    @JvmStatic
    public static final void generateBeeNestsForSmallTrees(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos position, int height) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (INSTANCE.cannotGenerate(worldIn, rand, position)) {
            return;
        }
        EnumFacing offset = VALID_OFFSETS[rand.nextInt(3)];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(position.func_177958_n(), position.func_177956_o() + height - 4, position.func_177952_p()).func_189536_c(offset);
        IBlockAccess iBlockAccess = (IBlockAccess)worldIn;
        BlockPos.MutableBlockPos mutableBlockPos = pos;
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableBlockPos, (String)"pos");
        if (ExtensionsKt.isAir(iBlockAccess, (BlockPos)mutableBlockPos)) {
            IBlockAccess iBlockAccess2 = (IBlockAccess)worldIn;
            BlockPos.MutableBlockPos mutableBlockPos2 = pos.func_189536_c(EnumFacing.SOUTH);
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableBlockPos2, (String)"pos.move(EnumFacing.SOUTH)");
            if (ExtensionsKt.isAir(iBlockAccess2, (BlockPos)mutableBlockPos2)) {
                BlockPos.MutableBlockPos mutableBlockPos3 = pos.func_189536_c(EnumFacing.NORTH);
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableBlockPos3, (String)"pos.move(EnumFacing.NORTH)");
                INSTANCE.placeBeeHive(worldIn, rand, (BlockPos)mutableBlockPos3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void generateBeeNestsForBigTrees(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos position, int height, @NotNull WorldGenAbstractTree tree) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        if (INSTANCE.cannotGenerate(worldIn, rand, position)) {
            return;
        }
        EnumFacing direction = VALID_OFFSETS[rand.nextInt(3)];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(position.func_177972_a(direction));
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void i2;
            if (!ExtensionsKt.isAir((IBlockAccess)worldIn, (BlockPos)ExtensionsKt.move(pos, 0, 1, 0)) && tree.isReplaceable(worldIn, (BlockPos)ExtensionsKt.move(pos, 0, -1, 0)) && tree.isReplaceable(worldIn, (BlockPos)ExtensionsKt.move(pos, 0, 0, 1))) {
                worldIn.func_175698_g((BlockPos)pos);
                INSTANCE.placeBeeHive(worldIn, rand, (BlockPos)ExtensionsKt.move(pos, 0, 0, -1));
            }
            ++i2;
        }
    }

    public final void generateBeeNestsForSwampTrees(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos position, int height, @NotNull WorldGenAbstractTree tree) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
        if (this.cannotGenerate(worldIn, rand, position)) {
            return;
        }
    }

    public final boolean fastCannotGenerate(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (!FConfig.INSTANCE.getBuzzyBees().bee.enabled) {
            return true;
        }
        Biome biome = worldIn.func_180494_b(pos);
        double d = rand.nextDouble();
        Biome biome2 = biome;
        Intrinsics.checkExpressionValueIsNotNull((Object)biome2, (String)"biome");
        return d > UtilKt.getDoubleOrDefault(BIOMES_AND_CHANCES, biome2.getRegistryName(), 0.0);
    }

    public final boolean cannotGenerate(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (Intrinsics.areEqual((Object)Reflection.getCallerClass((int)4), BiomeDecorator.class) ^ true && this.hasNoFlowersNearby(worldIn, pos)) {
            return true;
        }
        return this.fastCannotGenerate(worldIn, rand, pos);
    }

    private final boolean hasNoFlowersNearby(World worldIn, BlockPos pos) {
        int endZ;
        int endY;
        int endX;
        int startZ;
        int startY;
        int startX = pos.func_177958_n() - 2;
        if (worldIn.func_175663_a(startX, startY = pos.func_177958_n() - 1, startZ = pos.func_177952_p() - 2, endX = pos.func_177958_n() + 2, endY = pos.func_177958_n() + 1, endZ = pos.func_177952_p() + 2, true)) {
            for (BlockPos.MutableBlockPos pos1 : BlockPos.func_191531_b((int)startX, (int)startY, (int)startZ, (int)endX, (int)endY, (int)endZ)) {
                if (!EntityBee.isFlowerValid(worldIn.func_180495_p((BlockPos)pos1))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void placeBeeHive(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        worldIn.func_175656_a(pos, BEE_NEST);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BeeHiveTile) {
            int n = 0;
            int n2 = 2;
            while (n <= n2) {
                void j;
                EntityBee bee = new EntityBee(worldIn);
                ((BeeHiveTile)te).tryEnterHive(bee, false, rand.nextInt(599));
                ++j;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void refresh() {
        BIOMES_AND_CHANCES.clear();
        for (String entry : FConfig.INSTANCE.getBuzzyBees().validBiomesForBeeNest) {
            String[] parts;
            void $this$toTypedArray$iv;
            Object object = entry;
            String string = ":";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            object = string.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ResourceLocation loc = new ResourceLocation(parts[0], parts[1]);
            string = parts[2];
            n = 0;
            ((Map)BIOMES_AND_CHANCES).put(loc, Double.parseDouble(string));
        }
    }

    private BeeNestGenerator() {
    }

    static {
        BeeNestGenerator beeNestGenerator;
        INSTANCE = beeNestGenerator = new BeeNestGenerator();
        BEE_NEST = FBlocks.INSTANCE.getBEE_NEST().func_176223_P().func_177226_a((IProperty)BeeHiveBlock.FACING, (Comparable)EnumFacing.SOUTH);
        VALID_OFFSETS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
        BIOMES_AND_CHANCES = (Object2DoubleMap)new Object2DoubleOpenHashMap();
    }
}

