VehicleFruitHud = {};
VehicleFruitHud.metadata = {
	interface = " FS19 ...",
	title = " VehicleFruit Hud",
	notes = " setzt Name/Prozent/Kapazität zusätzlich ins VehicleFruit Hud und ändert Schema",
	author = " (by HappyLooser)",
	version = " v0.45 Beta",	
	datum = " 20.11.2018",
	update = " 04.12.2018",
	web = " no",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

function VehicleFruitHud:loadMap(name)
	g_currentMission.vehicleFruitHud = VehicleFruitHud;	
	print("---loading".. tostring(VehicleFruitHud.metadata.title).. tostring(VehicleFruitHud.metadata.version).. tostring(VehicleFruitHud.metadata.author).. "---")
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return;end;
	VehicleFruitHud.color = {255/255, 255/255,   0/255, 1.00};
	VehicleFruitHud.prozent = true;
	VehicleFruitHud.capacity = true;
	VehicleFruitHud.name = true;
	VehicleFruitHud.txtBold = true;
	VehicleFruitHud.txtSize = g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize; --not active
	VehicleFruitHud.namePos = 1;
	VehicleFruitHud.lastSchemaX = 0;
	VehicleFruitHud.namePosAutoSize = false;
	VehicleFruitHud.schemaPos = 1;
	VehicleFruitHud.schemaZoom = 1.0;
	VehicleFruitHud.schemaFixY = 0.005000;
	VehicleFruitHud.schemaFixX = false;
	VehicleFruitHud.settingsDir = getUserProfileAppPath().. "modsSettings/VehicleFruitHud/";	
	VehicleFruitHud:setGetCfg(true);
end;

function VehicleFruitHud:deleteMap()
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return;end;
	VehicleFruitHud:setGetCfg(false);	
end;

function VehicleFruitHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VehicleFruitHud:keyEvent(unicode, sym, modifier, isDown)	
end;

function VehicleFruitHud:update(dt)	
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return;end;
	if VehicleFruitHud.schemaPos > 1 and g_currentMission.hud.vehicleSchema.overlay.y > 0.7 then VehicleFruitHud:fixSchemaPos();end;
end;

function VehicleFruitHud:draw(dt)
	if g_server ~= nil and g_client ~= nil and g_dedicatedServerInfo ~= nil then return;end;
	if g_currentMission.hud.fillLevelsDisplay.vehicle ~= nil and g_currentMission.hud.showVehicleSchema then		
		setTextColor(unpack(VehicleFruitHud.color));
		setTextBold(VehicleFruitHud.txtBold);
		if g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer ~= nil and type(g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer) == "table" and #g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer > 0 then
			local frameHeight = g_currentMission.hud.fillLevelsDisplay.frameHeight;
			for a=1, #g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer do
				if g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer[a] ~= nil then					
					local capacity = g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer[a].capacity or 0;
					local fillType = g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer[a].fillType or 0;
					local fillLevel = g_currentMission.hud.fillLevelsDisplay.fillLevelBuffer[a].fillLevel or 0;
					local percent = VehicleFruitHud:getProzentString(fillLevel, capacity);
					--local descFruit = g_currentMission.fruitTypeManager.fruitTypes[fillType]; --later fruitTypeIndexToFillType a test convertFruitViaFill
					local descFill = g_currentMission.fillTypeManager.fillTypes[fillType];
					if descFruit ~= nil and descFill ~= nil then 
						--if descFruit ~= descFill then descFill = descFruit;end;
					end;
					if descFill ~= nil then						
						local name = descFill.title or descFill.name;
						local txtHeight = getTextHeight(g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring("Gg"));
						if capacity > 0 then 
							setTextAlignment(2);
							if VehicleFruitHud.capacity then 
								if VehicleFruitHud.namePos == 3 then
									renderText(g_currentMission.hud.fillLevelsDisplay.origX+g_currentMission.hud.fillLevelsDisplay.overlay.width, g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1))+txtHeight*2.5, g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(capacity));
								elseif VehicleFruitHud.namePos ~= 5 then
									renderText(g_currentMission.hud.fillLevelsDisplay.origX+g_currentMission.hud.fillLevelsDisplay.overlay.width, g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1))-txtHeight, g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(capacity));
								end;
							end;
						
							if fillLevel > 0 then 
								setTextAlignment(0);
								if VehicleFruitHud.prozent then 
									if VehicleFruitHud.namePos == 3 or VehicleFruitHud.namePos == 5 then
										setTextAlignment(0);
										renderText(g_currentMission.hud.fillLevelsDisplay.origX+(g_currentMission.hud.fillLevelsDisplay.overlay.width/5), g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1))+txtHeight*1.5, g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(percent).. "%");
									else
										renderText(g_currentMission.hud.fillLevelsDisplay.origX+(g_currentMission.hud.fillLevelsDisplay.overlay.width/5), g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1))-txtHeight, g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(percent).. "%");
									end;
								end;
							end;
						end;
						if not string.find(name, "Unknown") then							
							if VehicleFruitHud.namePos == 1 then
								setTextAlignment(2);
								renderText(g_currentMission.hud.fillLevelsDisplay.origX, g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1)), g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(name));
							elseif VehicleFruitHud.namePos == 2 then
								local optiSize = VehicleFruitHud:getOptimalSize(g_currentMission.hud.fillLevelsDisplay.overlay.width-getTextWidth(g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(string.format("%1.f", "".. fillLevel))), tostring(name), g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize);
								if not VehicleFruitHud.namePosAutoSize then optiSize = g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize;end;
								setTextAlignment(0);
								renderText(g_currentMission.hud.fillLevelsDisplay.origX+(g_currentMission.hud.fillLevelsDisplay.overlay.width/5), g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1))+txtHeight*1.5, optiSize, tostring(name));
							elseif VehicleFruitHud.namePos == 3 then
								setTextAlignment(0);
								renderText(g_currentMission.hud.fillLevelsDisplay.origX+(g_currentMission.hud.fillLevelsDisplay.overlay.width/5), g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1))-txtHeight, g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(name));
							elseif VehicleFruitHud.namePos == 4 or VehicleFruitHud.namePos == 5 then
								local optiSize = VehicleFruitHud:getOptimalSize(g_currentMission.hud.fillLevelsDisplay.overlay.width-getTextWidth(g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(capacity)), tostring(name), g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize);
								if VehicleFruitHud.namePos == 4 or not VehicleFruitHud.namePosAutoSize then optiSize = g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize;end;
								setTextAlignment(0);
								renderText(g_currentMission.hud.fillLevelsDisplay.origX+(g_currentMission.hud.fillLevelsDisplay.overlay.width/5), g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1))+txtHeight*2.5, optiSize, tostring(name));
								if VehicleFruitHud.namePos == 5 then
									if VehicleFruitHud.capacity and capacity > 0 then 
										setTextAlignment(2);
										renderText(g_currentMission.hud.fillLevelsDisplay.origX+g_currentMission.hud.fillLevelsDisplay.overlay.width, g_currentMission.hud.fillLevelsDisplay.origY+(frameHeight*(a-1))+txtHeight*2.5, g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize, tostring(capacity));
									end;									
								end;								
							end;
						end;
					end;
				end;
			end;
		end;
		if VehicleFruitHud.schemaPos > 3 and g_currentMission.hud.vehicleSchema.overlay.y > 0.7 then VehicleFruitHud:fixSchemaPos();end;
		--respect settings for other mods
		setTextAlignment(0);
		setTextColor(1, 1, 1, 1);
		setTextBold(false);
		--respect settings for other mods
	end;
end;
addModEventListener(VehicleFruitHud);

function VehicleFruitHud:getProzentString(fill, capacity)	
	return string.format("%1.0f", "".. tonumber(fill)/tonumber(capacity)*100);
end;

function VehicleFruitHud:setGetCfg(loadCfg)
	createFolder(getUserProfileAppPath().. "modsSettings/");
	createFolder(VehicleFruitHud.settingsDir);
	local file = VehicleFruitHud.settingsDir.. "vehicleFruitHudSettings.xml";
	local Xml = nil;
	if not fileExists(file) or not loadCfg then
		Xml = createXMLFile("VehicleFruitHud_XML", file, "vehicleFruitHudSettings");
		local groupNameTag = ("vehicleFruitHudSettings.global(%d)"):format(0);
		setXMLBool(Xml, groupNameTag.. "#prozent", VehicleFruitHud.prozent);
		setXMLBool(Xml, groupNameTag.. "#capacity", VehicleFruitHud.capacity);
		setXMLBool(Xml, groupNameTag.. "#name", VehicleFruitHud.name);
		setXMLBool(Xml, groupNameTag.. "#txtBold", VehicleFruitHud.txtBold);
		setXMLBool(Xml, groupNameTag.. "#namePosAutoSize", VehicleFruitHud.namePosAutoSize);
		setXMLInt(Xml, groupNameTag.. "#namePos", VehicleFruitHud.namePos);
		setXMLFloat(Xml, groupNameTag.. "#colorR", VehicleFruitHud.color[1]);
		setXMLFloat(Xml, groupNameTag.. "#colorG", VehicleFruitHud.color[2]);
		setXMLFloat(Xml, groupNameTag.. "#colorB", VehicleFruitHud.color[3]);
		setXMLFloat(Xml, groupNameTag.. "#colorA", VehicleFruitHud.color[4]);
		setXMLFloat(Xml, groupNameTag.. "#schemaZoom", VehicleFruitHud.schemaZoom);
		setXMLFloat(Xml, groupNameTag.. "#schemaFixY", VehicleFruitHud.schemaFixY);
		setXMLBool(Xml, groupNameTag.. "#schemaFixX", VehicleFruitHud.schemaFixX);
		setXMLInt(Xml, groupNameTag.. "#schemaPos", VehicleFruitHud.schemaPos);
		saveXMLFile(Xml);
	else	
		Xml = loadXMLFile("VehicleFruitHud_XML", file, "vehicleFruitHudSettings");
		local groupNameTag = ("vehicleFruitHudSettings.global(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.. "#prozent") ~= nil then VehicleFruitHud.prozent = getXMLBool(Xml, groupNameTag.. "#prozent");end;
		if getXMLBool(Xml, groupNameTag.. "#capacity") ~= nil then VehicleFruitHud.capacity = getXMLBool(Xml, groupNameTag.. "#capacity");end;
		if getXMLBool(Xml, groupNameTag.. "#name") ~= nil then VehicleFruitHud.name = getXMLBool(Xml, groupNameTag.. "#name");end;
		if getXMLBool(Xml, groupNameTag.. "#txtBold") ~= nil then VehicleFruitHud.txtBold = getXMLBool(Xml, groupNameTag.. "#txtBold");end;
		if getXMLBool(Xml, groupNameTag.. "#namePosAutoSize") ~= nil then VehicleFruitHud.namePosAutoSize = getXMLBool(Xml, groupNameTag.. "#namePosAutoSize");end;
		if getXMLInt(Xml, groupNameTag.. "#namePos") then VehicleFruitHud.namePos = getXMLInt(Xml, groupNameTag.. "#namePos");end;
		if getXMLFloat(Xml, groupNameTag.. "#colorR") then VehicleFruitHud.color[1] = getXMLFloat(Xml, groupNameTag.. "#colorR");end;
		if getXMLFloat(Xml, groupNameTag.. "#colorG") then VehicleFruitHud.color[2] = getXMLFloat(Xml, groupNameTag.. "#colorG");end;
		if getXMLFloat(Xml, groupNameTag.. "#colorB") then VehicleFruitHud.color[3] = getXMLFloat(Xml, groupNameTag.. "#colorB");end;
		if getXMLFloat(Xml, groupNameTag.. "#colorA") then VehicleFruitHud.color[4] = getXMLFloat(Xml, groupNameTag.. "#colorA");end;
		if getXMLInt(Xml, groupNameTag.. "#schemaPos") then VehicleFruitHud.schemaPos = getXMLInt(Xml, groupNameTag.. "#schemaPos");end;
		if getXMLFloat(Xml, groupNameTag.. "#schemaZoom") then VehicleFruitHud.schemaZoom = getXMLFloat(Xml, groupNameTag.. "#schemaZoom");end;	
		if getXMLFloat(Xml, groupNameTag.. "#schemaFixY") then VehicleFruitHud.schemaFixY = getXMLFloat(Xml, groupNameTag.. "#schemaFixY");end;
		if getXMLBool(Xml, groupNameTag.. "#schemaFixX") ~= nil then VehicleFruitHud.schemaFixX = getXMLBool(Xml, groupNameTag.. "#schemaFixX");end;
	end;
	if loadCfg then
		if VehicleFruitHud.schemaPos > 1 or VehicleFruitHud.schemaZoom > 1.0 or VehicleFruitHud.schemaZoom < 1.0 then
			local tempHeight = 0;
			for key, value in pairs(g_currentMission.hud.vehicleSchema.vehicleSchemaOverlays) do
				tempHeight = (value.height*VehicleFruitHud.schemaZoom)-value.height
				value.height = value.height*VehicleFruitHud.schemaZoom;
				value.width = value.width*VehicleFruitHud.schemaZoom;
				if VehicleFruitHud.schemaPos == 1 then
					value.y = value.y+tempHeight; --default oben
				elseif VehicleFruitHud.schemaPos == 2 then
					g_currentMission.hud.vehicleSchema.overlay.y = 0.001+VehicleFruitHud.schemaFixY; --+(tempHeight/2);
					g_currentMission.hud.vehicleSchema.overlay.x = 0.98-g_currentMission.hud.vehicleSchema.maxSchemaWidth;			
					value.x = 0.98-g_currentMission.hud.vehicleSchema.maxSchemaWidth;
					value.y = 0.001+VehicleFruitHud.schemaFixY;
				elseif VehicleFruitHud.schemaPos == 3 then
					g_currentMission.hud.vehicleSchema.overlay.x = 0.98-g_currentMission.hud.vehicleSchema.maxSchemaWidth;					
					for key, value in pairs(g_currentMission.hud.displayComponents) do
						if g_currentMission.hud.displayComponents[key].gaugeBackgroundElement ~= nil and g_currentMission.hud.displayComponents[key].gaugeCenterY ~= nil then
							g_currentMission.hud.vehicleSchema.overlay.y = g_currentMission.hud.displayComponents[key].gaugeCenterY+(g_currentMission.hud.displayComponents[key].gaugeBackgroundElement.overlay.height/1.5)+VehicleFruitHud.schemaFixY;
							break;
						end;
					end;
				end;
				--value.y = 0.025925925925926 --unten operatingTimeTextDrawPositionY
				--value.x = 0.96034617074377 --unten operatingTimeTextDrawPositionX
			end;	
		end;
	end;
end;

function VehicleFruitHud:getOptimalSize(width, txtString, defaultSize)
	local length = getTextWidth(defaultSize, tostring(txtString));
	local default = defaultSize;
	if length > width then
		local i = 0;
		while length > width do
			i = i + 0.0005;
			length = getTextWidth(defaultSize-i, tostring(txtString));
		end
		return defaultSize-i;
	end;
	return default;
end;

function VehicleFruitHud:fixSchemaPos() --not ideal solution, is Slide Effect
	if VehicleFruitHud.schemaFixX then 
		---new for slide X Effect, to testing
		if VehicleFruitHud.lastSchemaX <=0 then VehicleFruitHud.lastSchemaX = 0.098-g_currentMission.hud.vehicleSchema.maxSchemaWidth;end;
		if VehicleFruitHud.schemaPos == 2 then
			g_currentMission.hud.vehicleSchema.overlay.y = 0.001+VehicleFruitHud.schemaFixY; --+(tempHeight/2);
			--local width = g_currentMission.hud.vehicleSchema.maxSchemaWidth;			
			--if not g_gameSettings:getValue("showHelpMenu") then width = width/2;end;
			--local tempNewX = 0.98-width;
			--if tempNewX > VehicleFruitHud.lastSchemaX then g_currentMission.hud.vehicleSchema.overlay.x = tempNewX else
			--g_currentMission.hud.vehicleSchema.overlay.x = 0.98-width;VehicleFruitHud.lastSchemaX = 0.98-width;end;	
			for key, value in pairs(g_currentMission.hud.displayComponents) do
				if g_currentMission.hud.displayComponents[key].gaugeBackgroundElement ~= nil then
					if not g_gameSettings:getValue("showHelpMenu") then
						g_currentMission.hud.vehicleSchema.overlay.x = 0.96;
					else
						g_currentMission.hud.vehicleSchema.overlay.x = 0.96-(g_currentMission.hud.displayComponents[key].gaugeBackgroundElement.overlay.width/2);
					end;
					break;
				end;
			end;

			
		elseif VehicleFruitHud.schemaPos == 3 then			
			g_currentMission.hud.vehicleSchema.overlay.x = 0.96		
			for key, value in pairs(g_currentMission.hud.displayComponents) do
				if g_currentMission.hud.displayComponents[key].gaugeBackgroundElement ~= nil and g_currentMission.hud.displayComponents[key].gaugeCenterY ~= nil then
					g_currentMission.hud.vehicleSchema.overlay.y = g_currentMission.hud.displayComponents[key].gaugeCenterY+(g_currentMission.hud.displayComponents[key].gaugeBackgroundElement.overlay.height/1.5)+VehicleFruitHud.schemaFixY;
					if not g_gameSettings:getValue("showHelpMenu") then
						g_currentMission.hud.vehicleSchema.overlay.x = 0.96;
					else
						g_currentMission.hud.vehicleSchema.overlay.x = 0.96-(g_currentMission.hud.displayComponents[key].gaugeBackgroundElement.overlay.width/2);
					end;
					break;
				end;
			end;
		end;				
	else
		VehicleFruitHud:fixSchemaPosOld()
	end;
end;

function VehicleFruitHud:fixSchemaPosOld() --not ideal solution, is Slide Effect	
	if VehicleFruitHud.schemaPos == 2 then
		g_currentMission.hud.vehicleSchema.overlay.y = 0.001+VehicleFruitHud.schemaFixY; --+(tempHeight/2);
		g_currentMission.hud.vehicleSchema.overlay.x = 0.98-g_currentMission.hud.vehicleSchema.maxSchemaWidth;			
	elseif VehicleFruitHud.schemaPos == 3 then
		g_currentMission.hud.vehicleSchema.overlay.x = 0.98-g_currentMission.hud.vehicleSchema.maxSchemaWidth;					
		for key, value in pairs(g_currentMission.hud.displayComponents) do
			if g_currentMission.hud.displayComponents[key].gaugeBackgroundElement ~= nil and g_currentMission.hud.displayComponents[key].gaugeCenterY ~= nil then
				g_currentMission.hud.vehicleSchema.overlay.y = g_currentMission.hud.displayComponents[key].gaugeCenterY+(g_currentMission.hud.displayComponents[key].gaugeBackgroundElement.overlay.height/1.5)+VehicleFruitHud.schemaFixY;
				break;
			end;
		end;
	end;
end;