// 欢迎使用全新的 G2 4.0
import { Chart } from '../../src';
import { createDiv } from '../util/dom';

const values = ['运行成功', '运行失败'];
const data = [
  { task: 'task0', startTime: '2018-04-18 01:17:12', endTime: '2018-04-18 01:19:10', status: 0 },
  { task: 'task1', startTime: '2018-04-18 01:18:15', endTime: '2018-04-18 01:19:20', status: 0 },
  { task: 'task2', startTime: '2018-04-18 02:11:32', endTime: '2018-04-18 02:18:50', status: 0 },
  { task: 'task3', startTime: '2018-04-18 02:18:50', endTime: '2018-04-18 03:16:38', status: 0 },
  { task: 'task4', startTime: '2018-04-18 02:19:48', endTime: '2018-04-18 02:21:57', status: 0 },
  { task: 'task5', startTime: '2018-04-18 03:16:38', endTime: '2018-04-18 03:19:38', status: 1 },
  { task: 'task6', startTime: '2018-04-18 03:19:38', endTime: '2018-04-18 03:27:49', status: 0 },
  { task: 'task7', startTime: '2018-04-18 07:29:37', endTime: '2018-04-18 07:33:01', status: 0 },
  { task: 'task8', startTime: '2018-04-18 03:27:49', endTime: '2018-04-18 04:26:05', status: 0 },
  { task: 'task9', startTime: '2018-04-18 04:26:05', endTime: '2018-04-18 06:06:36', status: 0 },
  { task: 'task10', startTime: '2018-04-18 06:06:36', endTime: '2018-04-18 06:15:15', status: 0 },
  { task: 'task11', startTime: '2018-04-18 03:27:49', endTime: '2018-04-18 03:34:50', status: 0 },
].map((datum) => ({ ...datum, range: [datum.startTime, datum.endTime], status: values[datum.status] }));

describe('#3085: interval range', () => {
  const chart = new Chart({
    container: createDiv(),
    autoFit: false,
    width: 600,
    height: 400,
  });
  chart.data(data);
  chart.coordinate().transpose().scale(1, -1);
  chart.scale('range', {
    type: 'time',
  });

  chart.interval().position('task*range').color('status', ['#2FC25B', '#F04864']);

  chart.render();

  const interval = chart.geometries[0];

  it('No NaN', () => {
    interval.elements.forEach((elem) => {
      const model = elem.getModel();
      model.points?.forEach((point) => {
        expect(point.x).not.toBeNaN();
        expect(point.y).not.toBeNaN();
      });
    });
  });
});
