---
title: node 实例方法
order: 1
---

Node 继承自 Item。所以 Item 上面的方法在 Node 实例中都可以调用。本文仅介绍 Node 类的通用方法，内置节点见 [内置节点文档](/zh/docs/manual/middle/elements/nodes/defaultNode) 和 [demo](/zh/examples/item/defaultNodes)，自定义节点见 [自定义节点文档](/zh/docs/manual/middle/elements/nodes/custom-node) 和 [demo](/zh/examples/item/customNode)。

### node.lock()

> 3.1.4 版本新增

锁定当前节点，锁定节点后，该节点不再响应拖动节点的事件。

提示：锁定节点后，拖动画布和缩放画布的操作依然对该节点有效。如果想在锁定节点后，不响应拖动画布和缩放的事件，需要自定义拖动画布和缩放的 Behavior，具体可参考 [锁定节点不响应拖动画布的事件](/zh/docs/manual/middle/elements/methods/lock-node#拖动画布时候不处理锁定的节点) 和 [锁定节点不响应缩放事件](/zh/docs/manual/middle/elements/methods/lock-node#缩放画布时不处理锁定的节点)。

**用法**

```javascript
const node = graph.findById('node');
node.lock();
```

### node.unlock()

> 3.1.4 版本新增

解锁锁定的节点。

**用法**

```javascript
const node = graph.findById('node');
node.unlock();
```

### node.hasLocked()

> 3.1.4 版本新增

检测节点是否处于锁定状态。

**返回值**

- 返回值类型：Boolean；
- 返回 true 表示当前解锁处于锁定状态，否则表示未锁定。

**用法**

```javascript
const node = graph.findById('node');
const hasLocked = node.hasLocked();
```

### node.getNeighbors(type)

**参数**

| 名称 | 类型 | 是否必选 | 描述 |
| --- | --- | --- | --- |
| type | 'source' / 'target' / undefined | false | 邻居类型， 'source' 只获取当前节点的源节点，'target' 只获取当前节点指向的目标节点， 若不指定则返回所有类型的邻居 |

**返回值**

- 返回值类型：Array；
- 返回值符合要求的节点实例数组。

**用法**

```javascript
const neighbors = node.getNeighbors('source');
```

### node.getEdges()

获取与当前节点有关联的所有边。

**返回值**

- 返回值类型：Edge[]；
- 返回边实例的集合。

**用法**

```javascript
// 获取与 node 关联的所有边
const edges = node.getEdges();
```

### node.getInEdges()

获取与当前节点关联的所有入边。

**返回值**

- 返回值类型：Edge[]；
- 返回入边实例的集合。

**用法**

```javascript
// 获取与 node 关联的所有入边
const edges = node.getInEdges();
```

### node.getOutEdges()

获取与当前节点关联的所有出边。

**返回值**

- 返回值类型：Edge[]；
- 返回出边实例的集合。

**用法**

```javascript
// 获取与 node 关联的所有出边
const edges = node.getOutEdges();
```

### node.getAnchorPoints()

获取节点上面定义的锚点。

**返回值**

- 返回值类型：Array；
- 返回值的数据结构：

```javascript
[
  (0: {
    x: 100,
    y: 105,
    index: 0,
  }),
  (1: {
    x: 200,
    y: 105,
    index: 1,
  }),
];
```

**用法**

```javascript
// 获取定义在节点上的锚点数据
const anchor = node.getAnchorPoints();
```

### node.getLinkPoint(point)

获取距离指定坐标最近的一个锚点。

**参数**

| 名称  | 类型   | 是否必选 | 描述                                       |
| ----- | ------ | -------- | ------------------------------------------ |
| point | Object | true     | 节点外部的一个点，用于计算交点及最近的锚点 |

**返回值**

- 返回值类型：Object；
- 返回值表示连接点的坐标 (x, y)，如果没有合适的锚点和连接点，则返回中心点。

**用法**

```javascript
const point = {
  x: 100,
  y: 105,
};
// 获取连接点
const linkPoint = node.getLinkPoint(point);
```

### node.getLinkPointByAnchor(index)

根据锚点索引获取连接点的 x、y 坐标。

**参数**

| 名称  | 类型   | 是否必选 | 描述       |
| ----- | ------ | -------- | ---------- |
| index | Number | true     | 锚点的索引 |

**返回值**

- 返回值类型：Object；
- 返回值表示连接点的坐标 (x, y)。

**用法**

```javascript
// 获取定义在节点上的第一个锚点
const anchor = node.getLinkPointByAnchor(0);
```

### node.addEdge(edge)

添加指定的边到当前节点上。

**参数**

| 名称 | 类型 | 是否必选 | 描述      |
| ---- | ---- | -------- | --------- |
| edge | Edge | true     | Edge 实例 |

**用法**

```javascript
const edge = new Edge({
  // TODO
});
node.addEdge(edge);
```

### node.removeEdge(edge)

移除与当前节点相关的指定边。

**参数**

| 名称 | 类型 | 是否必选 | 描述      |
| ---- | ---- | -------- | --------- |
| edge | Edge | true     | Edge 实例 |

**用法**

```javascript
const edge = graph.findById('edge1');
node.removeEdge(edge);
```
