---
title: 模版
order: 5
---

## 流程图

### 名词解释

流程图是表示算法、工作流或流程的一种框图表示，它以不同类型的框代表不同种类的步骤，每两个步骤之间则以箭头连接。这种表示方法便于说明解决已知问题的方法。

### 特点

流程图背后可以概括了各节点类型、其内容及其他补充用的信息。在设计或者记录一些简单的步骤或程序都会用得上流程图。与其他图表一样，这种图表可以帮助可视化发生了什么事情，从而更易去理解中间的工序。虽然有很多𧗠生出来的版本，各目有各目的标示方式，它们大都都有以下 2 种的符号：

- 步骤：通常称作“活动”，常以长方形来表示；
- 决定：常以钻石形来表示。其他常用形状：

| 形状 | 名称 | 描述 |
| --- | --- | --- |
| <img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*4wLRTpVEM2sAAAAAAAAAAAAAARQnAQ' width=70 alt=‘img’> | 起止符号 | 用来表示次要或程序的开始与完结。常以一个圆角长方形表示。通常里面会标上“开始”或“结束”或其他相关字眼，如“提交查询”或“接受产品”。 |
| <img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*ejgOT7FamT4AAAAAAAAAAAAAARQnAQ' width=70 alt=‘img’> | 程序 | 以长方形来代表一系列程序去改变量值、形式、数据的位置。 |
| <img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*ns2VQKZU22QAAAAAAAAAAAAAARQnAQ' width=70 alt=‘img’> | 决策判断 | 以一个菱形去显示一个条件进程，用来按情况去决定下一步走向。通常以“是/否”或“真/假”值去决定。 |
| <img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*4-jRQK3dXvQAAAAAAAAAAAAAARQnAQ' width=70 alt=‘img’> | 输入/输出 | 以平行四边形来据输入或输出的过程，即填入数据或显示工作结果的步骤。 |
| <img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*mjiqTKWv2XAAAAAAAAAAAAAAARQnAQ' width=70 alt=‘img’> | 已定义流程 | 用一个有 2 条左右垂直线长方型，来表示一个已在其他地方定义了的过程。 |
| <img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*UX_xTaDD2KQAAAAAAAAAAAAAARQnAQ' width=70 alt=‘img’> | 同页参考 | 用一个含有字母的小圆圈来连接目标流程画于同一页上。 |
| <img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*eEzhQa6tyJMAAAAAAAAAAAAAARQnAQ' width=70 alt=‘img’> | 换页参考 | 用一个倒画的屋型来表示目标流程画于另一页上。 |

### 业务场景

流程图是流经一个系统的信息流、观点流或部件流的图形代表。在企业中，流程图主要用来说明某一过程。这种过程既可以是生产线上的工艺流程，也可以是完成一项任务必需的管理过程。典型场景：

- 组织结构图：组织结构图是把企业组织分成若干部分,并且标明各部分之间可能存在的各种关系。例如上下级领导关系(组织机构图)，物流关系，资金流关系和资料传递关系等；
- BPMN：用于以业务流程模型详细说明各种业务流程；
- UML：UML 立足于对事物的实体、性质、关系、结构、状态和动态变化过程的全程描述和反映；
- EPC 事件过程线图：适合诸如 B2B、供应链流程管理、仓储物流管理等商业化业务流程。

<br/>
<img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*OMeFRIWC1L0AAAAAAAAAAAAAARQnAQ' width=600 alt=‘img’>

### 绘制流程图的 Tips

- 流程图一般是用标准的符号绘制的，并非严格要求使用这些方框，圆圈，菱形或其它标准的符号来制作一个流程图，但是标准符号确实能更清晰地展示事件的类别。以下是大多数情况常用的一组标准符号
- 常用的流程图方向是从左到右或者从上到下：
- 上下流程图：上下流程图是最常见的一种流程图，它仅表示上一步与下一步的顺序关系；
- 矩阵流程图：矩阵流程图不仅表示下下关系，还可以看出某一过程的其他关系；
- 在标准流程图符号内简要说明符号代表的内容。必要时，你可以用注释符号更清晰地描述数据或计算步骤；
- 确保流程图有一个逻辑的起点和终点；
- 用简单的测试数据来测试流程图的有效性是非常有用的。

## DAG

### 名词解释

DAG 是 Directed Acyclic Graph 的缩写，即有向无环图，它是指图中一个点经过两种路线到达另一个点没有闭环。它原本是计算机领域一种常用数据结构，因为独特的拓扑结构所带来的优异特性，经常被用于处理动态规划、导航中寻求最短路径、数据压缩等多种算法场景

### 特点

DAG 相比于目前的公链技术，其实是图和链的区别，对于链而言，无法只处理一个局部，因为链的入度和出度只有一个，不能把链上的节点拆成好几个节点去处理，但是对于图却可以，因为图可以有多个出度，那么可以同时处理多个出度连接的节点。所以，它的特点是：

- DAG 图可以有编辑态（拖拉拽画成一个图），也可是只读态（供阅读者查阅读）；
- 交易速度块，DAG 实现的局部处理和并行结算可以使得交易速度大幅度提升；
- 拓展性强，因为各个节点无需等待同步其他的节点的数据就可计算使得记账节点很容易答复延展，因此 DAG 很适用于物联网类项目；
- 作恶难度更大，相比于链式结构，在 DAG 中恶意修改的难度会大很多，因为 DAG 拥有着很多的出度和入度，假如要修改某一个节点，那么对应的出入度都要进行修改。

### 业务场景

DAG 图常用来描述业务流程，典型场景：

- 人工智能产品，可以通过 DAG 图可以将一个复杂的人工智能实验流程给图形化出来，大大降低理解成本；
- 系统架构：表达一个系统架构各个层各个实例之间的关系，有明确的分层；
- 交易系统：表达资金、交易等流转情况。

### 设计示例图

<img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*g12_TbiXXM0AAAAAAAAAAAAAARQnAQ' width=600 alt=‘img’>

### 绘制 DAG 图的 Tips

- 一定有明确的方向，从上到下，从左到右等，不存在节点指向方向逆反；
- 一个节点可能会拆分出多个节点，前后存在包含、关联等关系；
- 除业务特性外，图没有唯一的开始结束节点。

## 血缘图

### 名词解释

Data Lineage 数据血统，也叫做 Data Provenance 数据起源或 Data Pedigree 数据谱系。任何的数据，从产生、ETL 处理、加工、融合、流转，到最终消亡，数据之间自然会形成一种关系。好比人类社会中的人际关系，类似的一种关系来表达数据之间的这种关系，称之为数据的血缘关系。

### 特点

- 归属性：特定的数据归属特定的组织（或个人），数据具有归属性；
- 多源性：同一个数据可以有多个来源, 一个数据可以是多个数据经过加工而生成的，而且这种加工过程可以是多个；
- 可追溯性: 数据的血缘关系，体现了数据的生命周期，体现了数据从产生到消亡的整个过程，具备可追溯性；
- 层次性: 数据的血缘关系是有层次的。对数据的分类、归纳、总结等对数据进行的描述信息又形成了新的数据，不同程度的描述信息形成了数据的层次。

### 业务场景

- 追踪数据溯源：当数据发生异常，帮助追踪到异常发生的原因，平时也能帮助我们追踪数据的来源，追踪数据处理过程；
- 评估数据价值：要对数据价值进行评估，就需要有依据，数据血缘关系，可以从#数据受众、数据更新量级、数据更新# 频次等方面给数据价值的评估提供依据；
- 数据质量评估：数据的血缘关系图上，可以方便的看到数据清洗的标准清单，这个清单反映了对数据质量的要求。

### 设计示例图

<img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*oFPMTL5gQmwAAAAAAAAAAAAAARQnAQ' width=600 alt=‘img’>

### 绘制血缘图的 Tips

- 数据节点有三种类型：主节点，数据流出节点，数据流入节点；
- 主节点只有一个，一般位于整个图形的中间，是可视化图形的核心节点。图形展示的血缘关系就是此节点的血缘关系，其他与此节点无关的血缘关系都不在图形上展示，以保证图形的简单、清晰；
- 数据流入节点可以有多个，是主节点的父节点，表示数据来源；
- 数据流出节点也可以有多个，是主节点的子节点，表示数据的去向；包括一种特殊的节点，即终端节点，终端节点是一种特殊的数据流出节点，表示数据不再往下进行流转，这种数据一般用来做可视化展示；
- 流转线表现的是数据的流转路径，从左到右流转。数据流转线路从数据流入节点出来往主节点汇聚，又从主节点流出往数据流出节点扩散；
- 数据流转线路表现了三个维度的信息，分别是方向、数据更新量级、数据更新频次；
- 方向的表现方式，没有做特别的设计，默认从上到下流转；
- 数据更新的量级通过线条的粗细来表现。线条越粗表示数据量级越大，线条越细则表示数据量级越小；
- 数据更新的频次用线条中线段的长度来表现。线段越短表示更新频次越高，线段越长表示更新频次越底，一根实线则表示只流转一次。

## 关系图

### 名词解释

关系图，又称关联图，是用来分析事物之间“原因与结果”、“目的与手段”等复杂关系的一种图表，它能够帮助人们从事物之间的逻辑关系中，寻找出解决问题的办法。关系图由圆圈(或方框)和箭头组成，其中圆圈中是文字说明部分箭头由原因指向结果，由手段指向目的。

### 特点

图是一个高度抽象的模型，数据中的各种关系都能用图表示。图中的点和边，可以非常灵活，不局限于现实意义的实体。最直接能想到的当然是某个人可以是点，某个产品可以是点，它们之间的联系是边；除了点与点之间的联系外，还分为空间聚集的聚类，反应出不同团队、不同聚类之间的关系。

### 业务场景

图分析的四种广泛使用的类型包括路径分析，连通性分析，社区分析和集中性分析：

- 路径分析：这种类型的分析可用于确定图中两个节点之间的最短距离。例如路线优化，特别适用于物流，供应和分销链以及智慧城市的交通优化；
- 连通性分析：这种类型的图形分析可用于确定诸如公用电网之类的网络中的弱点。它还可以比较跨网络的连接；
- 社区分析：基于距离和密度的分析用于查找社交网络中互动的人群；
- 集中度分析：这种分析类型能够识别相关性，例如在社交网络中找到最有影响力的人，或找到访问量最高的网页。

### 设计示例图

<img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*wy59TKlWOnkAAAAAAAAAAAAAARQnAQ' width=600 alt=‘img’>

### 绘制关系图的 Tips

- 把对象变成点，点的大小、颜色可以是它的两个参数，
- 两个点之间的关系可以用连线来表示。连线分为无向（只是连接的导向，一些简单的关系很容易体现）和有向（复杂网络，连接+方向）。
- 线本身的方向代表了连接的关系同时线的粗线也可以表示线的连接强度

## E-R 图

### 名词解释

实体关系图也称 ER 模型（是指以实体、关系、属性三个基本概念概括数据的基本结构，从而描述静态数据结构的概念模型），全称为实体联系模型或实体关系模型，是概念数据模型的高层描述所使用的数据模型或模式图。

### 特点

ER 图分为实体、属性、关系三个核心部分。

- 实体：即数据模型中的数据对象，例如人、学生、音乐都可以作为一个数据对象；
- 属性：即数据对象所具有的属性，例如学生具有姓名、学号、年级等属性；
- 关系：用来表现数据对象与数据对象之间的联系，例如学生的实体和成绩表的实体之间有一定的联系，每个学生都有自己的成绩表，这就是一种关系。

ER 图中关联关系有三种：

- 1 对 1（1:1） ：1 对 1 关系是指对于实体集 A 与实体集 B，A 中的每一个实体至多与 B 中一个实体有关系；反之，在实体集 B 中的每个实体至多与实体集 A 中一个实体有关系；
- 1 对多（1:N） ：1 对多关系是指实体集 A 与实体集 B 中至少有 N(N>0)个实体有关系；并且实体集 B 中每一个实体至多与实体集 A 中一个实体有关系；
- 多对多（M:N） ：多对多关系是指实体集 A 中的每一个实体与实体集 B 中至少有 M(M>0)个实体有关系，并且实体集 B 中的每一个实体与实体集 A 中的至少 N（N>0）个实体有关系。

### 使用场景

一般在逻辑和物理数据库设计中使用，包括信息工程和空间建模。也可以用在两个或更多实体相互如何关联；

- 常用于信息系统设计中：在概念结构设计阶段用来描述信息需求或要存储在数据库中的信息类型，作为用户与分析员之间有效的交流工具；
- 描述感兴趣区域的任何本体：对使用的术语和它们的联系的概述和分类，用实体、联系和属性这三个概念来理解现实问题。

### 设计示例图

<img src='https://gw.alipayobjects.com/mdn/rms_f8c6a0/afts/img/A*lyBkS7R08XwAAAAAAAAAAAAAARQnAQ' width=600 alt=‘img’>

### 绘制 E-R 图的 Tips

- 首先确定这个模块有哪几个核心的对象以及具体有哪些特征；其次思考这些对象之间的关系，如何相互转变；最后把他们用 ER 图的方法表述出来；
- 方形表示实体，一般是名词；菱形表示联系，一般是动词；椭圆表示属性，一般是名词；线表示联系；
- 尽量精简实体以及优化属性。
