import G6 from '@antv/g6';

const data = {
  nodes: [
    { id: 'node1', x: 350, y: 200, comboId: 'combo1' },
    { id: 'node2', x: 350, y: 250, comboId: 'combo1' },
    { id: 'node3', x: 100, y: 200, comboId: 'combo3' },
  ],
  edges: [
    { source: 'node1', target: 'node2' },
    { source: 'node1', target: 'node3' },
    { source: 'combo1', target: 'node3' },
  ],
  combos: [
    { id: 'combo1', label: 'Combo 1', parentId: 'combo2' },
    { id: 'combo2', label: 'Combo 2' },
    { id: 'combo3', label: 'Combo 3', collapsed: true },
  ],
};

const descriptionDiv = document.createElement('div');
descriptionDiv.innerHTML =
  'Double click the combo to collapse/expand it. Drag the node or combo to change the hierarchy.';
const container = document.getElementById('container');
container.appendChild(descriptionDiv);

const width = container.scrollWidth;
const height = (container.scrollHeight || 500) - 20;
const graph = new G6.Graph({
  container: 'container',
  width,
  height,
  // Set groupByTypes to false to get rendering result with reasonable visual zIndex for combos
  groupByTypes: false,
  defaultCombo: {
    type: 'circle',
    style: {
      lineWidth: 1,
    },
    labelCfg: {
      refY: 15,
      position: 'bottom',
    },
  },
  comboStateStyles: {
    dragenter: {
      lineWidth: 4,
      stroke: '#FE9797',
    },
  },
  modes: {
    default: ['drag-canvas', 'drag-node', 'drag-combo', 'collapse-expand-combo', 'click-select'],
  },
});

graph.data(data);
graph.render();

graph.on('combo:dragend', (e) => {
  graph.getCombos().forEach((combo) => {
    graph.setItemState(combo, 'dragenter', false);
  });
});
graph.on('node:dragend', (e) => {
  graph.getCombos().forEach((combo) => {
    graph.setItemState(combo, 'dragenter', false);
  });
});
graph.on('combo:dragenter', (e) => {
  graph.setItemState(e.item, 'dragenter', true);
});
graph.on('combo:dragleave', (e) => {
  graph.setItemState(e.item, 'dragenter', false);
});

graph.on('combo:mouseenter', (evt) => {
  const { item } = evt;
  graph.setItemState(item, 'active', true);
});

graph.on('combo:mouseleave', (evt) => {
  const { item } = evt;
  graph.setItemState(item, 'active', false);
});

if (typeof window !== 'undefined')
  window.onresize = () => {
    if (!graph || graph.get('destroyed')) return;
    if (!container || !container.scrollWidth || !container.scrollHeight) return;
    graph.changeSize(container.scrollWidth, container.scrollHeight - 20);
  };
