--
-- HelplineExtension
--
-- @author Stefan Maurus
-- @date 06/10/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.


HelplineExtension = {}

HelplineExtension.MOD_NAME = g_currentModName
HelplineExtension.MOD_DIR = g_currentModDirectory

local HelplineExtension_mt = Class(HelplineExtension)

function HelplineExtension.new(pfModule, customMt)
    local self = setmetatable({}, customMt or HelplineExtension_mt)

    self.pfModule = pfModule
    self.numNewListItems = 8

    return self
end

function HelplineExtension:loadFromXML(xmlFile, key, baseDirectory, configFileName, mapFilename)
    self.additionalFilename = Utils.getFilename(getXMLString(xmlFile, key .. "#filename"), HelplineExtension.MOD_DIR)

    return true
end

---
-- @includeCode
function HelplineExtension:getGlobalI18N(list)
    table.insert(list, "precisionFarming_helpHeader")
    table.insert(list, "precisionFarming_helpTitle_01")
    table.insert(list, "precisionFarming_helpText_01_part01")
    table.insert(list, "precisionFarming_helpText_01_part02")
    table.insert(list, "precisionFarming_helpText_01_part03")
    table.insert(list, "precisionFarming_helpTitle_02")
    table.insert(list, "precisionFarming_helpText_02_part01")
    table.insert(list, "precisionFarming_helpText_02_part02")
    table.insert(list, "precisionFarming_helpTitle_03")
    table.insert(list, "precisionFarming_helpText_03_part01")
    table.insert(list, "precisionFarming_helpText_03_part02")
    table.insert(list, "precisionFarming_helpTitle_04")
    table.insert(list, "precisionFarming_helpText_04_part01")
    table.insert(list, "precisionFarming_helpText_04_part02")
    table.insert(list, "precisionFarming_helpTitle_05")
    table.insert(list, "precisionFarming_helpText_05_part01")
    table.insert(list, "precisionFarming_helpText_05_part02")
    table.insert(list, "precisionFarming_helpTitle_06")
    table.insert(list, "precisionFarming_helpText_06_part01")
    table.insert(list, "precisionFarming_helpText_06_part02")
    table.insert(list, "precisionFarming_helpTitle_07")
    table.insert(list, "precisionFarming_helpText_07_part01")
    table.insert(list, "precisionFarming_helpText_07_part02")
    table.insert(list, "precisionFarming_helpTitle_08")
    table.insert(list, "precisionFarming_helpText_08_part01")
    table.insert(list, "precisionFarming_helpText_08_part02")
end

function HelplineExtension:delete()
end

function HelplineExtension:getAllowFirstTimeEvent()
    return not g_currentMission.hud:isInGameMessageVisible() and not g_gui:getIsGuiVisible()
end

function HelplineExtension:onFirstTimeRun()
    g_gui:showYesNoDialog({text=g_i18n:getText("precisionFarming_firstStart", HelplineExtension.MOD_NAME), callback=self.onFirstTimeRunDialog, target=self})
end

function HelplineExtension:onFirstTimeRunDialog(yes)
    if yes then
        self:openHelpMenu()
    end
end

function HelplineExtension:openHelpMenu(offsetIndex)
    if g_gui.currentGuiName ~= "InGameMenu" then
        g_gui:showGui("InGameMenu")
    end

    if g_currentMission ~= nil then
        local inGameMenu = g_currentMission.inGameMenu
        local helpLinePage = inGameMenu.pageHelpLine
        inGameMenu:goToPage(helpLinePage)

        local searchHeader = g_i18n:getText("precisionFarming_helpHeader", HelplineExtension.MOD_NAME)
        for index, listItem in pairs(helpLinePage.helpLineList.listItems) do
            if #listItem.elements == 1 then
                if listItem.elements[1].text == searchHeader then
                    helpLinePage.helpLineList:scrollTo(index + self.numNewListItems, true)
                    helpLinePage.helpLineList:setSelectedIndex(index + 1 + (offsetIndex or 0))
                    helpLinePage:onHelpLineListSelectionChanged(index + 1 + (offsetIndex or 0))
                    break
                end
            end
        end
    end
end

function HelplineExtension:overwriteGameFunctions(pfModule)
    --
    --  Additionally load our helpline texts after the map's texts have been loaded
    --
    pfModule:overwriteGameFunction(HelpLineManager, "loadMapData", function(superFunc, self, xmlFile, missionInfo)
        if not superFunc(self, xmlFile, missionInfo) then
            return false
        end

        local filename = pfModule.helplineExtension.additionalFilename
        if filename ~= nil and filename ~= "" then
            self:loadFromXML(filename)
        end

        for ci=1, #self.categories do
            local category = self.categories[ci]
            for pi=1, #category.pages do
                local page = category.pages[pi]
                for ii=1, #page.items do
                    local item = page.items[ii]
                    if item.type == HelpLineManager.ITEM_TYPE.IMAGE then
                        if item.value:sub(1,11) == "$paModDir$/" then
                            -- add dollar sign to the InGameMenuHelpFrame won't add the maps base directory to the path since it's already absolute to the PF mod dir
                            item.value = "$" .. HelplineExtension.MOD_DIR .. item.value:sub(12)
                        end
                    end
                end
            end
        end

        return true
    end)
end
