-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

AdditionalFieldBuyInfoEvent = {}
---Event for syncing the field buy info to the player
-- @category Events

local AdditionalFieldBuyInfoEvent_mt = Class(AdditionalFieldBuyInfoEvent, Event)

InitEventClass(AdditionalFieldBuyInfoEvent, "AdditionalFieldBuyInfoEvent")

---Create instance of Event class
-- @return table self instance of class event
-- @includeCode
function AdditionalFieldBuyInfoEvent:emptyNew()
    local self = Event:new(AdditionalFieldBuyInfoEvent_mt)
    return self
end

---Create new instance of event
-- @param table object object
-- @includeCode
function AdditionalFieldBuyInfoEvent:new(farmlandId)
    local self = AdditionalFieldBuyInfoEvent:emptyNew()
    self.farmlandId = farmlandId
    return self
end

---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function AdditionalFieldBuyInfoEvent:readStream(streamId, connection)
    self.farmlandId = streamReadUIntN(streamId, g_farmlandManager.numberOfBits)

    local pfModule = g_precisionFarming
    if pfModule ~= nil then
        if pfModule.additionalFieldBuyInfo ~= nil then
            pfModule.additionalFieldBuyInfo:readInfoFromStream(self.farmlandId, streamId, connection)
        end
    end
end

---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function AdditionalFieldBuyInfoEvent:writeStream(streamId, connection)
    streamWriteUIntN(streamId, self.farmlandId, g_farmlandManager.numberOfBits)

    local pfModule = g_precisionFarming
    if pfModule ~= nil then
        if pfModule.additionalFieldBuyInfo ~= nil then
            pfModule.additionalFieldBuyInfo:writeInfoToStream(self.farmlandId, streamId, connection)
        end
    end
end
