-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ExtendedSprayerAmountEvent = {}
---Event for sync of spray amount and automatic state
-- @category Events

local ExtendedSprayerAmountEvent_mt = Class(ExtendedSprayerAmountEvent, Event)

InitEventClass(ExtendedSprayerAmountEvent, "ExtendedSprayerAmountEvent")

---Create instance of Event class
-- @return table self instance of class event
-- @includeCode
function ExtendedSprayerAmountEvent:emptyNew()
    local self = Event:new(ExtendedSprayerAmountEvent_mt)
    return self
end

---Create new instance of event
-- @param table object object
-- @param bool automaticMode automaticMode
-- @param integer manualValue manualValuemanualValue
-- @includeCode
function ExtendedSprayerAmountEvent:new(object, automaticMode, manualValue)
    local self = ExtendedSprayerAmountEvent:emptyNew()
    self.object = object
    self.automaticMode = automaticMode
    self.manualValue = manualValue
    return self
end

---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function ExtendedSprayerAmountEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.automaticMode = streamReadBool(streamId)
    if not self.automaticMode then
        self.manualValue = streamReadUIntN(streamId, 5)
    end

    self:run(connection)
end

---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function ExtendedSprayerAmountEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    if not streamWriteBool(streamId, self.automaticMode) then
        streamWriteUIntN(streamId, self.manualValue, 5)
    end
end

---Run action on receiving side
-- @param integer connection connection
-- @includeCode
function ExtendedSprayerAmountEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object)
    end

    self.object:setSprayAmountAutoMode(self.automaticMode, true)
    if not self.automaticMode then
        self.object:setSprayAmountManualValue(self.manualValue, true)
    end
end

---Broadcast event from server to all clients, if called on client call function on server and broadcast it to all clients
-- @param table object object
-- @param boolean noEventSend no event send
-- @includeCode
function ExtendedSprayerAmountEvent.sendEvent(object, automaticMode, manualValue, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(ExtendedSprayerAmountEvent:new(object, automaticMode, manualValue), nil, nil, object)
        else
            g_client:getServerConnection():sendEvent(ExtendedSprayerAmountEvent:new(object, automaticMode, manualValue))
        end
    end
end
