--
-- SharedSoilStateMap
--
-- @author Stefan Maurus
-- @date 07/08/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.


SharedSoilStateMap = {}

SharedSoilStateMap.MOD_NAME = g_currentModName

local SharedSoilStateMap_mt = Class(SharedSoilStateMap, ValueMap)

function SharedSoilStateMap.new(pfModule, customMt)
    local self = ValueMap.new(pfModule, customMt or SharedSoilStateMap_mt)

    self.filename = "precisionFarming_sharedSoilStateMap.grle"
    self.name = "sharedSoilStateMap"
    self.id = "SOIL_STATE_MAP"

    return self
end

function SharedSoilStateMap:loadFromXML(xmlFile, key, baseDirectory, configFileName, mapFilename)
    key = key .. ".sharedSoilStateMap"

    self.numChannels = getXMLInt(xmlFile, key .. ".bitVectorMap#numChannels") or 11
    self.maxValue = 2 ^ self.numChannels - 1
    self.sizeX = getXMLInt(xmlFile, key .. ".bitVectorMap#sizeX") or 1024
    self.sizeY = getXMLInt(xmlFile, key .. ".bitVectorMap#sizeY") or 1024

    self.bitVectorMap, self.newValueMap = self:loadSavedBitVectorMap("SharedSoilStateMap", self.filename, self.numChannels, self.sizeX)
    self:addBitVectorMapToSync(self.bitVectorMap)
    self:addBitVectorMapToSave(self.bitVectorMap, self.filename)

    return true
end

function SharedSoilStateMap:getShowInMenu()
    return false
end
