--
-- ExtendedDischargeable
--
-- @author  Stefan Maurus
-- @date  12/10/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

---Specialization to block discharging while something is attached to vehicle
-- @category Specializations
ExtendedDischargeable = {}

---Checks if all prerequisite specializations are loaded
-- @param table specializations specializations
-- @return boolean hasPrerequisite true if all prerequisite specializations are loaded
-- @includeCode
function ExtendedDischargeable.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AttacherJoints, specializations)
end

function ExtendedDischargeable.registerFunctions(vehicleType)
end

function ExtendedDischargeable.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getCanDischargeToGround", ExtendedDischargeable.getCanDischargeToGround)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "getCanDischargeToObject", ExtendedDischargeable.getCanDischargeToObject)
end

function ExtendedDischargeable.registerEventListeners(vehicleType)
end

---
-- @includeCode
function ExtendedDischargeable:getCanDischargeToGround(superFunc, dischargeNode)
    if not superFunc(self, dischargeNode) then
        return false
    end

    if #self:getAttachedImplements() ~= 0 then
        return false
    end

    return true
end


---
-- @includeCode
function ExtendedDischargeable:getCanDischargeToObject(superFunc, dischargeNode)
    if not superFunc(self, dischargeNode) then
        return false
    end

    if #self:getAttachedImplements() ~= 0 then
        return false
    end

    return true
end
