--
-- ExtendedMower
--
-- @author  Stefan Maurus
-- @date  28/10/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

---Specialization to toggle minimap zoom while on field
-- @category Specializations
ExtendedMower = {}
ExtendedMower.MOD_NAME = g_currentModName

---Checks if all prerequisite specializations are loaded
-- @param table specializations specializations
-- @return boolean hasPrerequisite true if all prerequisite specializations are loaded
-- @includeCode
function ExtendedMower.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Mower, specializations)
       and SpecializationUtil.hasSpecialization(PrecisionFarmingStatistic, specializations)
end

function ExtendedMower.registerFunctions(vehicleType)
end

function ExtendedMower.registerOverwrittenFunctions(vehicleType)
end

function ExtendedMower.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", ExtendedMower)
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", ExtendedMower)
end

---
-- @includeCode
function ExtendedMower:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if self.isClient then
        if self:getIsActiveForInput(true, true) then
            ExtendedMower.updateMinimapActiveState(self)
        end
    end
end

---
-- @includeCode
function ExtendedMower:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    if self.isClient then
        if isActiveForInputIgnoreSelection then
            ExtendedMower.updateMinimapActiveState(self)
        else
            ExtendedMower.updateMinimapActiveState(self, false)
        end
    end
end

---
-- @includeCode
function ExtendedMower.updateMinimapActiveState(self, forcedState)
    local yieldMap = self:getPAYieldMap()

    local isActive = forcedState
    if isActive == nil then
        local _, _, _, isOnField = self:getPAStatisticInfo()
        isActive = isOnField
    end

    yieldMap:setRequireMinimapDisplay(isActive, self)
end
