--
-- FarmlandStatisticCounter
--
-- @author Stefan Maurus
-- @date 17/09/2020
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.


FarmlandStatisticCounter = {}

local FarmlandStatisticCounter_mt = Class(FarmlandStatisticCounter)

---
-- @includeCode
function FarmlandStatisticCounter.new(customMt)
    local self = setmetatable({}, customMt or FarmlandStatisticCounter_mt)

    self:reset()

    return self
end

---
-- @includeCode
function FarmlandStatisticCounter:loadFromItemsXML(xmlFile, key)
    self.numSoilSamples = getXMLInt(xmlFile, key .. "#numSoilSamples") or self.numSoilSamples

    self.usedLime = getXMLFloat(xmlFile, key .. "#usedLime") or self.usedLime
    self.usedLimeRegular = getXMLFloat(xmlFile, key .. "#usedLimeRegular") or self.usedLimeRegular

    self.usedMineralFertilizer = getXMLFloat(xmlFile, key .. "#usedMineralFertilizer") or self.usedMineralFertilizer
    self.usedMineralFertilizerRegular = getXMLFloat(xmlFile, key .. "#usedMineralFertilizerRegular") or self.usedMineralFertilizerRegular

    self.usedLiquidFertilizer = getXMLFloat(xmlFile, key .. "#usedLiquidFertilizer") or self.usedLiquidFertilizer
    self.usedLiquidFertilizerRegular = getXMLFloat(xmlFile, key .. "#usedLiquidFertilizerRegular") or self.usedLiquidFertilizerRegular

    self.usedManure = getXMLFloat(xmlFile, key .. "#usedManure") or self.usedManure
    self.usedManureRegular = getXMLFloat(xmlFile, key .. "#usedManureRegular") or self.usedManureRegular

    self.usedLiquidManure = getXMLFloat(xmlFile, key .. "#usedLiquidManure") or self.usedLiquidManure
    self.usedLiquidManureRegular = getXMLFloat(xmlFile, key .. "#usedLiquidManureRegular") or self.usedLiquidManureRegular

    self.usedSeeds = getXMLFloat(xmlFile, key .. "#usedSeeds") or self.usedSeeds
    self.usedSeedsRegular = getXMLFloat(xmlFile, key .. "#usedSeedsRegular") or self.usedSeedsRegular

    self.yield = getXMLFloat(xmlFile, key .. "#yield") or self.yield
    self.yieldRegular = getXMLFloat(xmlFile, key .. "#yieldRegular") or self.yieldRegular
    self.yieldWeight = getXMLFloat(xmlFile, key .. "#yieldWeight") or self.yieldWeight
    self.yieldBestPrice = getXMLFloat(xmlFile, key .. "#yieldBestPrice") or self.yieldBestPrice

    self.usedFuel = getXMLFloat(xmlFile, key .. "#usedFuel") or self.usedFuel
    self.vehicleCosts = getXMLFloat(xmlFile, key .. "#vehicleCosts") or self.vehicleCosts

    self.helperCosts = getXMLFloat(xmlFile, key .. "#helperCosts") or self.helperCosts
end

---
-- @includeCode
function FarmlandStatisticCounter:saveToXMLFile(xmlFile, key, usedModNames)
    setXMLInt(xmlFile, key .. "#numSoilSamples", self.numSoilSamples)

    setXMLFloat(xmlFile, key .. "#usedLime", self.usedLime)
    setXMLFloat(xmlFile, key .. "#usedLimeRegular", self.usedLimeRegular)

    setXMLFloat(xmlFile, key .. "#usedMineralFertilizer", self.usedMineralFertilizer)
    setXMLFloat(xmlFile, key .. "#usedMineralFertilizerRegular", self.usedMineralFertilizerRegular)

    setXMLFloat(xmlFile, key .. "#usedLiquidFertilizer", self.usedLiquidFertilizer)
    setXMLFloat(xmlFile, key .. "#usedLiquidFertilizerRegular", self.usedLiquidFertilizerRegular)

    setXMLFloat(xmlFile, key .. "#usedManure", self.usedManure)
    setXMLFloat(xmlFile, key .. "#usedManureRegular", self.usedManureRegular)

    setXMLFloat(xmlFile, key .. "#usedLiquidManure", self.usedLiquidManure)
    setXMLFloat(xmlFile, key .. "#usedLiquidManureRegular", self.usedLiquidManureRegular)

    setXMLFloat(xmlFile, key .. "#usedSeeds", self.usedSeeds)
    setXMLFloat(xmlFile, key .. "#usedSeedsRegular", self.usedSeedsRegular)

    setXMLFloat(xmlFile, key .. "#yield", self.yield)
    setXMLFloat(xmlFile, key .. "#yieldRegular", self.yieldRegular)
    setXMLFloat(xmlFile, key .. "#yieldWeight", self.yieldWeight)
    setXMLFloat(xmlFile, key .. "#yieldBestPrice", self.yieldBestPrice)

    setXMLFloat(xmlFile, key .. "#usedFuel", self.usedFuel)
    setXMLFloat(xmlFile, key .. "#vehicleCosts", self.vehicleCosts)

    setXMLFloat(xmlFile, key .. "#helperCosts", self.helperCosts)
end

---
-- @includeCode
function FarmlandStatisticCounter:reset()
    self.numSoilSamples = 0

    self.usedLime = 0
    self.usedLimeRegular = 0

    self.usedMineralFertilizer = 0
    self.usedMineralFertilizerRegular = 0

    self.usedLiquidFertilizer = 0
    self.usedLiquidFertilizerRegular = 0

    self.usedManure = 0
    self.usedManureRegular = 0

    self.usedLiquidManure = 0
    self.usedLiquidManureRegular = 0

    self.usedSeeds = 0
    self.usedSeedsRegular = 0

    self.yield = 0
    self.yieldRegular = 0
    self.yieldWeight = 0
    self.yieldBestPrice = 0

    self.usedFuel = 0
    self.vehicleCosts = 0

    self.helperCosts = 0
end

---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function FarmlandStatisticCounter:onReadStream(streamId, connection)
    self.numSoilSamples = streamReadUIntN(streamId, 16)

    self.usedLime = streamReadFloat32(streamId)
    self.usedLimeRegular = streamReadFloat32(streamId)

    self.usedMineralFertilizer = streamReadFloat32(streamId)
    self.usedMineralFertilizerRegular = streamReadFloat32(streamId)

    self.usedLiquidFertilizer = streamReadFloat32(streamId)
    self.usedLiquidFertilizerRegular = streamReadFloat32(streamId)

    self.usedManure = streamReadFloat32(streamId)
    self.usedManureRegular = streamReadFloat32(streamId)

    self.usedLiquidManure = streamReadFloat32(streamId)
    self.usedLiquidManureRegular = streamReadFloat32(streamId)

    self.usedSeeds = streamReadFloat32(streamId)
    self.usedSeedsRegular = streamReadFloat32(streamId)

    self.yield = streamReadFloat32(streamId)
    self.yieldRegular = streamReadFloat32(streamId)
    self.yieldWeight = streamReadFloat32(streamId)
    self.yieldBestPrice = streamReadFloat32(streamId)

    self.usedFuel = streamReadFloat32(streamId)
    self.vehicleCosts = streamReadFloat32(streamId)

    self.helperCosts = streamReadFloat32(streamId)
end

---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
-- @includeCode
function FarmlandStatisticCounter:onWriteStream(streamId, connection)
    streamWriteUIntN(streamId, self.numSoilSamples, 16)

    streamWriteFloat32(streamId, self.usedLime)
    streamWriteFloat32(streamId, self.usedLimeRegular)

    streamWriteFloat32(streamId, self.usedMineralFertilizer)
    streamWriteFloat32(streamId, self.usedMineralFertilizerRegular)

    streamWriteFloat32(streamId, self.usedLiquidFertilizer)
    streamWriteFloat32(streamId, self.usedLiquidFertilizerRegular)

    streamWriteFloat32(streamId, self.usedManure)
    streamWriteFloat32(streamId, self.usedManureRegular)

    streamWriteFloat32(streamId, self.usedLiquidManure)
    streamWriteFloat32(streamId, self.usedLiquidManureRegular)

    streamWriteFloat32(streamId, self.usedSeeds)
    streamWriteFloat32(streamId, self.usedSeedsRegular)

    streamWriteFloat32(streamId, self.yield)
    streamWriteFloat32(streamId, self.yieldRegular)
    streamWriteFloat32(streamId, self.yieldWeight)
    streamWriteFloat32(streamId, self.yieldBestPrice)

    streamWriteFloat32(streamId, self.usedFuel)
    streamWriteFloat32(streamId, self.vehicleCosts)

    streamWriteFloat32(streamId, self.helperCosts)
end
