/*
 * Decompiled with CFR 0.152.
 */
package slimon.mods.miningtools;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import slimon.mods.miningtools.Config;
import slimon.mods.miningtools.ItemsBlocks;
import slimon.mods.miningtools.Recipes;
import slimon.mods.miningtools.gui.GuiAdvIridiumDrill;
import slimon.mods.miningtools.gui.GuiHandler;
import slimon.mods.miningtools.util.BytesUtil;

@Mod(modid="MiningTools", name="Mining Tools", version="1.7.10-0.1.2", dependencies="required-after:IC2@[2.2.696-experimental,)")
public class MiningTools {
    public static MiningTools instance;
    public static CreativeTabs IC2CreativeTab;
    public static GuiAdvIridiumDrill gui;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        Config.init(cfg);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!Config.modEnabled) {
            return;
        }
        if (MiningTools.isClient()) {
            this.clientInit();
        } else {
            this.serverInit();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        ItemsBlocks.initItems();
    }

    private void clientInit() {
        for (CreativeTabs creativeTab : CreativeTabs.field_78032_a) {
            if (!creativeTab.func_78013_b().equals("IC2")) continue;
            IC2CreativeTab = creativeTab;
        }
        gui = new GuiAdvIridiumDrill();
    }

    private void serverInit() {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!Config.modEnabled) {
            return;
        }
        ItemsBlocks.postInit();
        Recipes.init();
    }

    public static void messagePlayer(EntityPlayer player, String message) {
        if (!MiningTools.isClient()) {
            ChatComponentTranslation msg = new ChatComponentTranslation(message, new Object[0]);
            player.func_145747_a((IChatComponent)msg);
        }
    }

    public static String getLocalizedString(String name) {
        return StatCollector.func_74838_a((String)("MiningTools." + name));
    }

    public static int getColor(int r, int g, int b, int a) {
        return BytesUtil.toInt(new byte[]{(byte)a, (byte)r, (byte)g, (byte)b});
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }
}

