/*
 * Decompiled with CFR 0.152.
 */
package slimon.mods.miningtools.item;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.util.Keys;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import slimon.mods.miningtools.ItemsBlocks;
import slimon.mods.miningtools.MiningTools;
import slimon.mods.miningtools.item.ToolUpgrade;
import slimon.mods.miningtools.item.UpgradeableElectricTool;
import slimon.mods.miningtools.util.WorldBlock;
import slimon.mods.miningtools.util.WorldUtil;

public class AdvIridiumDrill
extends UpgradeableElectricTool {
    private String[] containsForOreDict = new String[]{"ore", "glowstone"};
    int miningUpgrades;
    int miningModes;

    public AdvIridiumDrill() {
        super("advIridiumDrill", false, 1000000, 4, 3200, Item.ToolMaterial.EMERALD, new HashSet<Block>(Arrays.asList(Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150343_Z, Blocks.field_150426_aN)), new ToolUpgrade[0]);
        this.setPossibleUpgrades(ItemsBlocks.miningMode3x3DrillUpgrade, ItemsBlocks.miningModeOresDrillUpgrade, ItemsBlocks.pickupItemsUpgrade);
        this.miningUpgrades = 2;
        this.miningModes = 4;
        this.setHarvestLevel("pickaxe", 4);
    }

    public float getMaximumEfficiency() {
        return 36.0f;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        this.updateModes(stack, player, false);
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (!Keys.instance.isModeSwitchKeyDown(player) && !Keys.instance.isAltKeyDown(player)) {
            if (!Keys.instance.isSneakKeyDown(player)) {
                for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    Item item;
                    ItemStack torchStack = player.field_71071_by.field_70462_a[i];
                    if (torchStack == null || !torchStack.func_77977_a().toLowerCase().contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
                    int oldMeta = torchStack.func_77960_j();
                    int oldSize = torchStack.field_77994_a;
                    boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
                    if (player.field_71075_bZ.field_75098_d) {
                        torchStack.func_77964_b(oldMeta);
                        torchStack.field_77994_a = oldSize;
                    } else if (torchStack.field_77994_a <= 0) {
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                        player.field_71071_by.field_70462_a[i] = null;
                    }
                    if (!result) continue;
                    return true;
                }
            } else {
                ItemStack blockStack;
                int slotId = player.field_71071_by.field_70461_c + 1;
                if (player.field_71071_by.field_70462_a.length > slotId && (blockStack = player.field_71071_by.field_70462_a[slotId]) != null && blockStack.func_77973_b() instanceof ItemBlock) {
                    int oldMeta = blockStack.func_77960_j();
                    int oldSize = blockStack.field_77994_a;
                    boolean result = blockStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
                    if (player.field_71075_bZ.field_75098_d) {
                        blockStack.func_77964_b(oldMeta);
                        blockStack.field_77994_a = oldSize;
                    } else if (blockStack.field_77994_a <= 0) {
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)blockStack);
                        player.field_71071_by.field_70462_a[slotId] = null;
                    }
                    if (result) {
                        return true;
                    }
                }
            }
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        this.updateModes(stack, player, true);
        return super.func_77659_a(stack, world, player);
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        this.updateModes(stack, player, false);
        World world = player.func_130014_f_();
        Block block = world.func_147439_a(x, y, z);
        this.processMining(stack, world, block, x, y, z, player);
        return true;
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int x, int y, int z, EntityLivingBase entityLivingBase) {
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return ItemsBlocks.ic2IridiumDrill.canHarvestBlock(block, stack) || super.canHarvestBlock(block, stack);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return ItemsBlocks.ic2IridiumDrill.getHarvestLevel(stack, toolClass);
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.isEffective(stack, block, meta) && ElectricItem.manager.canUse(stack, (double)this.getEnergyPerBlock(stack))) {
            byte miningMode = this.getMiningMode(stack);
            float eff = this.getMaximumEfficiency();
            switch (miningMode) {
                case -2: {
                    return eff * 0.2f;
                }
                case -1: {
                    return eff;
                }
                case 0: {
                    return eff * 0.45f;
                }
                case 1: {
                    return eff * 0.25f;
                }
            }
        }
        return 1.0f;
    }

    public float getBlockHardness(Block block) {
        float hardness = 0.0f;
        try {
            Field field = Block.class.getField("blockHardness");
            field.setAccessible(true);
            hardness = field.getFloat(block);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return hardness;
    }

    private void processMining(ItemStack stack, World world, Block block, int x, int y, int z, EntityPlayer player) {
        int blockCount = 0;
        int energyPerBlock = this.getEnergyPerBlock(stack);
        int extendedModeRadius = 1;
        ToolUpgrade miningUpgrade = this.getActiveMiningUpgrade(stack);
        double charge = ElectricItem.manager.getCharge(stack);
        boolean silkTouch = this.isSilkTouchEnabled(stack);
        boolean toInventory = this.isUpgradeInstalled(stack, ItemsBlocks.pickupItemsUpgrade) && !Keys.instance.isAltKeyDown(player);
        ArrayList<Object> blocks = new ArrayList<WorldBlock>();
        if (miningUpgrade != null) {
            if (((Object)((Object)miningUpgrade)).equals((Object)ItemsBlocks.miningMode3x3DrillUpgrade)) {
                WorldBlock wb;
                blocks = WorldUtil.getBlocksSquare(world, player, x, y, z, WorldUtil.getBlockSideAtPlayerLook(world, player), extendedModeRadius, false);
                if (!blocks.contains(wb = WorldUtil.getBlockForMining(world, player, x, y, z, true))) {
                    blocks.add(WorldUtil.getBlockForMining(world, player, x, y, z, true));
                }
            } else if (((Object)((Object)miningUpgrade)).equals((Object)ItemsBlocks.miningModeOresDrillUpgrade)) {
                blocks = this.getBlocksForOreMiningMode(world, player, x, y, z, block);
            } else {
                blocks.add(WorldUtil.getBlockForMining(world, player, x, y, z, true));
            }
        } else {
            blocks.add(WorldUtil.getBlockForMining(world, player, x, y, z, true));
        }
        if (blocks != null && blocks.size() > 0) {
            if (charge < (double)(energyPerBlock * blocks.size())) {
                int enoughFor = Math.max(1, (int)charge / energyPerBlock);
                if (enoughFor == 1) {
                    toInventory = false;
                }
                if ((blockCount = WorldUtil.mineBlocks(world, player, blocks, silkTouch, 3, toInventory, enoughFor)) != 0 && blocks.size() > 1) {
                    MiningTools.messagePlayer(player, MiningTools.getLocalizedString("notEnoughEnergy"));
                }
            } else {
                blockCount = WorldUtil.mineBlocks(world, player, blocks, silkTouch, 3, toInventory);
            }
        }
        int needEnergy = energyPerBlock * blockCount;
        ElectricItem.manager.use(stack, (double)needEnergy, (EntityLivingBase)player);
    }

    private ArrayList<WorldBlock> getBlocksForOreMiningMode(World world, EntityPlayer player, int x, int y, int z, Block block) {
        if (WorldUtil.getBlockForMining(world, player, x, y, z, true) != null) {
            int meta = world.func_72805_g(x, y, z);
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)new ItemStack(block, 1, meta));
            return WorldUtil.getSameBlocksWithOreDict(world, x, y, z, oreIds, this.containsForOreDict);
        }
        return null;
    }

    private void updateModes(ItemStack stack, EntityPlayer player, boolean checkKeys) {
        boolean energyEnough;
        byte enchantment = this.getEnchantment(stack);
        int miningMode = this.getMiningMode(stack);
        boolean keysPressed = false;
        if (checkKeys) {
            if (Keys.instance.isModeSwitchKeyDown(player)) {
                if (enchantment == -1) {
                    enchantment = 0;
                } else if (enchantment == 0) {
                    enchantment = 1;
                } else if (enchantment == 1) {
                    enchantment = 0;
                }
                keysPressed = true;
            }
            if (Keys.instance.isAltKeyDown(player)) {
                int max = this.miningModes - 1;
                for (int i = -2; i < max; ++i) {
                    if ((miningMode = (byte)(miningMode + 1)) >= max) {
                        miningMode = -2;
                    }
                    if (this.isModeAvailable(stack, (byte)miningMode)) break;
                }
                keysPressed = true;
            }
        }
        boolean bl = energyEnough = ElectricItem.manager.getCharge(stack) >= (double)this.getEnergyPerBlock((byte)miningMode);
        if (energyEnough) {
            if (checkKeys) {
                this.setMiningMode(stack, (byte)miningMode);
                this.setEnchantment(stack, enchantment);
                if (keysPressed) {
                    MiningTools.messagePlayer(player, MiningTools.getLocalizedString("mode") + ": " + this.getMiningModeName((byte)miningMode) + ", " + this.getEnchantmentName(enchantment));
                }
            }
            if (enchantment == -1) {
                this.setEnchantment(stack, (byte)0);
            }
        } else {
            this.setMiningMode(stack, (byte)-1);
            this.setEnchantment(stack, (byte)-1);
            if (keysPressed) {
                MiningTools.messagePlayer(player, MiningTools.getLocalizedString("notEnoughEnergy"));
            }
        }
    }

    public boolean isModeAvailable(ItemStack stack, byte mode) {
        return mode == -1 || mode == -2 || this.isMiningUpgradeInstalled(stack, this.getUpgradeById(mode));
    }

    public boolean isMiningUpgradeInstalled(ItemStack stack, ToolUpgrade upgrade) {
        return (((Object)((Object)upgrade)).equals((Object)ItemsBlocks.miningMode3x3DrillUpgrade) || ((Object)((Object)upgrade)).equals((Object)ItemsBlocks.miningModeOresDrillUpgrade)) && this.isUpgradeInstalled(stack, upgrade);
    }

    public ToolUpgrade getActiveMiningUpgrade(ItemStack stack) {
        byte mode = this.getMiningMode(stack);
        ToolUpgrade upgrade = this.getUpgradeById(mode);
        if (this.isUpgradeInstalled(stack, upgrade)) {
            return upgrade;
        }
        return null;
    }

    @Override
    public void initNBT(ItemStack stack) {
        super.initNBT(stack);
        this.setMiningMode(stack, (byte)-1);
        this.setEnchantment(stack, (byte)-1);
    }

    public byte getMiningMode(ItemStack stack) {
        return this.getNBTByte(stack, "miningMode");
    }

    public void setMiningMode(ItemStack stack, byte miningMode) {
        this.setNBTByte(stack, "miningMode", miningMode);
    }

    public String getMiningModeName(ItemStack stack) {
        if (ElectricItem.manager.getCharge(stack) < (double)this.getEnergyPerBlock(stack)) {
            return "-";
        }
        byte mode = this.getMiningMode(stack);
        return this.getMiningModeName(mode);
    }

    public String getMiningModeName(byte mode) {
        switch (mode) {
            case -2: {
                return MiningTools.getLocalizedString("modeFine");
            }
            case -1: {
                return MiningTools.getLocalizedString("modeNormal");
            }
            case 0: {
                return MiningTools.getLocalizedString("mode3x3");
            }
            case 1: {
                return MiningTools.getLocalizedString("modeOres");
            }
            case 2: {
                return MiningTools.getLocalizedString("modePrecision");
            }
        }
        return null;
    }

    public byte getEnchantment(ItemStack stack) {
        return this.getNBTByte(stack, "enchantment");
    }

    public void setEnchantment(ItemStack stack, byte enchantment) {
        this.setNBTByte(stack, "enchantment", enchantment);
    }

    public String getEnchantmentName(byte enchantment) {
        switch (enchantment) {
            case -1: {
                return "-";
            }
            case 0: {
                return MiningTools.getLocalizedString("enchantmentFortune");
            }
            case 1: {
                return MiningTools.getLocalizedString("enchantmentSilkTouch");
            }
        }
        return null;
    }

    public int getEnergyPerBlock(ItemStack stack) {
        byte mode = this.getMiningMode(stack);
        return this.getEnergyPerBlock(mode);
    }

    public int getEnergyPerBlock(byte miningMode) {
        if (miningMode == -2) {
            return 250;
        }
        if (miningMode == -1) {
            return 1000;
        }
        if (miningMode == 0) {
            return 1500;
        }
        if (miningMode == 1) {
            return 2000;
        }
        return 0;
    }

    @Override
    public boolean isSilkTouchEnabled(ItemStack stack) {
        return this.getEnchantment(stack) == 1;
    }

    @Override
    public boolean isFortuneEnabled(ItemStack stack) {
        return this.getEnchantment(stack) == 0;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    @Override
    public ItemStack getItemStack(int charge) {
        ItemStack ret = super.getItemStack(charge);
        this.initNBT(ret);
        this.updateModes(ret, null, false);
        return ret;
    }

    public ItemStack getItemStack(int charge, ToolUpgrade[] upgrades) {
        ItemStack ret = super.getItemStack(charge);
        this.initNBT(ret);
        this.addUpgrades(ret, upgrades);
        this.updateModes(ret, null, false);
        return ret;
    }

    public ItemStack getStackForCrafting() {
        ItemStack stack = new ItemStack((Item)this, 1, Short.MAX_VALUE);
        this.initNBT(stack);
        this.updateModes(stack, null, false);
        return stack;
    }

    private String getDisplayEnergyPerBlock(ItemStack stack) {
        int energy = this.getEnergyPerBlock(stack);
        if (ElectricItem.manager.getCharge(stack) < (double)energy) {
            return "-";
        }
        return Integer.toString(energy);
    }

    @Override
    public List<String> getHudInfo(ItemStack stack) {
        ToolUpgrade[] upgrades;
        List<String> info = super.getHudInfo(stack);
        String modeName = this.getMiningModeName(stack);
        if (modeName != null) {
            info.add(MiningTools.getLocalizedString("mode") + ": " + modeName + ", " + this.getEnchantmentName(this.getEnchantment(stack)));
            info.add(MiningTools.getLocalizedString("energyPerBlock") + ": " + this.getDisplayEnergyPerBlock(stack));
        }
        if ((upgrades = this.getUpgradesInstalled(stack)) != null && upgrades[0] != null) {
            info.add("");
            if (!Keyboard.isKeyDown((int)42)) {
                info.add(MiningTools.getLocalizedString("pressShift"));
            } else {
                info.add(MiningTools.getLocalizedString("installedUpgrades") + ":");
                for (ToolUpgrade upgrade : upgrades) {
                    if (upgrade == null) continue;
                    info.add(upgrade.func_77653_i(new ItemStack((Item)upgrade)));
                }
            }
        }
        return info;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ToolUpgrade[] upgrades = new ToolUpgrade[]{ItemsBlocks.miningMode3x3DrillUpgrade, ItemsBlocks.miningModeOresDrillUpgrade, ItemsBlocks.pickupItemsUpgrade};
        itemList.add(this.getItemStack(Integer.MAX_VALUE));
        itemList.add(this.getItemStack(0));
        itemList.add(this.getItemStack(Integer.MAX_VALUE, upgrades));
        itemList.add(this.getItemStack(0, upgrades));
    }
}

