/*
 * Decompiled with CFR 0.152.
 */
package slimon.mods.miningtools.item;

import ic2.api.item.IBoxable;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeHooks;
import slimon.mods.miningtools.ItemsBlocks;

public class BaseTool
extends ItemTool
implements IBoxable {
    private Set<Block> mineableBlocks;
    String name;

    public BaseTool(String name, Item.ToolMaterial material, Set<Block> mineableBlocks) {
        super(0.0f, material, mineableBlocks);
        this.name = name;
        ItemsBlocks.registerItem((Item)this, name);
        this.mineableBlocks = mineableBlocks;
    }

    public String getLocalizedString(String name) {
        return StatCollector.func_74838_a((String)("MiningTools." + this.name + "." + name));
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        if (this.isEffective(tool, block, meta)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public boolean isEffective(ItemStack tool, Block block, int meta) {
        return this.mineableBlocks.contains(block) || ForgeHooks.isToolEffective((ItemStack)tool, (Block)block, (int)meta);
    }

    public int getNBTInt(ItemStack stack, String name) {
        if (stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(name)) {
            return stack.func_77978_p().func_74762_e(name);
        }
        return 0;
    }

    public void setNBTInt(ItemStack stack, String name, int i) {
        if (stack != null && stack.func_77978_p() != null) {
            stack.func_77978_p().func_74768_a(name, i);
        }
    }

    public byte getNBTByte(ItemStack stack, String name) {
        if (stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(name)) {
            return stack.func_77978_p().func_74771_c(name);
        }
        return 0;
    }

    public void setNBTByte(ItemStack stack, String name, byte i) {
        if (stack != null && stack.func_77978_p() != null) {
            stack.func_77978_p().func_74774_a(name, i);
        }
    }

    public boolean getNBTBoolean(ItemStack stack, String name) {
        if (stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(name)) {
            return stack.func_77978_p().func_74767_n(name);
        }
        return false;
    }

    public void setNBTBoolean(ItemStack stack, String name, boolean b) {
        if (stack != null && stack.func_77978_p() != null) {
            stack.func_77978_p().func_74757_a(name, b);
        }
    }

    public boolean isSilkTouchEnabled(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) != 0;
    }

    public boolean isFortuneEnabled(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack) != 0;
    }

    public boolean canBeStoredInToolbox(ItemStack itemStack) {
        return true;
    }
}

