/*
 * Decompiled with CFR 0.152.
 */
package slimon.mods.miningtools.item;

import ic2.api.item.ElectricItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import slimon.mods.miningtools.MiningTools;
import slimon.mods.miningtools.item.BaseElectricItem;
import slimon.mods.miningtools.util.WorldUtil;

public class Electromagnet
extends BaseElectricItem {
    public Electromagnet() {
        super("electromagnet", false, 100000, 2, 1000);
    }

    public int energyPerOperation() {
        return 1;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int tick, boolean b) {
        super.func_77663_a(stack, world, entity, tick, b);
        if (this.isEnabled(stack) && entity instanceof EntityLivingBase) {
            double charge;
            double radius = 16.0;
            double velocity = 0.5;
            ArrayList<Entity> entityItems = WorldUtil.getItemAndXPEntitiesAroundEntity(world, entity, radius);
            int count = 0;
            int max = 30;
            for (Entity item : entityItems) {
                if (count > max) break;
                if (item instanceof EntityItem && ((EntityItem)item).field_145804_b != 0) continue;
                Vec3 vec = Vec3.func_72443_a((double)(entity.field_70165_t - item.field_70165_t), (double)(entity.field_70163_u - item.field_70163_u), (double)(entity.field_70161_v - item.field_70161_v)).func_72432_b();
                double distance = entity.func_70032_d(item);
                double velX = vec.field_72450_a * velocity / Math.max(1.0, distance);
                double velY = vec.field_72448_b * velocity / Math.max(1.0, distance);
                double velZ = vec.field_72449_c * velocity / Math.max(1.0, distance);
                if (!MiningTools.isClient()) {
                    item.func_70024_g(velX, velY, velZ);
                    ElectricItem.manager.use(stack, (double)this.energyPerOperation(), (EntityLivingBase)entity);
                }
                ++count;
            }
            if ((charge = ElectricItem.manager.getCharge(stack)) < (double)this.energyPerOperation()) {
                this.disable(stack);
            }
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        double charge = ElectricItem.manager.getCharge(stack);
        if (charge < (double)this.energyPerOperation() && !this.isEnabled(stack)) {
            ElectricItem.manager.use(stack, 0.0, (EntityLivingBase)player);
        }
        if ((charge = ElectricItem.manager.getCharge(stack)) < (double)this.energyPerOperation()) {
            this.disable(stack);
            MiningTools.messagePlayer(player, MiningTools.getLocalizedString("notEnoughEnergy"));
        } else if (this.isEnabled(stack)) {
            this.disable(stack);
            MiningTools.messagePlayer(player, MiningTools.getLocalizedString("disabled"));
        } else {
            this.enable(stack);
            MiningTools.messagePlayer(player, MiningTools.getLocalizedString("enabled"));
        }
        return super.func_77659_a(stack, world, player);
    }

    public byte getMode(ItemStack stack) {
        return this.getNBTByte(stack, "mode");
    }

    public void setMode(ItemStack stack, byte mode) {
        this.setNBTByte(stack, "mode", mode);
    }

    public boolean isEnabled(ItemStack stack) {
        return this.getMode(stack) != 0;
    }

    public void enable(ItemStack stack) {
        this.setMode(stack, (byte)1);
    }

    public void disable(ItemStack stack) {
        this.setMode(stack, (byte)0);
    }

    @Override
    public List<String> getHudInfo(ItemStack stack) {
        List<String> info = super.getHudInfo(stack);
        if (this.isEnabled(stack)) {
            info.add(MiningTools.getLocalizedString("enabled"));
        } else {
            info.add(MiningTools.getLocalizedString("disabled"));
        }
        return info;
    }
}

