/*
 * Decompiled with CFR 0.152.
 */
package slimon.mods.miningtools.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimon.mods.miningtools.item.BaseElectricTool;
import slimon.mods.miningtools.item.ToolUpgrade;

public abstract class UpgradeableElectricTool
extends BaseElectricTool {
    private ToolUpgrade[] upgrades;

    public UpgradeableElectricTool(String name, boolean canProvideEnergy, int storage, int tier, int transferLimit, Item.ToolMaterial toolMaterial, Set<Block> mineableBlocks, ToolUpgrade ... possibleUpgrades) {
        super(name, canProvideEnergy, storage, tier, transferLimit, toolMaterial, mineableBlocks);
        this.setPossibleUpgrades(possibleUpgrades);
    }

    public UpgradeableElectricTool(String name, boolean canProvideEnergy, int storage, int tier, int transferLimit, Item.ToolMaterial toolMaterial, ToolUpgrade ... possibleUpgrades) {
        super(name, canProvideEnergy, storage, tier, transferLimit, toolMaterial);
        this.setPossibleUpgrades(possibleUpgrades);
    }

    public void initNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.setDefaultUpgrades(stack);
    }

    public void setPossibleUpgrades(ToolUpgrade ... possibleUpgrades) {
        ArrayList<ToolUpgrade> upgrades = new ArrayList<ToolUpgrade>(possibleUpgrades.length);
        for (ToolUpgrade upgrade : possibleUpgrades) {
            if (upgrade == null) continue;
            upgrades.add(upgrade);
        }
        this.upgrades = upgrades.toArray(new ToolUpgrade[upgrades.size()]);
    }

    public void setDefaultUpgrades(ItemStack stack) {
        byte[] upgrades = new byte[this.upgrades.length];
        Arrays.fill(upgrades, (byte)-1);
        this.setUpgrades(stack, upgrades);
    }

    public void setUpgrades(ItemStack stack, byte[] upgrades) {
        if (stack.func_77978_p() == null) {
            this.initNBT(stack);
        }
        stack.func_77978_p().func_74773_a("upgrades", upgrades);
    }

    public byte getUpgradeId(ToolUpgrade upgrade) {
        if (this.upgrades != null) {
            for (byte i = 0; i < this.upgrades.length; i = (byte)(i + 1)) {
                if (!((Object)((Object)upgrade)).equals((Object)this.upgrades[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public ToolUpgrade getUpgradeById(byte id) {
        if (id > -1 && id < this.upgrades.length) {
            return this.upgrades[id];
        }
        return null;
    }

    public void addUpgrade(ItemStack stack, ToolUpgrade upgrade) {
        byte[] upgrades = this.getUpgrades(stack);
        for (int i = 0; i < upgrades.length; i = (int)((byte)(i + 1))) {
            if (upgrades[i] != -1 || !this.isUpgradePossible(upgrade)) continue;
            upgrades[i] = this.getUpgradeId(upgrade);
            break;
        }
    }

    public void addUpgrades(ItemStack stack, ToolUpgrade[] upgrades) {
        for (ToolUpgrade upgrade : upgrades) {
            this.addUpgrade(stack, upgrade);
        }
    }

    public byte[] getUpgrades(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77978_p() == null) {
                this.initNBT(stack);
            }
            return stack.func_77978_p().func_74770_j("upgrades");
        }
        return null;
    }

    public byte[] copyUpgrades(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77978_p() == null) {
                this.initNBT(stack);
            }
            byte[] upgrades = stack.func_77978_p().func_74770_j("upgrades");
            byte[] array = new byte[upgrades.length];
            System.arraycopy(upgrades, 0, array, 0, upgrades.length);
            return array;
        }
        return null;
    }

    public ToolUpgrade[] getUpgradesInstalled(ItemStack stack) {
        byte[] array = this.getUpgrades(stack);
        ToolUpgrade[] upgrades = null;
        if (array != null && array.length > 0) {
            upgrades = new ToolUpgrade[array.length];
            for (int i = 0; i < array.length; ++i) {
                upgrades[i] = this.getUpgradeById(array[i]);
            }
        }
        return upgrades;
    }

    public boolean isUpgradePossible(ToolUpgrade upgrade) {
        if (this.upgrades != null) {
            for (ToolUpgrade possible : this.upgrades) {
                if (!((Object)((Object)possible)).equals((Object)upgrade)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUpgradeInstalled(ItemStack stack, ToolUpgrade upgrade) {
        byte[] upgradeIds;
        if (upgrade == null) {
            return true;
        }
        if (this.upgrades != null && (upgradeIds = this.getUpgrades(stack)) != null) {
            for (byte i : this.getUpgrades(stack)) {
                if (i <= -1 || this.upgrades.length <= i || !((Object)((Object)this.upgrades[i])).equals((Object)upgrade)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUpgradesInstalled(ItemStack stack, ToolUpgrade ... upgrades) {
        for (ToolUpgrade upgrade : upgrades) {
            if (!this.isUpgradeInstalled(stack, upgrade)) continue;
            return true;
        }
        return false;
    }

    public int upgradesInstalled(ItemStack stack, ToolUpgrade ... upgrades) {
        int installed = 0;
        for (ToolUpgrade upgrade : upgrades) {
            if (!this.isUpgradeInstalled(stack, upgrade)) continue;
            ++installed;
        }
        return installed;
    }
}

