/*
 * Decompiled with CFR 0.152.
 */
package slimon.mods.miningtools.util;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.oredict.OreDictionary;
import slimon.mods.miningtools.MiningTools;
import slimon.mods.miningtools.util.PlayerUtil;
import slimon.mods.miningtools.util.RayTrace;
import slimon.mods.miningtools.util.WorldBlock;

public class WorldUtil {
    public static boolean harvestBlock(World world, EntityPlayer player, int x, int y, int z, boolean silkTouch, int fortune) {
        Block block = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        float hardness = block.func_149712_f(world, x, y, z);
        ArrayList<ItemStack> drops = WorldUtil.getBlockDrops(world, player, x, y, z, silkTouch, fortune);
        ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (Block)block, (int)x, (int)y, (int)z, (int)blockMeta, (int)fortune, (float)1.0f, (boolean)silkTouch, (EntityPlayer)player);
        WorldUtil.createItemStacksInWorld(world, x, y, z, drops, 10);
        if (!silkTouch) {
            block.func_149657_c(world, x, y, z, block.getExpDrop((IBlockAccess)world, blockMeta, fortune));
        }
        WorldUtil.playBlockBreakSound(world, x, y, z, block);
        if (MiningTools.isClient()) {
            Minecraft.func_71410_x().field_71452_i.func_147215_a(x, y, z, block, blockMeta);
        }
        world.func_147468_f(x, y, z);
        world.func_147475_p(x, y, z);
        player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        player.func_71020_j(0.005f);
        return hardness != 0.0f;
    }

    public static void playBlockBreakSound(World world, int x, int y, int z, Block block) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
    }

    public static boolean removeBlock(World world, EntityPlayer player, int x, int y, int z, boolean ignoreTile) {
        WorldBlock wb = WorldUtil.getBlockForMining(world, player, x, y, z, ignoreTile);
        if (wb != null) {
            world.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    public static boolean blockIsHard(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        float hardness = block.func_149712_f(world, x, y, z);
        return hardness != 0.0f;
    }

    public static ArrayList<ItemStack> getBlockDrops(World world, EntityPlayer player, int x, int y, int z, boolean silkTouch, int fortune) {
        ArrayList<ItemStack> drops;
        Block block = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        if (silkTouch && block.canSilkHarvest(world, player, x, y, z, blockMeta)) {
            drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack(block, 1, blockMeta));
        } else {
            drops = block.getDrops(world, x, y, z, blockMeta, fortune);
        }
        return drops;
    }

    public static void createItemStackInWorld(World world, int x, int y, int z, ItemStack stack, int delayBeforePickup) {
        if (!MiningTools.isClient() && stack != null) {
            EntityItem entity = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
            entity.field_145804_b = delayBeforePickup;
            world.func_72838_d((Entity)entity);
        }
    }

    public static void createItemStacksInWorld(World world, int x, int y, int z, ArrayList<ItemStack> stacks, int delayBeforePickup) {
        if (!MiningTools.isClient()) {
            for (ItemStack stack : stacks) {
                if (stack == null) continue;
                EntityItem entity = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
                entity.field_145804_b = delayBeforePickup;
                world.func_72838_d((Entity)entity);
            }
        }
    }

    public static WorldBlock getBlockForMining(World world, EntityPlayer player, int x, int y, int z, boolean ignoreTile) {
        Block block = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        float hardness = block.func_149712_f(world, x, y, z);
        if (!(!world.func_72962_a(player, x, y, z) || !ignoreTile && block.hasTileEntity(blockMeta) || hardness == -1.0f || block.func_149688_o().func_76224_d() || block.equals(Blocks.field_150350_a))) {
            return new WorldBlock(x, y, z);
        }
        return null;
    }

    public static ArrayList<WorldBlock> getBlocksSquare(World world, EntityPlayer player, int x, int y, int z, int side, int radius, boolean ignoreTile) {
        int i;
        WorldBlock wb;
        int n;
        ArrayList<WorldBlock> blocks = new ArrayList<WorldBlock>();
        blocks.add(WorldUtil.getBlockForMining(world, player, x, y, z, ignoreTile));
        if (!WorldUtil.blockIsHard(world, x, y, z)) {
            return blocks;
        }
        int dX = radius;
        int dY = radius;
        int dZ = radius;
        if (side / 2 == 0) {
            dY = 0;
        }
        if (side / 2 == 1) {
            dZ = 0;
        }
        if (side / 2 == 2) {
            dX = 0;
        }
        if (dX == 0) {
            for (int k = y - dY; k <= y + dY; ++k) {
                for (n = z - dZ; n <= z + dZ; ++n) {
                    if (k == y && n == z || (wb = WorldUtil.getBlockForMining(world, player, x, k, n, ignoreTile)) == null) continue;
                    blocks.add(wb);
                }
            }
        }
        if (dY == 0) {
            for (i = x - dX; i <= x + dX; ++i) {
                for (n = z - dZ; n <= z + dZ; ++n) {
                    if (i == x && n == z || (wb = WorldUtil.getBlockForMining(world, player, i, y, n, ignoreTile)) == null) continue;
                    blocks.add(wb);
                }
            }
        }
        if (dZ == 0) {
            for (i = x - dX; i <= x + dX; ++i) {
                for (int k = y - dY; k <= y + dY; ++k) {
                    if (i == x && k == y || (wb = WorldUtil.getBlockForMining(world, player, i, k, z, ignoreTile)) == null) continue;
                    blocks.add(wb);
                }
            }
        }
        return blocks;
    }

    @Deprecated
    public static int mineBlocksSquare(World world, EntityPlayer player, int x, int y, int z, int side, int radius, boolean silkTouch, int fortune) {
        int i;
        int n;
        int blocks = 0;
        int dX = radius;
        int dY = radius;
        int dZ = radius;
        if (side / 2 == 0) {
            dY = 0;
        }
        if (side / 2 == 1) {
            dZ = 0;
        }
        if (side / 2 == 2) {
            dX = 0;
        }
        if (dX == 0) {
            for (int k = y - dY; k <= y + dY; ++k) {
                for (n = z - dZ; n <= z + dZ; ++n) {
                    if (!WorldUtil.harvestBlock(world, player, x, k, n, silkTouch, fortune)) continue;
                    ++blocks;
                }
            }
        }
        if (dY == 0) {
            for (i = x - dX; i <= x + dX; ++i) {
                for (n = z - dZ; n <= z + dZ; ++n) {
                    if (!WorldUtil.harvestBlock(world, player, i, y, n, silkTouch, fortune)) continue;
                    ++blocks;
                }
            }
        }
        if (dZ == 0) {
            for (i = x - dX; i <= x + dX; ++i) {
                for (int k = y - dY; k <= y + dY; ++k) {
                    if (!WorldUtil.harvestBlock(world, player, i, k, z, silkTouch, fortune)) continue;
                    ++blocks;
                }
            }
        }
        return blocks;
    }

    public static WorldBlock getWorldBlockAtSide(int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --x;
                break;
            }
            case 3: {
                ++x;
                break;
            }
            case 4: {
                --z;
                break;
            }
            case 5: {
                ++z;
            }
        }
        return new WorldBlock(x, y, z);
    }

    public static ArrayList<WorldBlock> getSameBlocks(World world, int x, int y, int z, Block block, int meta) {
        return WorldUtil.getSameBlocks(world, x, y, z, block, meta, new ArrayList<WorldBlock>());
    }

    private static ArrayList<WorldBlock> getSameBlocks(World world, int x, int y, int z, Block block, int meta, ArrayList<WorldBlock> blocks) {
        ArrayList<WorldBlock> temp = new ArrayList<WorldBlock>(6);
        for (int i = 0; i < 6; ++i) {
            WorldBlock wb = WorldUtil.getWorldBlockAtSide(x, y, z, i);
            Block b = world.func_147439_a(wb.x, wb.y, wb.z);
            int m = world.func_72805_g(wb.x, wb.y, wb.z);
            if (blocks.contains(wb) || !b.equals(block) || m != meta) continue;
            temp.add(wb);
            blocks.add(wb);
        }
        for (WorldBlock aTemp : temp) {
            WorldUtil.getSameBlocks(world, aTemp.x, aTemp.y, aTemp.z, block, meta, blocks);
        }
        return blocks;
    }

    public static ArrayList<WorldBlock> getSameBlocksWithOreDict(World world, int x, int y, int z, int[] oreIds, String[] contains) {
        ArrayList<ItemStack> needBlocks = new ArrayList<ItemStack>();
        if (oreIds != null && oreIds.length != 0) {
            block0: for (int id : oreIds) {
                String s = OreDictionary.getOreName((int)id);
                for (String c : contains) {
                    if (!s.contains(c)) continue;
                    needBlocks.addAll(OreDictionary.getOres((String)s));
                    continue block0;
                }
            }
        }
        return WorldUtil.getSameBlocks(world, x, y, z, needBlocks);
    }

    public static ArrayList<WorldBlock> getSameBlocksWithOreDict(World world, int x, int y, int z, String name) {
        ArrayList needBlocks = OreDictionary.getOres((String)name);
        return WorldUtil.getSameBlocks(world, x, y, z, needBlocks);
    }

    public static ArrayList<WorldBlock> getSameBlocks(World world, int x, int y, int z, ArrayList<ItemStack> needBlocks) {
        ArrayList<WorldBlock> blocks = new ArrayList<WorldBlock>();
        blocks.add(new WorldBlock(x, y, z));
        if (needBlocks == null || needBlocks.size() == 0) {
            return blocks;
        }
        return WorldUtil.getSameBlocks(world, x, y, z, needBlocks, blocks);
    }

    private static ArrayList<WorldBlock> getSameBlocks(World world, int x, int y, int z, ArrayList<ItemStack> needBlocks, ArrayList<WorldBlock> blocks) {
        ArrayList<WorldBlock> temp = new ArrayList<WorldBlock>(6);
        for (int i = 0; i < 6; ++i) {
            if (blocks.size() >= 512) {
                return blocks;
            }
            WorldBlock wb = WorldUtil.getWorldBlockAtSide(x, y, z, i);
            Block b = world.func_147439_a(wb.x, wb.y, wb.z);
            int m = world.func_72805_g(wb.x, wb.y, wb.z);
            if (blocks.contains(wb)) continue;
            for (ItemStack need : needBlocks) {
                if (!Block.func_149634_a((Item)need.func_77973_b()).equals(b) || need.func_77960_j() != m) continue;
                temp.add(wb);
                blocks.add(wb);
            }
        }
        for (WorldBlock aTemp : temp) {
            WorldUtil.getSameBlocks(world, aTemp.x, aTemp.y, aTemp.z, needBlocks, blocks);
        }
        return blocks;
    }

    public static int mineBlocks(World world, EntityPlayer player, ArrayList<WorldBlock> blocks, boolean silkTouch, int fortune, boolean toInventory) {
        return WorldUtil.mineBlocks(world, player, blocks, silkTouch, fortune, toInventory, blocks.size());
    }

    public static int mineBlocks(World world, EntityPlayer player, ArrayList<WorldBlock> blocks, boolean silkTouch, int fortune, boolean toInventory, int max) {
        if (toInventory) {
            return WorldUtil.mineBlocksToInventory(world, player, blocks, max, silkTouch, fortune);
        }
        return WorldUtil.mineBlocksToWorld(world, player, blocks, max, silkTouch, fortune);
    }

    public static int mineBlocksToWorld(World world, EntityPlayer player, ArrayList<WorldBlock> blocks, boolean silkTouch, int fortune) {
        return WorldUtil.mineBlocksToWorld(world, player, blocks, blocks.size(), silkTouch, fortune);
    }

    public static int mineBlocksToWorld(World world, EntityPlayer player, ArrayList<WorldBlock> blocks, int max, boolean silkTouch, int fortune) {
        int mined = 0;
        for (int i = 0; i < Math.min(blocks.size(), max); ++i) {
            WorldBlock block = blocks.get(i);
            if (!WorldUtil.harvestBlock(world, player, block.x, block.y, block.z, silkTouch, fortune)) continue;
            ++mined;
        }
        return mined;
    }

    public static int mineBlocksToInventory(World world, EntityPlayer player, ArrayList<WorldBlock> blocks, boolean silkTouch, int fortune) {
        return WorldUtil.mineBlocksToInventory(world, player, blocks, blocks.size(), silkTouch, fortune);
    }

    public static int mineBlocksToInventory(World world, EntityPlayer player, ArrayList<WorldBlock> blocks, int max, boolean silkTouch, int fortune) {
        int mined = 0;
        for (int i = 0; i < Math.min(blocks.size(), max); ++i) {
            WorldBlock wb = blocks.get(i);
            if (wb == null || !WorldUtil.mineBlockToInventory(world, player, wb, silkTouch, fortune)) continue;
            ++mined;
        }
        return mined;
    }

    public static boolean mineBlockToInventory(World world, EntityPlayer player, WorldBlock wb, boolean silkTouch, int fortune) {
        int exp;
        Block block = world.func_147439_a(wb.x, wb.y, wb.z);
        int blockMeta = world.func_72805_g(wb.x, wb.y, wb.z);
        ArrayList<ItemStack> drops = WorldUtil.getBlockDrops(world, player, wb.x, wb.y, wb.z, silkTouch, fortune);
        ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (Block)block, (int)wb.x, (int)wb.y, (int)wb.z, (int)blockMeta, (int)fortune, (float)1.0f, (boolean)silkTouch, (EntityPlayer)player);
        if (!silkTouch && (exp = block.getExpDrop((IBlockAccess)world, blockMeta, fortune)) > 0) {
            player.field_71090_bL = 2;
            world.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((float)(Math.random() - Math.random()) * 0.7f + 1.8f));
            player.func_71023_q(exp);
        }
        boolean isHard = WorldUtil.blockIsHard(world, wb.x, wb.y, wb.z);
        WorldUtil.playBlockBreakSound(world, wb.x, wb.y, wb.z, block);
        if (MiningTools.isClient()) {
            Minecraft.func_71410_x().field_71452_i.func_147215_a(wb.x, wb.y, wb.z, block, blockMeta);
        }
        world.func_147468_f(wb.x, wb.y, wb.z);
        world.func_147475_p(wb.x, wb.y, wb.z);
        player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)world.func_147439_a(wb.x, wb.y, wb.z))], 1);
        player.func_71020_j(0.005f);
        if (drops != null) {
            drops = PlayerUtil.addToInventory(player, drops);
            WorldUtil.createItemStacksInWorld(world, wb.x, wb.y, wb.z, drops, 2);
        }
        return isHard;
    }

    public static int getBlockSideAtPlayerLook(World world, EntityPlayer player) {
        MovingObjectPosition mop = RayTrace.rayTraceBlockFromPlayer(world, player, 5.0);
        if (mop != null) {
            return mop.field_72310_e;
        }
        return -1;
    }

    public static boolean createLightingBolt(World world, int x, int y, int z, boolean createFire) {
        if (world.func_72937_j(x, y, z)) {
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z));
            if (createFire) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
            }
            return true;
        }
        return false;
    }

    public static ArrayList<EntityItem> getItemEntitiesAroundEntity(World world, Entity entity, double radius) {
        ArrayList<EntityItem> entities = new ArrayList<EntityItem>();
        for (Object obj : world.field_72996_f) {
            EntityItem entityItem;
            if (!(obj instanceof EntityItem) || !((entityItem = (EntityItem)obj).func_70068_e(entity) <= radius * radius)) continue;
            entities.add(entityItem);
        }
        return entities;
    }

    public static ArrayList<Entity> getItemAndXPEntitiesAroundEntity(World world, Entity entity, double radius) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Object obj : world.field_72996_f) {
            Entity entityItem;
            if (!(obj instanceof EntityItem) && !(obj instanceof EntityXPOrb) || !((entityItem = (Entity)obj).func_70068_e(entity) <= radius * radius)) continue;
            entities.add(entityItem);
        }
        return entities;
    }

    public static ArrayList<EntityItem> getItemEntitiesAround(World world, double x, double y, double z, double radius) {
        ArrayList<EntityItem> entities = new ArrayList<EntityItem>();
        for (Object obj : world.field_72996_f) {
            EntityItem entityItem;
            if (!(obj instanceof EntityItem) || !((entityItem = (EntityItem)obj).func_70092_e(x, y, z) <= radius * radius)) continue;
            entities.add(entityItem);
        }
        return entities;
    }
}

