/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.inventory;

import de.eydamos.backpack.helper.InventoryHelper;
import de.eydamos.backpack.inventory.AbstractInventoryBackpack;
import de.eydamos.backpack.saves.BackpackSave;
import net.minecraft.item.ItemStack;

public class InventoryPickup
extends AbstractInventoryBackpack<BackpackSave> {
    protected boolean changeable;

    public InventoryPickup() {
        this.stackLimit = 1;
        this.defaultName = "text.backpack.autopickup";
        this.inventoryContent = new ItemStack[9];
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack newContent) {
        if (this.changeable) {
            super.func_70299_a(slotIndex, newContent);
            if (this.eventHandler != null) {
                this.eventHandler.func_75130_a(this);
            }
        }
    }

    @Override
    public void readFromNBT(BackpackSave backpackSave) {
        InventoryHelper.readInventory(backpackSave, "pickupItems", this.inventoryContent);
    }

    @Override
    public void writeToNBT(BackpackSave backpackSave) {
        if (this.isDirty) {
            InventoryHelper.writeInventory(backpackSave, "pickupItems", this.inventoryContent);
            this.isDirty = false;
        }
    }

    public void setInventoryContent(ItemStack backpack) {
        if (backpack == null) {
            this.inventoryContent = new ItemStack[9];
            this.changeable = false;
        } else {
            this.readFromNBT(new BackpackSave(backpack));
            this.changeable = true;
        }
    }
}

