local assets =
{
    Asset("ANIM", "anim/luya.zip"),
    Asset("ANIM", "anim/luya_sw.zip"),
	Asset("ATLAS", "images/inventoryimages/luya.xml"),
    Asset("IMAGE", "images/inventoryimages/luya.tex"),
}

local miao = 0

local function getspawnlocation(inst, target)
    local x1, y1, z1 = inst.Transform:GetWorldPosition()
    local x2, y2, z2 = target.Transform:GetWorldPosition()
    return x1 + .15 * (x2 - x1), 0, z1 + .15 * (z2 - z1)
end

local function spawntornado(staff, target, pos)
if staff.components.fueled.currentfuel > 30 then
    local tornado = SpawnPrefab("tornado")
    tornado.WINDSTAFF_CASTER = staff.components.inventoryitem.owner
    tornado.WINDSTAFF_CASTER_ISPLAYER = tornado.WINDSTAFF_CASTER ~= nil and tornado.WINDSTAFF_CASTER:HasTag("player")
    tornado.Transform:SetPosition(getspawnlocation(staff, target))
    tornado.components.knownlocations:RememberLocation("target", target:GetPosition())

    if tornado.WINDSTAFF_CASTER_ISPLAYER then
        tornado.overridepkname = tornado.WINDSTAFF_CASTER:GetDisplayName()
        tornado.overridepkpet = true
    end
    staff.components.finiteuses:Use(1)
	staff.components.fueled.currentfuel = staff.components.fueled.currentfuel - 30
	staff:AddTag("feng")
	miao = miao + 10
	else
	local caster = staff.components.inventoryitem.owner
			caster.components.talker:Say("武器没有能量了") 
	end
	end



local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object","luya_sw","luya")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
    end
	
local function onattack(inst, owner, target)
if inst.components.fueled.currentfuel<180 then
		inst.components.fueled.currentfuel = inst.components.fueled.currentfuel + 10
		elseif inst.components.fueled.currentfuel < 0   then
		inst.components.fueled.currentfuel = 0
		end
if inst:HasTag("feng") then
if math.random() < 0.35 and inst.components.fueled.currentfuel > 30 then
	local tornado = SpawnPrefab("tornado")
    tornado.WINDSTAFF_CASTER = inst.components.inventoryitem.owner
	tornado.Transform:SetPosition(getspawnlocation(inst, target))
	tornado.components.knownlocations:RememberLocation("target", target:GetPosition())
	inst.components.fueled.currentfuel = inst.components.fueled.currentfuel - 30
		end
		miao = miao + 3
		end	
end
	
local function fn()
     local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    inst.entity:SetPristine()
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("luya.tex")
    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:SetBank("luya")
    inst.AnimState:SetBuild("luya")
    inst.AnimState:PlayAnimation("idle")

	inst:DoPeriodicTask(1, function() miao = miao - 1 
	if miao > 30 then
	miao = 30 
	elseif miao < 0 then
	inst:RemoveTag("feng")
	miao = 0
	end
	end)

    inst:AddComponent("tool")
   
    inst:AddTag("sharp")
	
	inst:AddComponent("fueled")
    inst.components.fueled:InitializeFuelLevel(180)
	inst.components.fueled.fueltype = "NIGHTMARE"
	inst.components.fueled.accepting = true
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(68)
	inst.components.weapon.onattack = onattack
    inst.components.weapon:SetRange(1,2)

    inst:AddComponent("inspectable")
	
	inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canonlyuseonworkable = true
    inst.components.spellcaster.canonlyuseoncombat = true
    inst.components.spellcaster.quickcast = true
    inst.components.spellcaster:SetSpellFn(spawntornado)
    inst.components.spellcaster.castingstate = "castspell_tornado"

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(1000)
    inst.components.finiteuses:SetUses(1000)   
    inst.components.finiteuses:SetOnFinished( onfinished )
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/luya.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip ) 
    return inst
end

return Prefab("luya", fn, assets, prefabs)


