//index.js
const app = getApp()
Page({
    data: {
        imgg:app.globalData.imgSrc,
        gq1: '/images/gq1.png',
        gq2: '/images/gq2.png',
        gq3: '/images/gq3.png',
    },
    onShow: function () {
        this.setData({
            imgg:app.globalData.imgSrc
        })
        this.create()
    },
    bindGetUserInfo (e) {
        const that = this
        wx.getSetting({
            success (res){
              if (res.authSetting['scope.userInfo']) {
                // 已经授权，可以直接调用 getUserInfo 获取头像昵称
                wx.getUserInfo({
                  success: function(res) {
                    wx.downloadFile({
                        url: res.userInfo.avatarUrl,
                        success (res) {
                            console.log(res.tempFilePath)
                          if (res.statusCode === 200) {
                            that.setData({
                                imgg:res.tempFilePath
                            })
                            that.create()
                          }
                        }
                    })
                    
                  }
                })
              }
            }
        })
    },
    changegq: function (e) {
        var gq = e.currentTarget.dataset.g;
        var ctx = wx.createCanvasContext('canvas')
        ctx.drawImage(this.data.imgg, 10, 10, 280, 280);
        if(gq==1){
            ctx.drawImage(this.data.gq1, 202, 210, 90, 90);
            ctx.draw()
        }else if(gq==2){
            ctx.drawImage(this.data.gq2, 200, 202, 90, 90);
            ctx.draw()
        }else{
            ctx.drawImage(this.data.gq3, 200, 202, 90, 90);
            ctx.draw()
        }
    },
    create: function () {
        var ctx = wx.createCanvasContext('canvas')
        ctx.drawImage(this.data.imgg, 10, 10, 280, 280);
        ctx.draw()
    },
    add: function (gq) {
        var ctx = wx.createCanvasContext('canvas')
        ctx.drawImage(this.data.imgg, 10, 10, 280, 280);
        ctx.drawImage(gq, 202, 210, 90, 90);
        ctx.draw()
    },
    saveImage() {
        wx.canvasToTempFilePath({
            canvasId: 'canvas',
            success(res) {
                wx.getSetting({
                    success: (auth) => {
                        if (!auth.authSetting['scope.writePhotosAlbum']) {
                            wx.authorize({
                                scope: 'scope.writePhotosAlbum',
                                success() {
                                    console.log("authorize", res)
                                },
                                fail() {
                                    wx.showModal({
                                        title: '提示',
                                        content: '若点击不授权，将无法使用保存图片功能',
                                        cancelText: '不授权',
                                        cancelColor: '#999',
                                        confirmText: '授权',
                                        confirmColor: '#f94218',
                                        success(res) {
                                            if (res.confirm) {
                                                wx.openSetting()
                                            } else if (res.cancel) {
                                                console.log('用户点击取消')
                                            }
                                        }
                                    })
                                }
                            })
                        } else {
                            wx.saveImageToPhotosAlbum({
                                filePath: res.tempFilePath,
                                success(res) {
                                    wx.showToast({
                                        title: '保存成功!',
                                        icon: 'success'
                                    })
                                },
                                fail(res) {
                                    wx.showToast({
                                        title: '保存失败，请允许保存相册权限',
                                        icon: 'none'
                                    })
                                }
                            })
                        }
                    }
                })
            }
        })
    },
    onShareAppMessage: function (res) {
        return {
            title: '不要@微信官方啦，我就可以给你小国旗！！！',
            path: '/pages/avatar/index'
        }
    },
    onShareTimeline() {
        return {
            title: '不要@微信官方啦，我就可以给你小国旗！！！'
        }
    },
    bindinput(e) {
        const that = this
        wx.serviceMarket.invokeService({
            service: 'wxee446d7507c68b11',
            api: 'msgSecCheck',
            data: {
                "Action": "TextApproval",
                "Text": e.detail.value
            },
        }).then(res => {
            var datas = res.data
            if (typeof (datas) == 'string') {
                datas = JSON.parse(res.data)
            }
            if (datas.Response.EvilTokens != '') {
                wx.showModal({
                    title: '请勿输入敏感内容！',
                    showCancel: false
                })
                return false;
            } else {
                that.setData({
                    text: e.detail.value
                })
                that.createImg()
            }
        })
        // const that = this
        // wx.cloud.callFunction({
        //   name: 'tools',
        //   data: {
        //     action: 'jiance',
        //     text:e.detail.value
        //   },
        //   success: function(res) {
        //     console.log(res)
        //     if(res.result.data.spam==1){
        //       wx.showModal({
        //         title: 'cost',
        //       })
        //     }
        //   },
        //   fail: console.error
        // })
    },
})