/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.DebugLineList;
import me.cominixo.betterf3.utils.PositionEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;

public abstract class BaseModule {
    public Color nameColor;
    public Color valueColor;
    public Color defaultNameColor;
    public Color defaultValueColor;
    public boolean enabled = true;
    protected List<DebugLine> lines = new ArrayList<DebugLine>();
    public static List<BaseModule> modules = new ArrayList<BaseModule>();
    public static List<BaseModule> modulesRight = new ArrayList<BaseModule>();
    public static List<BaseModule> allModules = new ArrayList<BaseModule>();
    public String id = this.getClass().getSimpleName().replace("Module", "").toLowerCase();

    public BaseModule() {
    }

    public BaseModule(boolean invisible) {
        if (!invisible) {
            allModules.add(this);
        }
    }

    public void init(PositionEnum positionEnum) {
        switch (positionEnum) {
            case RIGHT: {
                modulesRight.add(this);
                break;
            }
            case LEFT: {
                modules.add(this);
                break;
            }
            case BOTH: {
                modulesRight.add(this);
                modules.add(this);
            }
        }
        allModules.add(this);
    }

    public void init() {
        modules.add(this);
        allModules.add(this);
    }

    public List<DebugLine> getLines() {
        return this.lines;
    }

    public List<ITextComponent> getLinesFormatted(boolean reducedDebug) {
        ArrayList<ITextComponent> linesString = new ArrayList<ITextComponent>();
        for (DebugLine line : this.lines) {
            if (reducedDebug && !line.inReducedDebug || !line.active || !line.enabled) continue;
            if (line instanceof DebugLineList) {
                DebugLineList lineList = (DebugLineList)line;
                linesString.addAll(lineList.toTexts(this.nameColor, this.valueColor));
                continue;
            }
            if (!line.isCustom) {
                linesString.add(line.toText(this.nameColor, this.valueColor));
                continue;
            }
            linesString.add(line.toTextCustom(this.nameColor));
        }
        return linesString;
    }

    public DebugLine getLine(String id) {
        Optional<DebugLine> lineOptional = this.lines.stream().filter(line -> line.getId().equals(id)).findFirst();
        return lineOptional.orElse(null);
    }

    public static BaseModule getModule(String string) {
        return allModules.stream().filter(baseModule -> baseModule.toString().equals(string)).findFirst().orElse(null);
    }

    public static BaseModule getModuleById(String id) {
        return allModules.stream().filter(baseModule -> baseModule.id.equals(id)).findFirst().orElse(null);
    }

    public String toString() {
        return I18n.func_135052_a((String)("text.betterf3.module." + this.id), (Object[])new Object[0]);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public abstract void update(Minecraft var1);
}

