/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import com.mojang.blaze3d.platform.PlatformDescriptors;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.ArrayUtils;

public class SystemModule
extends BaseModule {
    public SystemModule() {
        this.defaultNameColor = Color.func_240744_a_((TextFormatting)TextFormatting.GOLD);
        this.defaultValueColor = Color.func_240744_a_((TextFormatting)TextFormatting.AQUA);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("java_version"));
        this.lines.add(new DebugLine("memory_usage"));
        this.lines.add(new DebugLine("allocated_memory"));
        this.lines.add(new DebugLine("cpu"));
        this.lines.add(new DebugLine("display"));
        this.lines.add(new DebugLine("gpu"));
        this.lines.add(new DebugLine("opengl_version"));
        this.lines.add(new DebugLine("gpu_driver"));
        for (DebugLine line : this.lines) {
            line.inReducedDebug = true;
        }
    }

    @Override
    public void update(Minecraft client) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        MainWindow window = client.func_228018_at_();
        String javaVersion = String.format("%s %dbit", System.getProperty("java.version"), client.func_147111_S() ? 64 : 32);
        String memoryUsage = String.format("% 2d%% %03d/%03d MB", usedMemory * 100L / maxMemory, usedMemory / 1024L / 1024L, maxMemory / 1024L / 1024L);
        String allocatedMemory = String.format("% 2d%% %03dMB", totalMemory * 100L / maxMemory, totalMemory / 1024L / 1024L);
        String displayInfo = String.format("%d x %d (%s)", window.func_198109_k(), window.func_198091_l(), PlatformDescriptors.func_227774_a_());
        Object[] versionSplit = PlatformDescriptors.func_227777_d_().split(" ");
        String openGlVersion = versionSplit[0];
        String gpuDriverVersion = String.join((CharSequence)" ", (CharSequence[])ArrayUtils.remove((Object[])versionSplit, (int)0));
        ((DebugLine)this.lines.get(0)).setValue(javaVersion);
        ((DebugLine)this.lines.get(1)).setValue(Utils.getPercentColor((int)(usedMemory * 100L / maxMemory)) + memoryUsage);
        ((DebugLine)this.lines.get(2)).setValue(allocatedMemory);
        ((DebugLine)this.lines.get(3)).setValue(PlatformDescriptors.func_227775_b_());
        ((DebugLine)this.lines.get(4)).setValue(displayInfo);
        ((DebugLine)this.lines.get(5)).setValue(PlatformDescriptors.func_227776_c_());
        ((DebugLine)this.lines.get(6)).setValue(openGlVersion);
        ((DebugLine)this.lines.get(7)).setValue(gpuDriverVersion);
    }
}

