/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.utils;

import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TranslationTextComponent;

public class DebugLine {
    private Object value;
    private String format;
    private final String id;
    public boolean active = true;
    public boolean enabled = true;
    public boolean isCustom = false;
    public boolean inReducedDebug = false;

    public DebugLine(String id) {
        this.id = id.startsWith("nothing") ? "" : id;
        this.format = "format.betterf3.default_format";
        this.value = "";
    }

    public DebugLine(String id, String formatString, boolean isCustom) {
        this.id = id;
        this.value = "";
        this.format = formatString;
        this.isCustom = isCustom;
    }

    public ITextComponent toText(Color nameColor, Color valueColor) {
        String name = this.getName();
        IFormattableTextComponent nameStyled = Utils.getStyledText(name, nameColor);
        Object valueStyled = this.value instanceof ITextComponent ? (ITextComponent)this.value : Utils.getStyledText(this.value, valueColor);
        if (this.value == null || this.value.toString().equals("") || this.value.toString().isEmpty()) {
            this.active = false;
        }
        return new TranslationTextComponent(this.format, new Object[]{nameStyled, valueStyled});
    }

    public ITextComponent toTextCustom(Color nameColor) {
        String name = this.getName();
        if (this.value instanceof List) {
            ArrayList<IFormattableTextComponent> values = new ArrayList<IFormattableTextComponent>();
            List value = (List)this.value;
            if (!name.equals("")) {
                values.add(Utils.getStyledText(name, nameColor));
            }
            values.addAll(value);
            return new TranslationTextComponent(this.format, values.toArray()).func_240700_a_(style -> style.func_240718_a_(nameColor));
        }
        return new TranslationTextComponent(this.format, new Object[]{name, this.value});
    }

    public void setValue(Object value) {
        this.active = true;
        this.value = value;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getName() {
        if (this.id.isEmpty()) {
            this.format = "%s%s";
            return "";
        }
        LanguageMap language = LanguageMap.func_74808_a();
        return language.func_230503_a_("text.betterf3.line." + this.id);
    }

    public String getId() {
        return this.id;
    }
}

