local assets =
{
    Asset("ANIM", "anim/star_cold.zip")

}
local SMASHABLE_WORK_ACTIONS =
{
    CHOP = false,
    DIG = false,
    HAMMER = false,
    MINE = false,
	ATTACK = true,
}
local SMASHABLE_TAGS = { "_combat" }
for k, v in pairs(SMASHABLE_WORK_ACTIONS) do
    table.insert(SMASHABLE_TAGS, k.."_workable")
end
local NON_SMASHABLE_TAGS = { "INLIMBO", "playerghost" }




local function OnThrown(inst)

    inst:DoTaskInTime(0.8, inst.Remove)
	
	
end

local function OnHit(inst, owner, target)
 if  target:IsValid() then
 target.components.combat:GetAttacked(owner, 30, nil)
					target.components.combat:SuggestTarget(owner)
    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
  if target:HasTag("bird") then  target:PushEvent("flyaway") 
end					  	
	
	inst:Remove()
	else
		inst:Remove()
	end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
    inst.entity:AddNetwork()
	
    inst.AnimState:SetBank("star_cold")
    inst.AnimState:SetBuild("star_cold")
	inst.AnimState:PlayAnimation("idle_loop")
    inst.AnimState:PushAnimation("idle_loop", true)
	    inst.Transform:SetScale(0.5, 0.5, 0.5)

    inst:AddTag("projectile")
	    inst:AddTag("NOCLICK")
			    inst:AddTag("scarytoprey")
	

			
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

	
	    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(35)
	    inst.components.projectile:SetHoming(false)
    inst.components.projectile:SetHitDist(0.3)
	    inst.components.projectile:SetOnThrownFn(OnThrown)
		    inst.components.projectile:SetOnHitFn(OnHit)
			
    inst.persists = false


    return inst
end



return Prefab("diamondshot", fn, assets)
