local assets=
{
    Asset("ANIM", "anim/whitestaff.zip"),
    Asset("ANIM", "anim/swap_whitestaff.zip"),
 
    Asset("ATLAS", "images/inventoryimages/whitestaff.xml"),
    Asset("IMAGE", "images/inventoryimages/whitestaff.tex"),
}


local function onfinished(inst)

    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
    inst:Remove()
end

local function swingspell(inst, attacker, target)
	    attacker.SoundEmitter:PlaySound("dontstarve/wilson/attack_icestaff")
end

local function onattack(inst, attacker, target)
 attacker.components.sanity:DoDelta(-1)

end

local function OnEquip(inst, owner)
owner.components.combat.min_attack_period = 0.8
		owner.SoundEmitter:PlaySound("dontstarve/common/telebase_gemplace")
        owner.AnimState:OverrideSymbol("swap_object", "swap_whitestaff", "swap_whitestaff")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
end
	
 
local function OnUnequip(inst, owner)
owner.components.combat.min_attack_period = 0.4
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
end




local function fn(Sim)
    local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("whitestaff")
    inst.AnimState:SetBuild("whitestaff")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("nopunch")
    
      inst.entity:SetPristine()


    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("inspectable")
    







    
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)

	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "whitestaff"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/whitestaff.xml"
	
		inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
	inst.components.weapon:SetRange(7,13)
	inst.components.weapon:SetOnAttack(onattack)
    inst.components.weapon:SetProjectile("diamondshot")
		inst.components.weapon:SetOnProjectileLaunch(swingspell)


			inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
	   inst.components.finiteuses:SetOnFinished(onfinished) 


	     MakeHauntableLaunch(inst)

    
    return inst
end

return Prefab( "common/inventory/whitestaff", fn, assets) 
